package com.eugenefn.openapi.sample.view.data;

import java.util.ArrayList;
import java.util.HashMap;

public class FIDInfo {
    public String m_strId;
    public String m_strName;
    public boolean m_isReal;

    public FIDInfo(String strId, String strName, boolean isReal)
    {
        m_strId = strId;
        m_strName = strName;
        m_isReal = isReal;
    }

    public String getSelectName()
    {
        return String.format("[%s] %s", m_strId, m_strName);
    }

    // FID 정보 리스트 구성
    public static HashMap<String, FIDInfo> mapFIDInfo = new HashMap<>();
    public static ArrayList<FIDInfo> arrFIDInfo = new ArrayList<>();

    static {
        arrFIDInfo.add(new FIDInfo("9001", "현재가", true));
        arrFIDInfo.add(new FIDInfo("9002", "전일대비", true));
        arrFIDInfo.add(new FIDInfo("9003", "등락률", true));
        arrFIDInfo.add(new FIDInfo("9004", "매도호가", true));
        arrFIDInfo.add(new FIDInfo("9005", "매수호가", true));
        arrFIDInfo.add(new FIDInfo("9006", "매도잔량", true));
        arrFIDInfo.add(new FIDInfo("9007", "매수잔량", true));
        arrFIDInfo.add(new FIDInfo("9008", "현재거래량", true));
        arrFIDInfo.add(new FIDInfo("9009", "거래대금", true));
        arrFIDInfo.add(new FIDInfo("9010", "시가", true));
        arrFIDInfo.add(new FIDInfo("9011", "고가", true));
        arrFIDInfo.add(new FIDInfo("9012", "저가", true));
        arrFIDInfo.add(new FIDInfo("9013", "외인보유비중", true));
        arrFIDInfo.add(new FIDInfo("9014", "외인수량", true));
        arrFIDInfo.add(new FIDInfo("9015", "시가총액", true));
        arrFIDInfo.add(new FIDInfo("9016", "연중최고가", true));
        arrFIDInfo.add(new FIDInfo("9017", "연중최저가", true));
        arrFIDInfo.add(new FIDInfo("9018", "전일거래량", true));
        arrFIDInfo.add(new FIDInfo("9019", "시가등락률", true));
        arrFIDInfo.add(new FIDInfo("9020", "거래량대비율", true));
        arrFIDInfo.add(new FIDInfo("9021", "체결량", true));
        arrFIDInfo.add(new FIDInfo("9022", "액면가", true));
        arrFIDInfo.add(new FIDInfo("9023", "L일봉H", true));
        arrFIDInfo.add(new FIDInfo("9024", "시가%", true));
        arrFIDInfo.add(new FIDInfo("9025", "고가%", true));
        arrFIDInfo.add(new FIDInfo("9026", "저가%", true));
        arrFIDInfo.add(new FIDInfo("9027", "시가대비%", true));
        arrFIDInfo.add(new FIDInfo("9028", "저가대비%", true));
        arrFIDInfo.add(new FIDInfo("9029", "저가대비%", true));
        arrFIDInfo.add(new FIDInfo("9030", "예상체결가", true));
        arrFIDInfo.add(new FIDInfo("9031", "예상체결량", true));
        arrFIDInfo.add(new FIDInfo("9032", "예상등락률", true));
        arrFIDInfo.add(new FIDInfo("9033", "전일종가", true));
        arrFIDInfo.add(new FIDInfo("9034", "전일시가", true));
        arrFIDInfo.add(new FIDInfo("9035", "전일고가", true));
        arrFIDInfo.add(new FIDInfo("9036", "전일저가", true));
        arrFIDInfo.add(new FIDInfo("9037", "체결강도", true));
        arrFIDInfo.add(new FIDInfo("9038", "상한가", true));
        arrFIDInfo.add(new FIDInfo("9039", "하한가", true));
        arrFIDInfo.add(new FIDInfo("9040", "매도총잔량", true));
        arrFIDInfo.add(new FIDInfo("9041", "매수총잔량", true));
        arrFIDInfo.add(new FIDInfo("9042", "총순매매잔량", true));
        arrFIDInfo.add(new FIDInfo("9043", "신용비율", true));
        arrFIDInfo.add(new FIDInfo("9044", "공매도비율", true));
        arrFIDInfo.add(new FIDInfo("9045", "신용", true));
        arrFIDInfo.add(new FIDInfo("9046", "시간외등락률", true));
        arrFIDInfo.add(new FIDInfo("9047", "시간외현재가", true));
        arrFIDInfo.add(new FIDInfo("9048", "시간외매도호가", true));
        arrFIDInfo.add(new FIDInfo("9049", "시간외매수호가", true));
        arrFIDInfo.add(new FIDInfo("9050", "시간외매도잔량", true));
        arrFIDInfo.add(new FIDInfo("9051", "시간외매수잔량", true));
        arrFIDInfo.add(new FIDInfo("9052", "52주 최고가", true));
        arrFIDInfo.add(new FIDInfo("9053", "52주 최저가", true));
        arrFIDInfo.add(new FIDInfo("9054", "52주 최고가 대비율", true));
        arrFIDInfo.add(new FIDInfo("9055", "52주 최저가 대비율", true));
        arrFIDInfo.add(new FIDInfo("9056", "연중 최고가 대비율", false));
        arrFIDInfo.add(new FIDInfo("9057", "연중 최저가 대비율", false));
        arrFIDInfo.add(new FIDInfo("9058", "시가총액(재무)", true));
        arrFIDInfo.add(new FIDInfo("9059", "업종구분", true));
        arrFIDInfo.add(new FIDInfo("9060", "ROE", true));
        arrFIDInfo.add(new FIDInfo("9061", "당기순이익(최근)", true));
        arrFIDInfo.add(new FIDInfo("9062", "영업이익(최근)", true));
        arrFIDInfo.add(new FIDInfo("9063", "EPS", true));
        arrFIDInfo.add(new FIDInfo("9064", "PER", true));
        arrFIDInfo.add(new FIDInfo("9065", "PBR", true));
        arrFIDInfo.add(new FIDInfo("9066", "EV/EBITDA", true));
        arrFIDInfo.add(new FIDInfo("9068", "자본금", true));
        arrFIDInfo.add(new FIDInfo("9069", "증거금률", true));
        arrFIDInfo.add(new FIDInfo("9070", "결산기", true));
        arrFIDInfo.add(new FIDInfo("9073", "전일외국인순매수량", true));
        arrFIDInfo.add(new FIDInfo("9074", "전일기관순매수량", true));
        arrFIDInfo.add(new FIDInfo("9075", "5일평균", false));
        arrFIDInfo.add(new FIDInfo("9076", "10일평균", false));
        arrFIDInfo.add(new FIDInfo("9077", "20일평균", false));
        arrFIDInfo.add(new FIDInfo("9078", "5일평균이격도", false));
        arrFIDInfo.add(new FIDInfo("9079", "10일평균이격도", false));
        arrFIDInfo.add(new FIDInfo("9080", "20일평균이격도", false));

        for(FIDInfo info : arrFIDInfo)
            mapFIDInfo.put(info.m_strId, info);
    }
}
