package com.eugenefn.openapi.sample.view.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.text.InputFilter;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.eugenefn.openapi.intrf.ICertDeleteListener;
import com.eugenefn.openapi.proc.SmartChampAPI;
import com.eugenefn.openapi.sample.view.control.CertSelectSpinner;
import com.eugenefn.openapi.sample.view.util.LayoutUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

public class CertDeleteDialog extends Dialog
    implements ICertDeleteListener
{
    private String m_strCertDN;
    private CertSelectSpinner m_spinnerCert;

    private EditText m_editCertPwd;

    private Activity m_activity;

    public CertDeleteDialog(@NonNull Context context) {
        super(context);
    }

    public void show(Activity activity)
    {
        m_activity = activity;

        initLayout(getContext());

        super.show();
    }

    private void initLayout(Context context)
    {
        LinearLayout layoutFrame = new LinearLayout(context);
        layoutFrame.setOrientation(LinearLayout.VERTICAL);

        TextView viewTitle = LayoutUtil.makeTextView(context, "인증서 삭제");

        int nLinePadding = (int)SampleUtil.dipToPixels(context, 10);
        int nLineHeight =  (int)SampleUtil.dipToPixels(context, 50);
        int nButtonWidth = (int)SampleUtil.dipToPixels(context, 100);

        m_spinnerCert = new CertSelectSpinner(context);
        m_spinnerCert.setCertList(SmartChampAPI.getInstance().getUserCertList());
        m_spinnerCert.setCertDN(SampleUtil.getConfig(getContext(), "cert_dn", ""));

        m_spinnerCert.setOnCertSelectedListener(new CertSelectSpinner.OnCertSelectedListener()
        {
            @Override
            public void onCertSelected(String strDN)
            {
                m_strCertDN = strDN;
            }

        });

        m_editCertPwd = LayoutUtil.makeEditView(getContext(), "");
        LayoutUtil.setEditText(m_editCertPwd, false, false);
        m_editCertPwd.setFilters(new InputFilter[] { new InputFilter.LengthFilter(30)});

        Button button = LayoutUtil.makeCtrlButton(context, 100, "삭제");
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                deleteCert();
            }
        });

        LinearLayout.LayoutParams paramTitle = new LinearLayout.LayoutParams(nButtonWidth * 2, nLineHeight);
        paramTitle.setMargins(nLinePadding, nLinePadding, nLinePadding, nLinePadding);
        layoutFrame.addView(viewTitle, paramTitle);

        LinearLayout.LayoutParams paramCert = new LinearLayout.LayoutParams((int)(nButtonWidth * 2.5), nLineHeight);
        paramCert.setMargins(nLinePadding, nLinePadding, nLinePadding, nLinePadding);
        layoutFrame.addView(m_spinnerCert, paramCert);

        LinearLayout layoutPwd = new LinearLayout(context);
        layoutPwd.setOrientation(LinearLayout.HORIZONTAL);
        layoutPwd.addView(LayoutUtil.makeTextView(context, "인증서비밀번호"), new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, nLineHeight));
        layoutPwd.addView(m_editCertPwd, new LinearLayout.LayoutParams(0, nLineHeight, 1));

        LinearLayout.LayoutParams paramButton = new LinearLayout.LayoutParams(nButtonWidth, nLineHeight);
        paramButton.gravity = Gravity.CENTER_HORIZONTAL;
        paramButton.setMargins(nLinePadding, nLinePadding, nLinePadding, nLinePadding);
        layoutFrame.addView(button, paramButton);

        layoutFrame.setPadding(nLinePadding, nLinePadding, nLinePadding, nLinePadding);

        setContentView(layoutFrame);
    }

    private void deleteCert()
    {
        if(TextUtils.isEmpty(m_strCertDN))
        {
            Toast.makeText(getContext(), "인증서가 선택되지 않았습니다.", Toast.LENGTH_SHORT).show();
            return;
        }

        String strCertPwd = m_editCertPwd.getText().toString();
        if(TextUtils.getTrimmedLength(strCertPwd) <= 0)
        {
            Toast.makeText(getContext(), "인증서 비밀번호가 입력되지 않았습니다.", Toast.LENGTH_SHORT).show();
            return;
        }

        SmartChampAPI.getInstance().deleteCert(m_strCertDN, strCertPwd, this);
    }

    @Override
    public void onCertDeleteResult(boolean isSuccess, String strMessage) {
        Toast.makeText(getContext(), strMessage, Toast.LENGTH_SHORT).show();

        if(isSuccess)
            dismiss();
    }
}
