package com.eugenefn.openapi.sample.view.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.eugenefn.openapi.intrf.ICertExportListener;
import com.eugenefn.openapi.proc.SmartChampAPI;
import com.eugenefn.openapi.sample.view.control.CertSelectSpinner;
import com.eugenefn.openapi.sample.view.util.LayoutUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

public class CertExportDialog extends Dialog
    implements ICertExportListener
{
    private String m_strCertDN;
    private CertSelectSpinner m_spinnerCert;
    private EditText     m_editCertPwd;
    private EditText m_edit1;
    private EditText m_edit2;
    private EditText m_edit3;

    private Activity m_activity;

    public CertExportDialog(@NonNull Context context) {
        super(context);
    }

    public void show(Activity activity)
    {
        m_activity = activity;

        initLayout(getContext());

        super.show();
    }

    private void initLayout(Context context)
    {
        LinearLayout layoutFrame = new LinearLayout(context);
        layoutFrame.setOrientation(LinearLayout.VERTICAL);

        TextView viewTitle = LayoutUtil.makeTextView(context, "인증서 내보내기");

        int nLinePadding = (int)SampleUtil.dipToPixels(context, 10);
        int nLineHeight =  (int)SampleUtil.dipToPixels(context, 50);
        int nButtonWidth = (int)SampleUtil.dipToPixels(context, 100);
        int nEditWidth = (int)SampleUtil.dipToPixels(context, 60);
        int nEditPadding = (int)SampleUtil.dipToPixels(context, 10);

        m_spinnerCert = new CertSelectSpinner(context);
        m_spinnerCert.setCertList(SmartChampAPI.getInstance().getUserCertList());
        m_spinnerCert.setCertDN(SampleUtil.getConfig(getContext(), "cert_dn", ""));

        m_spinnerCert.setOnCertSelectedListener(new CertSelectSpinner.OnCertSelectedListener()
        {
            @Override
            public void onCertSelected(String strDN)
            {
                m_strCertDN = strDN;

                SampleUtil.getConfig(getContext(), "cert_dn", strDN);
            }
        });

        m_editCertPwd = LayoutUtil.makeEditView(getContext(), "");
        LayoutUtil.setEditText(m_editCertPwd, false, false);
        m_editCertPwd.setFilters(new InputFilter[] { new InputFilter.LengthFilter(30)});

        m_edit1 = LayoutUtil.makeEditView(context, "");
        m_edit1.setFilters(new InputFilter[] { new InputFilter.LengthFilter(4)});
        m_edit1.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) { }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) { }

            @Override
            public void afterTextChanged(Editable s) {
                if(s.length() == 4) m_edit2.requestFocus();
            }
        });
        m_edit2 = LayoutUtil.makeEditView(context, "");
        m_edit2.setFilters(new InputFilter[] { new InputFilter.LengthFilter(4)});
        m_edit2.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) { }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) { }

            @Override
            public void afterTextChanged(Editable s) {
                if(s.length() == 4) m_edit3.requestFocus();
            }
        });
        m_edit3 = LayoutUtil.makeEditView(context, "");
        m_edit3.setFilters(new InputFilter[] { new InputFilter.LengthFilter(4)});

        Button button = LayoutUtil.makeCtrlButton(context, 100, "내보내기");
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                exportCert();
            }
        });

        LinearLayout.LayoutParams paramTitle = new LinearLayout.LayoutParams(nButtonWidth * 2, nLineHeight);
        paramTitle.setMargins(nLinePadding, nLinePadding, nLinePadding, nLinePadding);
        layoutFrame.addView(viewTitle, paramTitle);

        LinearLayout.LayoutParams paramCert = new LinearLayout.LayoutParams((int)(nButtonWidth * 2.5), nLineHeight);
        paramCert.setMargins(nLinePadding, nLinePadding, nLinePadding, nLinePadding);
        layoutFrame.addView(m_spinnerCert, paramCert);

        LinearLayout layoutPwd = new LinearLayout(context);
        layoutPwd.setOrientation(LinearLayout.HORIZONTAL);
        layoutPwd.addView(LayoutUtil.makeTextView(context, "인증서비밀번호"), new LinearLayout.LayoutParams(LayoutParams.WRAP_CONTENT, nLineHeight));
        layoutPwd.addView(m_editCertPwd, new LinearLayout.LayoutParams(0, nLineHeight, 1));

        LinearLayout.LayoutParams paramPwd = new LinearLayout.LayoutParams((int)(nButtonWidth * 2.5), nLineHeight);
        paramPwd.setMargins(nLinePadding, nLinePadding, nLinePadding, nLinePadding);
        layoutFrame.addView(layoutPwd, paramPwd);

        LinearLayout layoutInputs = new LinearLayout(context);
        layoutInputs.setOrientation(LinearLayout.HORIZONTAL);
        layoutInputs.addView(LayoutUtil.makeTextView(context, "승인번호"), new LinearLayout.LayoutParams(LayoutParams.WRAP_CONTENT, nLineHeight));
        layoutInputs.addView(m_edit1, new LinearLayout.LayoutParams(nEditWidth, nLineHeight));
        layoutInputs.addView(m_edit2, new LinearLayout.LayoutParams(nEditWidth, nLineHeight));
        layoutInputs.addView(m_edit3, new LinearLayout.LayoutParams(nEditWidth, nLineHeight));

        LinearLayout.LayoutParams paramRandom = new LinearLayout.LayoutParams(LayoutParams.WRAP_CONTENT, nLineHeight);
        paramRandom.setMargins(nLinePadding, nLinePadding, nLinePadding, nLinePadding);
        paramRandom.gravity = Gravity.CENTER_HORIZONTAL;
        layoutFrame.addView(layoutInputs, paramRandom);

        LinearLayout.LayoutParams paramButton = new LinearLayout.LayoutParams(nButtonWidth, nLineHeight);
        paramButton.gravity = Gravity.CENTER_HORIZONTAL;
        paramButton.setMargins(nLinePadding, nLinePadding, nLinePadding, nLinePadding);
        layoutFrame.addView(button, paramButton);

        layoutFrame.setPadding(nLinePadding, nLinePadding, nLinePadding, nLinePadding);

        setContentView(layoutFrame);
    }

    private void exportCert()
    {
        if(TextUtils.isEmpty(m_strCertDN))
        {
            Toast.makeText(getContext(), "인증서가 선택되지 않았습니다.", Toast.LENGTH_SHORT).show();
            return;
        }

        String strCertPwd = m_editCertPwd.getText().toString();
        if(TextUtils.getTrimmedLength(strCertPwd) <= 0)
        {
            Toast.makeText(getContext(), "인증서 비밀번호가 입력되지 않았습니다.", Toast.LENGTH_SHORT).show();
            return;
        }

        String strEdit1 = m_edit1.getText().toString();
        String strEdit2 = m_edit2.getText().toString();
        String strEdit3 = m_edit3.getText().toString();

        if(TextUtils.getTrimmedLength(strEdit1) != 4 || TextUtils.getTrimmedLength(strEdit2) != 4 ||
        TextUtils.getTrimmedLength(strEdit3) != 4)
        {
            Toast.makeText(getContext(), "승인번호가 입력되지 않았습니다.", Toast.LENGTH_SHORT).show();
            return;
        }

        SmartChampAPI.getInstance().exportCert(m_strCertDN, strCertPwd, strEdit1 + strEdit2 + strEdit3, this);
    }

    @Override
    public void onCertExportResult(boolean isSuccess, String strMessage) {

        Toast.makeText(getContext(), strMessage, Toast.LENGTH_SHORT).show();

        if(isSuccess)
        {
            dismiss();
        }
    }
}
