package com.eugenefn.openapi.sample.view.dialog;

import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.eugenefn.openapi.intrf.ICertImportListener;
import com.eugenefn.openapi.proc.SmartChampAPI;
import com.eugenefn.openapi.sample.view.util.LayoutUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

public class CertImportDialog extends Dialog
    implements ICertImportListener
{
    private TextView m_viewRandom;
    public boolean m_isSuccess = false;

    public CertImportDialog(@NonNull Context context) {
        super(context);
    }

    public void show()
    {
        initLayout(getContext());

        super.show();

        SmartChampAPI.getInstance().requestCertImportNumber(CertImportDialog.this);
    }

    private void initLayout(Context context)
    {
        LinearLayout layoutFrame = new LinearLayout(context);
        layoutFrame.setOrientation(LinearLayout.VERTICAL);

        TextView viewTitle = LayoutUtil.makeTextView(context, "인증서 가져오기");

        m_viewRandom = LayoutUtil.makeTextView(context, "");

        int nLinePadding = (int)SampleUtil.dipToPixels(context, 10);
        int nLineHeight =  (int)SampleUtil.dipToPixels(context, 50);
        int nButtonWidth = (int)SampleUtil.dipToPixels(context, 100);
        int nButtonSpacing = (int)SampleUtil.dipToPixels(context, 10);

        Button button = LayoutUtil.makeCtrlButton(context, 100, "가져오기");
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                SmartChampAPI.getInstance().importCert(CertImportDialog.this);
            }
        });

        Button button2 = LayoutUtil.makeCtrlButton(context, 101, "승인번호 재생성");
        button2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                SmartChampAPI.getInstance().requestCertImportNumber(CertImportDialog.this);
            }
        });

        LinearLayout.LayoutParams paramTitle = new LinearLayout.LayoutParams(nButtonWidth * 2, nLineHeight);
        paramTitle.setMargins(nLinePadding, nLinePadding, nLinePadding, nLinePadding);
        layoutFrame.addView(viewTitle, paramTitle);

        LinearLayout.LayoutParams paramRandom = new LinearLayout.LayoutParams(nButtonWidth * 2, nLineHeight);
        paramRandom.setMargins(nLinePadding, nLinePadding, nLinePadding, nLinePadding);
        paramRandom.gravity = Gravity.CENTER_HORIZONTAL;
        layoutFrame.addView(m_viewRandom, paramRandom);

        LinearLayout layoutButtons = new LinearLayout(context);
        layoutButtons.setOrientation(LinearLayout.HORIZONTAL);
        layoutButtons.addView(button, new LinearLayout.LayoutParams(nButtonWidth, nLineHeight));
        layoutButtons.addView(button2, new LinearLayout.LayoutParams(nButtonWidth * 2, nLineHeight));

        LinearLayout.LayoutParams paramButton = new LinearLayout.LayoutParams(LayoutParams.WRAP_CONTENT, nLineHeight);
        paramButton.gravity = Gravity.CENTER_HORIZONTAL;
        paramButton.setMargins(nLinePadding, nLinePadding, nLinePadding, nLinePadding);
        layoutFrame.addView(layoutButtons, paramButton);

        layoutFrame.setPadding(nLinePadding, nLinePadding, nLinePadding, nLinePadding);

        setContentView(layoutFrame);
    }

    @Override
    public void onCertImportNumber(boolean isSuccess, String strRandom, String strMessage)
    {
        if(isSuccess) {
            m_viewRandom.setText(strRandom.substring(0, 4) + "-" + strRandom.substring(4, 8) + "-" + strRandom.substring(8));
        } else {
            Toast.makeText(getContext(), strMessage, Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    public void onCertImportResult(boolean isSuccess, String strCertDN, String strMessage) {

        Toast.makeText(getContext(), strMessage, Toast.LENGTH_SHORT).show();

        if(isSuccess)
        {
            m_isSuccess = true;
            SampleUtil.setConfig(getContext(), "cert_dn", strCertDN);
            dismiss();
        }
    }
}
