package com.eugenefn.openapi.sample.view.screen;

import android.app.Activity;
import android.content.Context;
import android.widget.FrameLayout;

import androidx.annotation.NonNull;

import com.eugenefn.openapi.sample.view.util.SampleUtil;

public class SiseBaseView extends FrameLayout
{
    protected Activity m_activity;

    // 레이아웃 구성
    protected int					TITLE_WIDTH = 100;
    protected int                   TITLE_HEIGHT = 30;
    protected int					INPUT_WIDTH = 200;
    protected int					PADDING_H = 10;
    protected int					PADDING_V = 10;

    public SiseBaseView(@NonNull Context context)
    {
        super(context);

        TITLE_WIDTH = (int) SampleUtil.dipToPixels(context, 80);
        TITLE_HEIGHT = (int) SampleUtil.dipToPixels(context, 30);
        INPUT_WIDTH = (int)SampleUtil.dipToPixels(context, 200);
        PADDING_H = (int)SampleUtil.dipToPixels(context, 10);
        PADDING_V = (int)SampleUtil.dipToPixels(context, 2);
    }

    public void initView(Context context, Activity activity)
    {
        m_activity = activity;
    }

    public void releaseView()
    {

    }

    public boolean onBackPressed()
    {
        return false;
    }

    public void onRefreshView()
    {

    }
}
