package com.eugenefn.openapi.sample.view.util;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;

public class ColorUtil
{
	public static final int NOR_TEXT_COLOR = Color.rgb(90, 90, 90);

	public static final int RISE = Color.RED;
	public static final int FALL = Color.BLUE;
	public static final int STAY = NOR_TEXT_COLOR;

	public static final int TRANSPARENT = Color.argb(0, 0, 0, 0);

	public static final int SECTION_SEP_LINE = Color.LTGRAY;
	public static final int LIST_SEP_LINE = Color.LTGRAY;
	public static final int GRID_HEADER_BACK = Color.rgb(248, 248, 248);
	public static final int SECTION_INPUT_BACK = Color.rgb(240, 240, 240);
	public static final int BUTTON_BACK = Color.LTGRAY;

	public static int getAlphaColor(int nColor, int nAlpha)
	{
		return Color.argb((int)(255f * (float)nAlpha / 100f), Color.red(nColor), Color.green(nColor), Color.blue(nColor));
	}

	public static int getColor(Context context, int nColorId)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return context.getColor(nColorId);
		} else {
			return context.getResources().getColor(nColorId);
		}
	}
}
