package com.eugenefn.openapi.sample.view.util;

import android.content.Context;
import android.text.InputType;
import android.text.method.PasswordTransformationMethod;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

public class LayoutUtil {

    public static TextView makeTextView(Context context, String strText)
    {
        return LayoutUtil.makeTextView(context, strText, 14, ColorUtil.NOR_TEXT_COLOR);
    }

    public static TextView makeTextView(Context context, String strText, boolean isSingleLine)
    {
        TextView view = LayoutUtil.makeTextView(context, strText, 14, ColorUtil.NOR_TEXT_COLOR);
        if(!isSingleLine) view.setSingleLine(false);
        return view;
    }

    public static TextView makeTextView(Context context, String strText, int nTextDip, int nTextColor)
    {
        TextView viewText = new TextView(context);
        viewText.setTextColor(nTextColor);
        viewText.setTextSize(TypedValue.COMPLEX_UNIT_DIP, nTextDip);
        viewText.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
        viewText.setText(strText);
        viewText.setSingleLine();

        return viewText;
    }

    //Edit view 생성
    public static EditText makeEditView(Context context, String strText)
    {
        EditText viewEdit = new EditText(context);
        viewEdit.setTextColor(ColorUtil.NOR_TEXT_COLOR);
        viewEdit.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        viewEdit.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
        viewEdit.setText(strText);
        viewEdit.setSingleLine();

        return viewEdit;
    }

    //Edit 속성 생성
    public static void setEditText(EditText viewEdit, boolean isNormal, boolean isNumber)
    {
        viewEdit.setLongClickable(false);
        viewEdit.setFocusableInTouchMode(true);
        viewEdit.setFocusable(true);
        viewEdit.setEllipsize(null);
        viewEdit.setPrivateImeOptions("defaultInputmode=english;");
        viewEdit.setImeOptions(EditorInfo.IME_ACTION_DONE);

        if(isNormal)
        {
            if(isNumber)
                viewEdit.setInputType(InputType.TYPE_CLASS_NUMBER);
            else
                viewEdit.setInputType(InputType.TYPE_TEXT_VARIATION_URI | InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);
        }
        else
        {
            if(isNumber)
                viewEdit.setInputType(InputType.TYPE_CLASS_NUMBER |InputType.TYPE_TEXT_VARIATION_PASSWORD);
            else
                viewEdit.setInputType(InputType.TYPE_CLASS_TEXT |InputType.TYPE_TEXT_VARIATION_PASSWORD);
            viewEdit.setTransformationMethod(PasswordTransformationMethod.getInstance());
        }
    }

    //Button view 생성
    public static Button makeCtrlButton(Context context, int nCtrlId, String strText)
    {
        Button button = new Button(context);
        button.setTextColor(ColorUtil.NOR_TEXT_COLOR);
        button.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        button.setGravity(Gravity.CENTER);
        button.setText(strText);
        button.setSingleLine();
        button.setId(nCtrlId);
        button.setMinimumWidth((int)SampleUtil.dipToPixels(context, 30));

        int nPaddingH = (int)SampleUtil.dipToPixels(context, 10);;
        button.setPadding(nPaddingH, 0, nPaddingH, 0);

        return button;
    }

    public static CheckBox makeCheckBox(Context context, int nCtrlId, String strText)
    {
        CheckBox box = new CheckBox(context);

        box.setText(strText);
        box.setId(nCtrlId);
        box.setTextColor(ColorUtil.NOR_TEXT_COLOR);
        box.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);

        return box;
    }

    public static void addSepLine(Context context, LinearLayout layout, int nColor, int nDip)
    {
        View view = new View(context);
        view.setBackgroundColor(nColor);
        if(layout.getOrientation() == LinearLayout.VERTICAL) {
            layout.addView(view,
                    new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT,
                            (int) SampleUtil.dipToPixels(context, nDip)));
        } else {
            layout.addView(view,
                    new LinearLayout.LayoutParams((int) SampleUtil.dipToPixels(context, nDip),
                            LinearLayout.LayoutParams.MATCH_PARENT));
        }
    }
}
