package com.eugenefn.openapi.sample.view.util;

import java.text.DecimalFormat;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.UnderlineSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;

import com.eugenefn.openapi.proc.SmartChampDefs;

public class SampleUtil
{
	public static DecimalFormat m_formatIntValue = new DecimalFormat("###,###,##0");
	public static DecimalFormat m_formatFloatValue = new DecimalFormat("###,###,##0.#");
	public static DecimalFormat m_formatF2Value = new DecimalFormat("###,###,##0.00");	// 선옵
	public static DecimalFormat m_formatF4Value = new DecimalFormat("###,###,##0.0000");	// 해외주식
	
	public static float dipToPixels(Context context, float dipValue)
	{
	    DisplayMetrics metrics = context.getResources().getDisplayMetrics();
	    return TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dipValue, metrics);
	}
	
	public static int getIntValue(String strValue)
	{
		if(strValue == null) return 0;
		strValue = strValue.trim();
		if(strValue.isEmpty()) return 0;
		
		try {
			return Integer.parseInt(strValue);
		} catch(NumberFormatException exNF)
		{
		
		}
		
		return 0;
	}
	
	public static double getDoubleValue(String strValue)
	{
		if(strValue == null) return 0f;
		strValue = strValue.trim();
		if(strValue.isEmpty()) return 0f;
		
		try {
			return Double.parseDouble(strValue);
		} catch(NumberFormatException exNF)
		{
		
		}
		
		return 0f;
	}

	public static void setIntValue(TextView view, String strValue)
	{
		setIntValue(view, strValue, 0, "", "");
	}

	public static void setIntValue(TextView view, String strValue, String strPrefix, String strPostfix)
	{
		setIntValue(view, strValue, 0, strPrefix, strPostfix);
	}

	public static void setIntValue(TextView view, String strValue, int nAttr)
	{
		setIntValue(view, strValue, nAttr, "", "");
	}

	public static void setIntValue(TextView view, String strValue, int nAttr, String strPrefix, String strPostfix)
	{
		int nValue = getIntValue(strValue);
		
		view.setText(strPrefix + m_formatIntValue.format(nValue) + strPostfix);
		view.setTextColor(getValueColor(nAttr));
	}

	public static void setFloatValue(TextView view, String strValue)
	{
		setFloatValue(view, strValue, 0, "", "");
	}

	public static void setFloatValue(TextView view, String strValue, String strPrefix, String strPostfix)
	{
		setFloatValue(view, strValue, 0, strPrefix, strPostfix);
	}

	public static void setFloatValue(TextView view, String strValue, int nAttr)
	{
		setFloatValue(view, strValue, nAttr, "", "");
	}

	public static void setFloatValue(TextView view, String strValue, int nAttr, String strPrefix, String strPostfix)
	{
		double fValue = getDoubleValue(strValue);

		view.setText(strPrefix + m_formatFloatValue.format(fValue) + strPostfix);
		view.setTextColor(getValueColor(nAttr));
	}

	public static void setF2Value(TextView view, String strValue, int nAttr)
	{
		setF2Value(view, strValue, nAttr, "", "");
	}

	public static void setF22Value(TextView view, String strValue, int nAttr)
	{
		setF22Value(view, strValue, nAttr, "", "");
	}

	public static void setF2Value(TextView view, String strValue, int nAttr, String strPrefix, String strPostfix)
	{
		float fValue = (float)Math.round(getDoubleValue(strValue) * 100) / 100;
		
		view.setText(strPrefix + m_formatF2Value.format(fValue) + strPostfix);
		view.setTextColor(getValueColor(nAttr));
	}

	public static void setF22Value(TextView view, String strValue, int nAttr, String strPrefix, String strPostfix)
	{
		float fValue = (float)Math.round(getDoubleValue(strValue)) / 100;

		view.setText(strPrefix + m_formatF2Value.format(fValue) + strPostfix);
		view.setTextColor(getValueColor(nAttr));
	}

	public static void setF4Value(TextView view, String strValue, int nAttr)
	{
		setF4Value(view, strValue, nAttr, "", "");
	}

	public static void setF4Value(TextView view, String strValue, int nAttr, String strPrefix, String strPostfix)
	{
		float fValue = (float)Math.round(getDoubleValue(strValue) * 10000) / 10000;

		view.setText(strPrefix + m_formatF4Value.format(fValue) + strPostfix);
		view.setTextColor(getValueColor(nAttr));
	}

	public static void setSignValue(TextView view, String strSign, int nAttr)
	{
		view.setText(getValueSign(strSign));
		view.setTextColor(getValueColor(nAttr));
	}
	
	public static int getValueColor(int nAttr)
	{
		switch(nAttr) {
			case SmartChampDefs.DATA_ATTR_RED:
			case SmartChampDefs.DATA_ATTR_RED_R:
				return ColorUtil.RISE;
			case SmartChampDefs.DATA_ATTR_BLUE:
			case SmartChampDefs.DATA_ATTR_BLUE_R:
				return ColorUtil.FALL;
			case SmartChampDefs.DATA_ATTR_GREEN:
				return ColorUtil.STAY;
		}

		return ColorUtil.STAY;
	}
	
	public static String getValueSign(String strSign)
	{
		if(TextUtils.isEmpty(strSign)) return "";

		char chSign = strSign.charAt(0);

		switch(chSign)
		{
		case '1':	return "↑";	// 상한
		case '2':
		case '+':	return "▲";	// 상승
		case '3':
		case ' ':	return "";	// 보합
		case '4':	return "↓";	// 하한
		case '5':
		case '-':	return "▼";	// 하락
		}

		return "";
	}

	public static void setDateValue(TextView view, String strValue)
	{
		if(TextUtils.isEmpty(strValue))
			view.setText("");
		else if(strValue.length() >= 8)
		{
			view.setText(strValue.substring(0, 4) + "/" + strValue.substring(4, 6) + "/" + strValue.substring(6, 8));
		}
		else if(strValue.length() >= 6) {
			view.setText(strValue.substring(0, 2) + "/" + strValue.substring(2, 4) + "/" + strValue.substring(4, 6));
		}
		else if(strValue.length() >= 4)
		{
			view.setText(strValue.substring(0, 2) + "/" + strValue.substring(2, 4));
		} else {
			view.setText(strValue);
		}
	}

	public static void setTimeValue(TextView view, String strValue)
	{
		if(TextUtils.isEmpty(strValue))
			view.setText("");
		else if(strValue.length() > 6)
		{
			view.setText(strValue.substring(0, 2) + ":" + strValue.substring(2, 4) + ":" + strValue.substring(4, 6) + "." + strValue.substring(6));
		}
		else if(strValue.length() > 4) {
			view.setText(strValue.substring(0, 2) + ":" + strValue.substring(2, 4) + ":" + strValue.substring(4, 6));
		} else {
			view.setText(strValue);
		}
	}

	public static SpannableString getUnderLineText(String data )
	{
		SpannableString content = new SpannableString( data );
		content.setSpan( new UnderlineSpan(), 0, content.length(), 0 );
		return content;
	}

	public static void setConfig(Context context, String strKey, String strValue)
	{
		SharedPreferences pref = context.getSharedPreferences("config", Context.MODE_PRIVATE);
		SharedPreferences.Editor edit = pref.edit();
		edit.putString(strKey, strValue);
		edit.commit();
	}

	public static String getConfig(Context context, String strKey, String strDefault)
	{
		SharedPreferences pref = context.getSharedPreferences("config", Context.MODE_PRIVATE);
		return pref.getString(strKey, strDefault);
	}

	public static void hideKeyPad(Context context, EditText view)
	{
		InputMethodManager imm = (InputMethodManager)context.getSystemService(InputMethodManager.class);
		imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
		view.clearFocus();
	}

	public static void writeLog(String strTag, String strMessage)
	{
		Log.d(strTag, strMessage);
	}

	public static String getVersionInfo(Context context)
	{
		try {
			PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
			return pi.versionName;
		} catch (PackageManager.NameNotFoundException e) {
			e.printStackTrace();
		}

		return "unknown";
	}
}
