package com.eugenefn.openapi.sample.view.view;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.eugenefn.openapi.sample.view.data.CheMicheInfo;
import com.eugenefn.openapi.sample.view.util.ColorUtil;
import com.eugenefn.openapi.sample.view.util.LayoutUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

import java.util.ArrayList;

public class CheMicheListView
        extends RecyclerView
{
    private int ITEM_FONT_SIZE = 14;
    private int ITEM_TEXT_COLOR = ColorUtil.NOR_TEXT_COLOR;

    private int PADDING_H = 10;
    private int ITEM_HEIGHT = 30;
    private int COL2_WIDTH = 100;
    private int COL3_WIDTH = 100;
    private int COL4_WIDTH = 100;

    // 소수점 자리수 정의
    // 국내 - 0, 선옵 - 2, 해외주식 - 4
    private int m_nDecimalMode = 0;

    private ArrayList<CheMicheInfo> m_arrList = new ArrayList<>();
    private DataListAdapter m_adapter;

    private OnCheMicheListListener m_listener;
    public interface OnCheMicheListListener
    {
        public abstract void onCheMicheItemClicked(CheMicheInfo info);
        public abstract void onCheMicheScrollEnd();
    }

    public CheMicheListView(Context context, int nDecimalMode, OnCheMicheListListener listener)
    {
        super(context);

        m_listener = listener;
        m_nDecimalMode = nDecimalMode;

        PADDING_H = (int)SampleUtil.dipToPixels(context, 10);

        ITEM_HEIGHT = (int)SampleUtil.dipToPixels(context, 30);
        COL2_WIDTH = (int)SampleUtil.dipToPixels(context, 100);
        COL3_WIDTH = (int)SampleUtil.dipToPixels(context, 100);
        COL4_WIDTH = (int)SampleUtil.dipToPixels(context, 120);

        setFocusable(false);
        setLayoutManager(new LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false));
        m_adapter = new DataListAdapter();
        setAdapter(m_adapter);

        DividerItemDecoration divider = new DividerItemDecoration(context, DividerItemDecoration.VERTICAL);
        divider.setDrawable(new ColorDrawable(ColorUtil.LIST_SEP_LINE));
        addItemDecoration(divider);

        addOnScrollListener(new OnScrollListener() {
            @Override
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);

                if(!recyclerView.canScrollVertically(1) && (newState == SCROLL_STATE_IDLE))
                {
                    // 마지막...
                    if(m_listener != null)
                        m_listener.onCheMicheScrollEnd();
                }
            }
        });

    }

    public void clearList()
    {
        m_arrList.clear();

        m_adapter.notifyDataSetChanged();
    }

    public void addList(CheMicheInfo info)
    {
        m_arrList.add(info);

        m_adapter.notifyDataSetChanged();
    }

    public ViewGroup makeHeadView(Context context)
    {
        CheMicheItemView view = new CheMicheItemView(context);
        view.setItemMode(true);
        return view;
    }

    private class CheMicheItemView
            extends LinearLayout
    {
        private CheMicheInfo m_infoChegyul;

        private TextView m_viewItemName;
        private TextView    m_viewDummy;

        private TextView    m_viewOrderQty;
        private TextView    m_viewChegyulQty;
        private TextView    m_viewMicheQty;

        private TextView    m_viewOrderPrice;
        private TextView    m_viewChegyulPrice;
        private TextView    m_viewState;

        public CheMicheItemView(Context context)
        {
            super(context);

            setOrientation(LinearLayout.VERTICAL);

            m_viewItemName = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewItemName.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewDummy = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewDummy.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewOrderQty = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewOrderQty.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewChegyulQty = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewChegyulQty.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewMicheQty = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewMicheQty.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewOrderPrice = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewOrderPrice.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewChegyulPrice = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewChegyulPrice.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewState = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewState.setPadding(PADDING_H, 0, PADDING_H, 0);

            LinearLayout layoutRow1 = new LinearLayout(context);
            layoutRow1.setOrientation(LinearLayout.HORIZONTAL);

            layoutRow1.addView(m_viewItemName, new LinearLayout.LayoutParams(0, ITEM_HEIGHT, 1));
            layoutRow1.addView(m_viewOrderQty, new LinearLayout.LayoutParams(COL2_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewChegyulQty, new LinearLayout.LayoutParams(COL3_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewMicheQty, new LinearLayout.LayoutParams(COL4_WIDTH, ITEM_HEIGHT));

            LinearLayout layoutRow2 = new LinearLayout(context);
            layoutRow2.setOrientation(LinearLayout.HORIZONTAL);

            layoutRow2.addView(m_viewDummy, new LinearLayout.LayoutParams(0, ITEM_HEIGHT, 1));
            layoutRow2.addView(m_viewOrderPrice, new LinearLayout.LayoutParams(COL2_WIDTH, ITEM_HEIGHT));
            layoutRow2.addView(m_viewChegyulPrice, new LinearLayout.LayoutParams(COL3_WIDTH, ITEM_HEIGHT));
            layoutRow2.addView(m_viewState, new LinearLayout.LayoutParams(COL4_WIDTH, ITEM_HEIGHT));

            addView(layoutRow1, new LinearLayout.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
            addView(layoutRow2, new LinearLayout.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));

            setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {

                    if(m_infoChegyul != null && m_listener != null)
                    {
                        m_listener.onCheMicheItemClicked(m_infoChegyul);
                    }
                }
            });
        }

        private void setJongo(CheMicheInfo infoChegyul)
        {
            m_infoChegyul = infoChegyul;

            m_viewItemName.setText(infoChegyul.m_strItemName);
            SampleUtil.setIntValue(m_viewOrderQty, infoChegyul.m_strOrderQty);
            SampleUtil.setIntValue(m_viewChegyulQty, infoChegyul.m_strChegyulQty);
            SampleUtil.setIntValue(m_viewMicheQty, infoChegyul.m_strMicheQty);
            if(m_nDecimalMode == 2) {
                SampleUtil.setF2Value(m_viewOrderPrice, infoChegyul.m_strOrderPrice, 0);
                SampleUtil.setF2Value(m_viewChegyulPrice, infoChegyul.m_strChegyulPrice, 0);
            } else if(m_nDecimalMode == 4)
            {
                SampleUtil.setF4Value(m_viewOrderPrice, infoChegyul.m_strOrderPrice, 0);
                SampleUtil.setF4Value(m_viewChegyulPrice, infoChegyul.m_strChegyulPrice, 0);
            } else {
                SampleUtil.setFloatValue(m_viewOrderPrice, infoChegyul.m_strOrderPrice);
                SampleUtil.setFloatValue(m_viewChegyulPrice, infoChegyul.m_strChegyulPrice);
            }
            m_viewState.setText(infoChegyul.m_strOderInfo);
        }

        private void setItemMode(boolean isHeader)
        {
            if(isHeader)
            {
                m_viewItemName.setGravity(Gravity.CENTER);
                m_viewItemName.setText("종목");
                m_viewOrderQty.setGravity(Gravity.CENTER);
                m_viewOrderQty.setText("주문수량");
                m_viewChegyulQty.setGravity(Gravity.CENTER);
                m_viewChegyulQty.setText("체결수량");
                m_viewMicheQty.setGravity(Gravity.CENTER);
                m_viewMicheQty.setText("미체결수량");
                m_viewOrderPrice.setGravity(Gravity.CENTER);
                m_viewOrderPrice.setText("주문단가");
                m_viewChegyulPrice.setGravity(Gravity.CENTER);
                m_viewChegyulPrice.setText("체결가");
                m_viewState.setGravity(Gravity.CENTER);
                m_viewState.setText("상태");
                setBackgroundColor(ColorUtil.GRID_HEADER_BACK);
            } else {
                m_viewItemName.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
                m_viewOrderQty.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewChegyulQty.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewMicheQty.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewOrderPrice.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewChegyulPrice.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewState.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                setClickable(true);
            }

        }
    }

    private class ChegyulItemViewHolder extends RecyclerView.ViewHolder
    {
        private CheMicheItemView m_viewItem;

        public ChegyulItemViewHolder(@NonNull View itemView) {
            super(itemView);

            m_viewItem = (CheMicheItemView)itemView;
        }

        public void setChegyul(CheMicheInfo infoChegyul)
        {
            m_viewItem.setJongo(infoChegyul);
        }
    }

    private class DataListAdapter extends RecyclerView.Adapter<ChegyulItemViewHolder>
    {
        @NonNull
        @Override
        public ChegyulItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType)
        {
            CheMicheItemView viewItem = new CheMicheItemView(parent.getContext());
            viewItem.setItemMode(false);
            viewItem.setLayoutParams(new RecyclerView.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
            return new ChegyulItemViewHolder(viewItem);
        }

        @Override
        public void onBindViewHolder(@NonNull ChegyulItemViewHolder holder, int position)
        {
            holder.setChegyul(m_arrList.get(position));
        }

        @Override
        public int getItemCount()
        {
            return m_arrList.size();
        }
    }
}
