package com.eugenefn.openapi.sample.view.view;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.eugenefn.openapi.sample.view.data.CondSearchInfo;
import com.eugenefn.openapi.sample.view.util.ColorUtil;
import com.eugenefn.openapi.sample.view.util.LayoutUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

import java.util.ArrayList;

public class CondInfoListView
    extends RecyclerView
{
    private int ITEM_FONT_SIZE = 14;
    private int ITEM_TEXT_COLOR = ColorUtil.NOR_TEXT_COLOR;

    private int PADDING_H = 10;
    private int ITEM_HEIGHT = 20;
    private int COL1_WIDTH = 100;
    private int COL2_WIDTH = 100;

    private ArrayList<CondSearchInfo> m_arrList = new ArrayList<>();
    private DataListAdapter m_adapter;

    private OnCondInfoListListener m_listener;
    public interface OnCondInfoListListener
    {
        public abstract void onCondInfoScrollEnd();
        public abstract void onCondInfoClicked(CondSearchInfo infoCond);
    }

    public CondInfoListView(Context context, OnCondInfoListListener listener)
    {
        super(context);

        m_listener = listener;

        PADDING_H = (int)SampleUtil.dipToPixels(context, 10);

        ITEM_HEIGHT = (int)SampleUtil.dipToPixels(context, 20);
        COL1_WIDTH = (int)SampleUtil.dipToPixels(context, 100);
        COL2_WIDTH = (int)SampleUtil.dipToPixels(context, 100);

        setFocusable(true);
        setLayoutManager(new LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false));
        m_adapter = new DataListAdapter();
        setAdapter(m_adapter);

        DividerItemDecoration divider = new DividerItemDecoration(context, DividerItemDecoration.VERTICAL);
        divider.setDrawable(new ColorDrawable(ColorUtil.LIST_SEP_LINE));
        addItemDecoration(divider);

        addOnScrollListener(new OnScrollListener() {
            @Override
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);

                if(!recyclerView.canScrollVertically(1) && (newState == SCROLL_STATE_IDLE))
                {
                    // 마지막...
                    if(m_listener != null)
                        m_listener.onCondInfoScrollEnd();
                }
            }
        });
    }

    public void clearList()
    {
        m_arrList.clear();

        m_adapter.notifyDataSetChanged();
    }

    public void addList(CondSearchInfo info)
    {
        m_arrList.add(info);

        m_adapter.notifyDataSetChanged();
    }

    public ViewGroup makeHeadView(Context context)
    {
        CondSearchItemView view = new CondSearchItemView(context);
        view.setItemMode(true);
        return view;
    }

    private class CondSearchItemView
    extends LinearLayout implements OnClickListener {
        private CondSearchInfo   m_infoCond;

        private TextView    m_viewDate;
        private TextView    m_viewTime;

        private TextView    m_viewSeqNo;
        private TextView    m_viewGroupName;

        private TextView    m_viewCondName;
        private TextView    m_viewCondDesc;

        public CondSearchItemView(Context context)
        {
            super(context);

            setOrientation(LinearLayout.VERTICAL);

            m_viewDate = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewDate.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewTime = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewTime.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewSeqNo = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewSeqNo.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewGroupName = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewGroupName.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewCondName = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewCondName.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewCondDesc = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewCondDesc.setPadding(PADDING_H, 0, PADDING_H, 0);

            LinearLayout layoutRow1 = new LinearLayout(context);
            layoutRow1.setOrientation(LinearLayout.HORIZONTAL);

            layoutRow1.addView(m_viewDate, new LayoutParams(COL1_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewSeqNo, new LayoutParams(COL2_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewCondName, new LayoutParams(0, ITEM_HEIGHT, 1));

            LinearLayout layoutRow2 = new LinearLayout(context);
            layoutRow2.setOrientation(LinearLayout.HORIZONTAL);

            layoutRow2.addView(m_viewTime, new LayoutParams(COL1_WIDTH, ITEM_HEIGHT));
            layoutRow2.addView(m_viewGroupName, new LayoutParams(COL2_WIDTH, ITEM_HEIGHT));
            layoutRow2.addView(m_viewCondDesc, new LayoutParams(0, ITEM_HEIGHT, 1));

            addView(layoutRow1, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
            addView(layoutRow2, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));

            setOnClickListener(this);
        }

        public void setCondInfo(CondSearchInfo infoCond)
        {
            m_infoCond = infoCond;

            SampleUtil.setDateValue(m_viewDate, infoCond.m_strSavedDate);
            SampleUtil.setTimeValue(m_viewTime, infoCond.m_strSavedTime);

            m_viewSeqNo.setText(infoCond.m_strSeqNo);
            m_viewGroupName.setText(infoCond.m_strGroupName);

            m_viewCondName.setText(infoCond.m_strCondName);
            m_viewCondDesc.setText(infoCond.m_strCondDesc);
        }

        private void setItemMode(boolean isHeader) {
            if (isHeader) {
                m_viewDate.setGravity(Gravity.CENTER);
                m_viewDate.setText("저장날짜");
                m_viewTime.setGravity(Gravity.CENTER);
                m_viewTime.setText("저장시간");
                m_viewSeqNo.setGravity(Gravity.CENTER);
                m_viewSeqNo.setText("시퀀스번호");
                m_viewGroupName.setGravity(Gravity.CENTER);
                m_viewGroupName.setText("그룹명");
                m_viewCondName.setGravity(Gravity.CENTER);
                m_viewCondName.setText("조건명");
                m_viewCondDesc.setGravity(Gravity.CENTER);
                m_viewCondDesc.setText("조건설명");
                setBackgroundColor(ColorUtil.GRID_HEADER_BACK);
            } else {
                m_viewDate.setGravity(Gravity.CENTER);
                m_viewTime.setGravity(Gravity.CENTER);
                m_viewSeqNo.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewGroupName.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
                m_viewCondName.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
                m_viewCondDesc.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);

                setClickable(true);
            }
        }

        @Override
        public void onClick(View v) {
            if(v instanceof CondSearchItemView) {
                if (m_listener != null)
                    m_listener.onCondInfoClicked(((CondSearchItemView) v).m_infoCond);
            }
        }
    }

    private class CondSearchItemViewHolder extends ViewHolder
    {
        private CondSearchItemView m_viewItem;

        public CondSearchItemViewHolder(@NonNull View itemView) {
            super(itemView);

            m_viewItem = (CondSearchItemView)itemView;
        }

        public void setCondInfo(CondSearchInfo infoCond)
        {
            m_viewItem.setCondInfo(infoCond);
        }
    }

    private class DataListAdapter extends Adapter<CondSearchItemViewHolder>
    {
        @NonNull
        @Override
        public CondSearchItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType)
        {
            CondSearchItemView viewItem = new CondSearchItemView(parent.getContext());
            viewItem.setItemMode(false);
            viewItem.setLayoutParams(new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
            return new CondSearchItemViewHolder(viewItem);
        }

        @Override
        public void onBindViewHolder(@NonNull CondSearchItemViewHolder holder, int position)
        {
            holder.setCondInfo(m_arrList.get(position));
        }

        @Override
        public int getItemCount()
        {
            return m_arrList.size();
        }
    }
}
