package com.eugenefn.openapi.sample.view.view;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.eugenefn.openapi.sample.view.data.CondItemInfo;
import com.eugenefn.openapi.sample.view.util.ColorUtil;
import com.eugenefn.openapi.sample.view.util.LayoutUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

import java.util.ArrayList;

public class CondItemListView
    extends RecyclerView
{
    private int ITEM_FONT_SIZE = 14;
    private int ITEM_TEXT_COLOR = ColorUtil.NOR_TEXT_COLOR;

    private int PADDING_H = 10;
    private int ITEM_HEIGHT = 20;
    private int COL1_WIDTH = 100;
    private int COL2_WIDTH = 100;
    private int COL3_WIDTH = 100;
    private int COL4_WIDTH = 100;
    private int COL5_WIDTH = 100;

    private ArrayList<CondItemInfo> m_arrList = new ArrayList<>();
    private DataListAdapter m_adapter;

    private OnCondItemListListener m_listener;
    public interface OnCondItemListListener
    {
        public abstract void onCondItemScrollEnd();
        public abstract void onCondItemClicked(CondItemInfo infoCond);
    }

    public CondItemListView(Context context, OnCondItemListListener listener)
    {
        super(context);

        m_listener = listener;

        PADDING_H = (int)SampleUtil.dipToPixels(context, 10);

        ITEM_HEIGHT = (int)SampleUtil.dipToPixels(context, 20);
        COL1_WIDTH = (int)SampleUtil.dipToPixels(context, 80);
        COL2_WIDTH = (int)SampleUtil.dipToPixels(context, 80);
        COL3_WIDTH = (int)SampleUtil.dipToPixels(context, 80);
        COL4_WIDTH = (int)SampleUtil.dipToPixels(context, 80);
        COL5_WIDTH = (int)SampleUtil.dipToPixels(context, 80);

        setFocusable(false);
        setLayoutManager(new LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false));
        m_adapter = new DataListAdapter();
        setAdapter(m_adapter);

        DividerItemDecoration divider = new DividerItemDecoration(context, DividerItemDecoration.VERTICAL);
        divider.setDrawable(new ColorDrawable(ColorUtil.LIST_SEP_LINE));
        addItemDecoration(divider);

        addOnScrollListener(new OnScrollListener() {
            @Override
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);

                if(!recyclerView.canScrollVertically(1) && (newState == SCROLL_STATE_IDLE))
                {
                    // 마지막...
                    if(m_listener != null)
                        m_listener.onCondItemScrollEnd();
                }
            }
        });
    }

    public void clearList()
    {
        m_arrList.clear();

        m_adapter.notifyDataSetChanged();
    }

    public void addList(CondItemInfo info)
    {
        m_arrList.add(info);

        m_adapter.notifyDataSetChanged();
    }

    public ViewGroup makeHeadView(Context context)
    {
        CondSearchItemView view = new CondSearchItemView(context);
        view.setItemMode(true);
        return view;
    }

    private class CondSearchItemView
    extends LinearLayout
    {
        private CondItemInfo   m_infoCond;

        private TextView    m_viewCode;
        private TextView    m_viewName;

        private TextView    m_viewBase;
        private TextView    m_viewOpen;
        private TextView    m_viewHigh;
        private TextView    m_viewLow;

        private TextView    m_viewResult;
        private View        m_viewDummy;

        public CondSearchItemView(Context context)
        {
            super(context);

            setOrientation(LinearLayout.VERTICAL);

            m_viewCode = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewCode.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewName = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewName.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewBase = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewBase.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewOpen = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewOpen.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewHigh = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewHigh.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewLow = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewLow.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewResult = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewResult.setPadding(PADDING_H, 0, PADDING_H, 0);

            m_viewDummy = new View(context);

            LinearLayout layoutRow1 = new LinearLayout(context);
            layoutRow1.setOrientation(LinearLayout.HORIZONTAL);

            layoutRow1.addView(m_viewName, new LayoutParams(COL1_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewBase, new LayoutParams(COL2_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewOpen, new LayoutParams(COL3_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewHigh, new LayoutParams(COL4_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewLow, new LayoutParams(COL4_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewDummy, new LayoutParams(0, ITEM_HEIGHT, 1));

            LinearLayout layoutRow2 = new LinearLayout(context);
            layoutRow2.setOrientation(LinearLayout.HORIZONTAL);

            layoutRow2.addView(m_viewCode, new LayoutParams(COL1_WIDTH, ITEM_HEIGHT));
            layoutRow2.addView(m_viewResult, new LayoutParams(0, ITEM_HEIGHT, 1));

            addView(layoutRow1, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
            addView(layoutRow2, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
        }

        public void setItemInfo(CondItemInfo infoCond)
        {
            m_infoCond = infoCond;

            m_viewCode.setText(infoCond.m_strItemCode);
            m_viewName.setText(infoCond.m_strName);

            m_viewBase.setText(infoCond.m_strBasePrice);
            m_viewOpen.setText(infoCond.m_strOpenPrice);
            m_viewHigh.setText(infoCond.m_strHighPrice);
            m_viewLow.setText(infoCond.m_strLowPrice);

            m_viewResult.setText(infoCond.m_strResult);
        }

        private void setItemMode(boolean isHeader) {
            if (isHeader) {
                m_viewName.setGravity(Gravity.CENTER);
                m_viewName.setText("종목명");
                m_viewCode.setGravity(Gravity.CENTER);
                m_viewCode.setText("종목코드");
                m_viewBase.setGravity(Gravity.CENTER);
                m_viewBase.setText("기준가");
                m_viewHigh.setGravity(Gravity.CENTER);
                m_viewHigh.setText("고가");
                m_viewOpen.setGravity(Gravity.CENTER);
                m_viewOpen.setText("시가");
                m_viewLow.setGravity(Gravity.CENTER);
                m_viewLow.setText("저가");
                m_viewResult.setGravity(Gravity.CENTER);
                m_viewResult.setText("결과필드");
                setBackgroundColor(ColorUtil.GRID_HEADER_BACK);
            } else {
                m_viewName.setGravity(Gravity.CENTER);
                m_viewCode.setGravity(Gravity.CENTER);
                m_viewBase.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewOpen.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewHigh.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewLow.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewResult.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
            }
        }
    }

    private class CondSearchItemViewHolder extends ViewHolder
    {
        private CondSearchItemView m_viewItem;

        public CondSearchItemViewHolder(@NonNull View itemView) {
            super(itemView);

            m_viewItem = (CondSearchItemView)itemView;
        }

        public void setItemInfo(CondItemInfo infoCond)
        {
            m_viewItem.setItemInfo(infoCond);
        }
    }

    private class DataListAdapter extends Adapter<CondSearchItemViewHolder>
    {
        @NonNull
        @Override
        public CondSearchItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType)
        {
            CondSearchItemView viewItem = new CondSearchItemView(parent.getContext());
            viewItem.setItemMode(false);
            viewItem.setLayoutParams(new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
            return new CondSearchItemViewHolder(viewItem);
        }

        @Override
        public void onBindViewHolder(@NonNull CondSearchItemViewHolder holder, int position)
        {
            holder.setItemInfo(m_arrList.get(position));
        }

        @Override
        public int getItemCount()
        {
            return m_arrList.size();
        }
    }
}
