package com.eugenefn.openapi.sample.view.view;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.eugenefn.openapi.sample.view.data.CondSignalInfo;
import com.eugenefn.openapi.sample.view.util.ColorUtil;
import com.eugenefn.openapi.sample.view.util.LayoutUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

import java.util.ArrayList;

/**
 * 조건검색 실시간 감시 정보 리스트
 */
public class CondSignalListView
    extends RecyclerView
{
    private final int MAX_ITEMS = 1000;

    private int ITEM_FONT_SIZE = 14;
    private int ITEM_TEXT_COLOR = ColorUtil.NOR_TEXT_COLOR;

    private int PADDING_H = 10;
    private int ITEM_HEIGHT = 20;
    private int COL1_WIDTH = 80;
    private int COL2_WIDTH = 80;
    private int COL3_WIDTH = 60;
    private int COL4_WIDTH = 60;
    private int COL6_WIDTH = 100;

    private ArrayList<CondSignalInfo> m_arrList = new ArrayList<>();
    private DataListAdapter m_adapter;

    public CondSignalListView(Context context)
    {
        super(context);

        PADDING_H = (int)SampleUtil.dipToPixels(context, 10);

        ITEM_HEIGHT = (int)SampleUtil.dipToPixels(context, 20);
        COL1_WIDTH = (int)SampleUtil.dipToPixels(context, 80);
        COL2_WIDTH = (int)SampleUtil.dipToPixels(context, 50);
        COL3_WIDTH = (int)SampleUtil.dipToPixels(context, 60);
        COL4_WIDTH = (int)SampleUtil.dipToPixels(context, 70);
        COL6_WIDTH = (int)SampleUtil.dipToPixels(context, 70);

        setFocusable(false);
        setLayoutManager(new LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false));
        m_adapter = new DataListAdapter();
        setAdapter(m_adapter);

        DividerItemDecoration divider = new DividerItemDecoration(context, DividerItemDecoration.VERTICAL);
        divider.setDrawable(new ColorDrawable(ColorUtil.LIST_SEP_LINE));
        addItemDecoration(divider);
    }

    public void clearList()
    {
        m_arrList.clear();

        m_adapter.notifyDataSetChanged();
    }

    public void addList(CondSignalInfo info)
    {
        m_arrList.add(info);

        // 최대 개수 안넘어가게
        if(m_arrList.size() > MAX_ITEMS)
            m_arrList.remove(m_arrList.size() - 1);

        m_adapter.notifyDataSetChanged();
    }

    public ViewGroup makeHeadView(Context context)
    {
        CondSignalItemView view = new CondSignalItemView(context);
        view.setItemMode(true);
        return view;
    }

    private class CondSignalItemView
    extends LinearLayout
    {
        private CondSignalInfo   m_infoCond;

        private TextView    m_viewTime;

        private TextView    m_viewFlag;
        private TextView    m_viewCount;

        private TextView    m_viewCode;
        private TextView    m_viewName;
        private TextView    m_viewPrice;

        public CondSignalItemView(Context context)
        {
            super(context);

            setOrientation(LinearLayout.VERTICAL);

            m_viewTime = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewTime.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewFlag = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewFlag.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewCount = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewCount.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewCode = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewCode.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewName = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewName.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewPrice = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewPrice.setPadding(PADDING_H, 0, PADDING_H, 0);

            LinearLayout layoutRow1 = new LinearLayout(context);
            layoutRow1.setOrientation(LinearLayout.HORIZONTAL);

            layoutRow1.addView(m_viewTime, new LayoutParams(COL1_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewFlag, new LayoutParams(COL2_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewCount, new LayoutParams(COL3_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewCode, new LayoutParams(COL4_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewName, new LayoutParams(0, ITEM_HEIGHT, 1));
            layoutRow1.addView(m_viewPrice, new LayoutParams(COL6_WIDTH, ITEM_HEIGHT));

            addView(layoutRow1, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
        }

        public void setItemInfo(CondSignalInfo infoCond)
        {
            m_infoCond = infoCond;

            SampleUtil.setTimeValue(m_viewTime, infoCond.m_strTime);
            m_viewFlag.setText(infoCond.getFlag());
            SampleUtil.setIntValue(m_viewCount, infoCond.m_strCount);

            m_viewCode.setText(infoCond.m_strItemCode);
            m_viewName.setText(infoCond.m_strItemName);
            SampleUtil.setIntValue(m_viewPrice, infoCond.m_strPrice);
        }

        private void setItemMode(boolean isHeader) {
            if (isHeader) {
                m_viewTime.setGravity(Gravity.CENTER);
                m_viewTime.setText("시각");
                m_viewFlag.setGravity(Gravity.CENTER);
                m_viewFlag.setText("신호");
                m_viewCount.setGravity(Gravity.CENTER);
                m_viewCount.setText("종목수");
                m_viewCode.setGravity(Gravity.CENTER);
                m_viewCode.setText("종목코드");
                m_viewName.setGravity(Gravity.CENTER);
                m_viewName.setText("종목명");
                m_viewPrice.setGravity(Gravity.CENTER);
                m_viewPrice.setText("현재가");
                setBackgroundColor(ColorUtil.GRID_HEADER_BACK);
            } else {
                m_viewTime.setGravity(Gravity.CENTER);
                m_viewFlag.setGravity(Gravity.CENTER);
                m_viewCount.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewCode.setGravity(Gravity.CENTER);
                m_viewName.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
                m_viewPrice.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
            }
        }
    }

    private class CondSignalItemViewHolder extends ViewHolder
    {
        private CondSignalItemView m_viewItem;

        public CondSignalItemViewHolder(@NonNull View itemView) {
            super(itemView);

            m_viewItem = (CondSignalItemView)itemView;
        }

        public void setItemInfo(CondSignalInfo infoCond)
        {
            m_viewItem.setItemInfo(infoCond);
        }
    }

    private class DataListAdapter extends Adapter<CondSignalItemViewHolder>
    {
        @NonNull
        @Override
        public CondSignalItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType)
        {
            CondSignalItemView viewItem = new CondSignalItemView(parent.getContext());
            viewItem.setItemMode(false);
            viewItem.setLayoutParams(new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
            return new CondSignalItemViewHolder(viewItem);
        }

        @Override
        public void onBindViewHolder(@NonNull CondSignalItemViewHolder holder, int position)
        {
            holder.setItemInfo(m_arrList.get(position));
        }

        @Override
        public int getItemCount()
        {
            return m_arrList.size();
        }
    }
}
