package com.eugenefn.openapi.sample.view.view;

import com.eugenefn.openapi.sample.view.util.ColorUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

public class ItemHogaView
extends FrameLayout
{
	private static final String LOG_TAG = "주식호가 뷰";
	
	private HogaItemView [] m_arrViews;
	
	private int PADDING_H = 10;
	private int LINE_WIDTH = 1;
	private Paint m_paintLine;
	
	private OnHogaViewListener m_listener;
	
	public ItemHogaView(Context context)
	{
		super(context);

		PADDING_H = (int)SampleUtil.dipToPixels(context, 10);
		LINE_WIDTH = (int)SampleUtil.dipToPixels(context, 1);
		if(LINE_WIDTH < 2) LINE_WIDTH = 2;
		
		LinearLayout layoutFrame = new LinearLayout(context);
		layoutFrame.setOrientation(LinearLayout.VERTICAL);
		
		m_arrViews = new HogaItemView[10];
		
		for(int i = 0; i < 10; i++)
		{
			m_arrViews[i] = new HogaItemView(context, i < 5 ? true : false);
			layoutFrame.addView(m_arrViews[i], new LinearLayout.LayoutParams(LayoutParams.MATCH_PARENT, 0, 1));
		}
		
		addView(layoutFrame, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));
	}

	public void setHoga(boolean isMaedo, int nOffset, String strHoga, int nHogaAttr, String strRemain)
	{
		int nViewIndex = (isMaedo ? (5 - nOffset - 1) : (nOffset + 5));
		Log.d(LOG_TAG, String.format("setHoga %s, %d, %s, %s --> %d", isMaedo ? "매도" : "매수", nOffset, strHoga, strRemain, nViewIndex));
		if(nViewIndex < 0 || nViewIndex >= 10) return;
		
		m_arrViews[nViewIndex].setHogaInfo(strHoga, nHogaAttr, strRemain);
	}

	public void setHogaF2(boolean isMaedo, int nOffset, String strHoga, int nHogaAttr, String strRemain)
	{
		int nViewIndex = (isMaedo ? (5 - nOffset - 1) : (nOffset + 5));
		Log.d(LOG_TAG, String.format("setHoga %s, %d, %s, %s --> %d", isMaedo ? "매도" : "매수", nOffset, strHoga, strRemain, nViewIndex));
		if(nViewIndex < 0 || nViewIndex >= 10) return;

		m_arrViews[nViewIndex].setHogaInfoF2(strHoga, nHogaAttr, strRemain);
	}

	public void setHogaF22(boolean isMaedo, int nOffset, String strHoga, int nHogaAttr, String strRemain)
	{
		int nViewIndex = (isMaedo ? (5 - nOffset - 1) : (nOffset + 5));
		Log.d(LOG_TAG, String.format("setHoga %s, %d, %s, %s --> %d", isMaedo ? "매도" : "매수", nOffset, strHoga, strRemain, nViewIndex));
		if(nViewIndex < 0 || nViewIndex >= 10) return;

		m_arrViews[nViewIndex].setHogaInfoF22(strHoga, nHogaAttr, strRemain);
	}

	public void setHogaF4(boolean isMaedo, int nOffset, String strHoga, int nHogaAttr, String strRemain)
	{
		int nViewIndex = (isMaedo ? (5 - nOffset - 1) : (nOffset + 5));
		Log.d(LOG_TAG, String.format("setHoga %s, %d, %s, %s --> %d", isMaedo ? "매도" : "매수", nOffset, strHoga, strRemain, nViewIndex));
		if(nViewIndex < 0 || nViewIndex >= 10) return;

		m_arrViews[nViewIndex].setHogaInfoF4(strHoga, nHogaAttr, strRemain);
	}

	public void setOnHogaViewListener(OnHogaViewListener listener)
	{
		m_listener = listener;
	}
	
	@Override
	public void dispatchDraw(Canvas canvas)
	{
		super.dispatchDraw(canvas);
		
		if(m_paintLine == null)
		{
			m_paintLine = new Paint();
			m_paintLine.setColor(Color.LTGRAY);
			m_paintLine.setStrokeWidth(LINE_WIDTH);
			m_paintLine.setStyle(Paint.Style.STROKE);
		}
		
		int nWidth = getWidth();
		int nHeight = getHeight();
		
		Log.d(LOG_TAG, "onDraw - " + nWidth + ", " + nHeight);
		canvas.drawRect(0, 0, nWidth, nHeight, m_paintLine);
		
		int nX1 = nWidth / 3;
		int nX2 = (nWidth / 3) * 2;
		
		canvas.drawLine(nX1, 0, nX1, nHeight, m_paintLine);
		canvas.drawLine(nX2, 0, nX2, nHeight, m_paintLine);
		
		for(int y = 0; y < 10; y++)
		{
			int nY = (nHeight / 10) * (y + 1);
			
			canvas.drawLine(0, nY, nWidth, nY, m_paintLine);
		}
	}

	public interface OnHogaViewListener
	{
		public abstract void onHogaClicked(String strPrice);
	}
	
	private class HogaItemView
	extends LinearLayout
	{
		private TextView		m_viewHoga;
		private TextView		m_viewRemain;
		
		public HogaItemView(Context context, boolean isMaedo)
		{
			super(context);

			setOrientation(LinearLayout.HORIZONTAL);
			
			m_viewHoga = makeTextView(context, true, isMaedo);
			m_viewRemain = makeTextView(context, false, isMaedo);
			
			m_viewHoga.setPadding(PADDING_H, 0, PADDING_H, 0);
			m_viewRemain.setPadding(PADDING_H, 0, PADDING_H, 0);
			
			if(isMaedo)
			{
				addView(m_viewRemain, new LayoutParams(0, LayoutParams.MATCH_PARENT, 1));
				addView(m_viewHoga, new LayoutParams(0, LayoutParams.MATCH_PARENT, 1));
				addView(new View(context), new LayoutParams(0, LayoutParams.MATCH_PARENT, 1));
				
				m_viewHoga.setBackgroundColor(ColorUtil.getAlphaColor(ColorUtil.RISE, 5));
			} else {
				addView(new View(context), new LayoutParams(0, LayoutParams.MATCH_PARENT, 1));
				addView(m_viewHoga, new LayoutParams(0, LayoutParams.MATCH_PARENT, 1));
				addView(m_viewRemain, new LayoutParams(0, LayoutParams.MATCH_PARENT, 1));
				
				m_viewHoga.setBackgroundColor(ColorUtil.getAlphaColor(ColorUtil.FALL, 5));
			}
			
			m_viewHoga.setClickable(true);
			m_viewHoga.setOnClickListener(new OnClickListener()
			{
				@Override
				public void onClick(View view)
				{
					Object objTag = view.getTag();
					if(objTag != null && objTag instanceof String)
					{
						if(m_listener != null)
							m_listener.onHogaClicked((String)objTag);
					}
				}
				
			});
		}
		
		public void setHogaInfo(String strHoga, int nHogaAttr, String strRemain)
		{
			SampleUtil.setIntValue(m_viewHoga, strHoga, nHogaAttr);
			SampleUtil.setIntValue(m_viewRemain, strRemain);
			
			m_viewHoga.setTag(strHoga);
		}

		public void setHogaInfoF2(String strHoga, int nHogaAttr, String strRemain)
		{
			SampleUtil.setF2Value(m_viewHoga, strHoga, nHogaAttr);
			SampleUtil.setIntValue(m_viewRemain, strRemain);

			float fValue = (float)Math.round(SampleUtil.getDoubleValue(strHoga) * 100) / 100;
			m_viewHoga.setTag(SampleUtil.m_formatF2Value.format(fValue));
			//m_viewHoga.setTag(strHoga);
		}

		public void setHogaInfoF22(String strHoga, int nHogaAttr, String strRemain)
		{
			SampleUtil.setF22Value(m_viewHoga, strHoga, nHogaAttr);
			SampleUtil.setIntValue(m_viewRemain, strRemain);

			float fValue = (float)Math.round(SampleUtil.getDoubleValue(strHoga)) / 100;
			m_viewHoga.setTag(SampleUtil.m_formatF2Value.format(fValue));
			//m_viewHoga.setTag(strHoga);
		}

		public void setHogaInfoF4(String strHoga, int nHogaAttr, String strRemain)
		{
			SampleUtil.setF4Value(m_viewHoga, strHoga, nHogaAttr);
			SampleUtil.setIntValue(m_viewRemain, strRemain);

			m_viewHoga.setTag(strHoga);
		}

		private TextView makeTextView(Context context, boolean isHoga, boolean isMaedo)
		{
			TextView viewText = new TextView(context);
			viewText.setTextColor(isHoga ? (isMaedo ? Color.RED : Color.BLUE) : Color.DKGRAY);
			viewText.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
			viewText.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
			viewText.setSingleLine();
			
			return viewText;
		}
	}
}
