package com.eugenefn.openapi.sample.view.view;

import com.eugenefn.openapi.sample.view.util.ColorUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

import android.content.Context;
import android.graphics.Color;
import android.util.TypedValue;
import android.view.Gravity;
import android.widget.LinearLayout;
import android.widget.TextView;

public class ItemPriceView
extends LinearLayout
{
	private TextView		m_viewPrice;		// 현재가
	private TextView		m_viewSign;			// 등락기호
	private TextView		m_viewDiff;			// 등락
	private TextView		m_viewDiffRatio;	// 등락율
	
	private TextView		m_viewUpjong;		// 업종
	private TextView		m_viewTradeAmount;	// 거래량
	private TextView		m_viewTradeMoney;	// 거래대금
	
	public ItemPriceView(Context context)
	{
		super(context);

		setOrientation(LinearLayout.VERTICAL);
		setBackgroundColor(ColorUtil.SECTION_INPUT_BACK);
		
		LinearLayout layoutLine1 = new LinearLayout(context);
		layoutLine1.setOrientation(LinearLayout.HORIZONTAL);
		
		m_viewPrice = makeTextView(context, 20);
		m_viewSign = makeTextView(context, 12);
		m_viewDiff = makeTextView(context, 14);
		m_viewDiffRatio = makeTextView(context, 14);
		
		layoutLine1.addView(m_viewPrice, new LayoutParams(0, LayoutParams.MATCH_PARENT, 40));
		layoutLine1.addView(m_viewSign, new LayoutParams(0, LayoutParams.MATCH_PARENT, 10));
		layoutLine1.addView(m_viewDiff, new LayoutParams(0, LayoutParams.MATCH_PARENT, 20));
		layoutLine1.addView(m_viewDiffRatio, new LayoutParams(0, LayoutParams.MATCH_PARENT, 30));
		
		m_viewUpjong = makeTextView(context, 12);
		m_viewUpjong.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
		
		m_viewTradeAmount = makeTextView(context, 12);
		m_viewTradeMoney = makeTextView(context, 12);
		
		LinearLayout layoutLine2 = new LinearLayout(context);
		layoutLine2.setOrientation(LinearLayout.HORIZONTAL);
		
		layoutLine2.addView(m_viewUpjong, new LayoutParams(0, LayoutParams.MATCH_PARENT, 2));
		layoutLine2.addView(m_viewTradeAmount, new LayoutParams(0, LayoutParams.MATCH_PARENT, 3));
		layoutLine2.addView(m_viewTradeMoney, new LayoutParams(0, LayoutParams.MATCH_PARENT, 3));
		
		addView(layoutLine1, new LayoutParams(LayoutParams.MATCH_PARENT, 0, 30));
		addView(layoutLine2, new LayoutParams(LayoutParams.MATCH_PARENT, 0, 20));
	}

	// 종목 현재가 정보 ( 현재가, 등락, 등락률)
	public void setStockPriceInfo(String strPrice, int nPriceAttr,
								  String strSign, int nSignAttr, String strDiff, int nDiffAttr,
								  String strDiffRatio, int nDiffRatioAttr)
	{
		SampleUtil.setIntValue(m_viewPrice, strPrice, nPriceAttr);
		SampleUtil.setSignValue(m_viewSign, strSign, nPriceAttr);
		SampleUtil.setIntValue(m_viewDiff, strDiff, nDiffAttr);
		SampleUtil.setF2Value(m_viewDiffRatio, strDiffRatio, nDiffRatioAttr, "", " %");
	}
	
	// 종목 거래 정보( 거래량, 거래대금)
	public void setStockTradeInfo(String strTradeAmount, String strTradeMoney)
	{
		SampleUtil.setIntValue(m_viewTradeAmount, strTradeAmount, "", " 주");
		SampleUtil.setIntValue(m_viewTradeMoney, strTradeMoney, "", " 백만");
	}

	// 선옵 종목 현재가 정보 ( 현재가, 등락, 등락률)
	public void setFutPriceInfo(String strPrice, int nPriceAttr,
								  String strSign, int nSignAttr, String strDiff, int nDiffAttr,
								  String strDiffRatio, int nDiffRatioAttr)
	{
		SampleUtil.setF2Value(m_viewPrice, strPrice, nPriceAttr);
		SampleUtil.setSignValue(m_viewSign, strSign, nPriceAttr);
		SampleUtil.setF2Value(m_viewDiff, strDiff, nDiffAttr);
		SampleUtil.setF2Value(m_viewDiffRatio, strDiffRatio, nDiffRatioAttr, "", " %");
	}

	public void setOptPriceInfo(String strPrice, int nPriceAttr,
								String strSign, int nSignAttr, String strDiff, int nDiffAttr,
								String strDiffRatio, int nDiffRatioAttr)
	{
		SampleUtil.setF22Value(m_viewPrice, strPrice, nPriceAttr);
		SampleUtil.setSignValue(m_viewSign, strSign, nPriceAttr);
		SampleUtil.setF22Value(m_viewDiff, strDiff, nDiffAttr);
		SampleUtil.setF22Value(m_viewDiffRatio, strDiffRatio, nDiffRatioAttr, "", " %");
	}

	// 종목 거래 정보( 거래량, 거래대금)
	public void setFutOptTradeInfo(String strTradeAmount, String strTradeMoney)
	{
		SampleUtil.setIntValue(m_viewTradeAmount, strTradeAmount, "", " 계약");
		SampleUtil.setIntValue(m_viewTradeMoney, strTradeMoney, "", " 백만");
	}

	// 종목 현재가 정보 ( 현재가, 등락, 등락률)
	public void setWStockPriceInfo(String strPrice, int nPriceAttr,
								  String strSign, int nSignAttr, String strDiff, int nDiffAttr,
								  String strDiffRatio, int nDiffRatioAttr)
	{
		SampleUtil.setF4Value(m_viewPrice, strPrice, nPriceAttr);
		SampleUtil.setSignValue(m_viewSign, strSign, nPriceAttr);
		SampleUtil.setF4Value(m_viewDiff, strDiff, nDiffAttr);
		SampleUtil.setF2Value(m_viewDiffRatio, strDiffRatio, nDiffRatioAttr, "", " %");
	}

	// 종목 거래 정보( 거래량, 거래대금)
	public void setWStockTradeInfo(String strTradeAmount, String strTradeMoney)
	{
		SampleUtil.setIntValue(m_viewTradeAmount, strTradeAmount, "", " 주");
		SampleUtil.setIntValue(m_viewTradeMoney, strTradeMoney, "", "");
	}

	// 종목 정보 ( 업종 )
	public void setItemInfo(String strUpjong)
	{
		m_viewUpjong.setText(strUpjong);
	}
	
	private TextView makeTextView(Context context, int nTextDip)
	{
		TextView viewText = new TextView(context);
		viewText.setTextColor(Color.BLACK);
		viewText.setTextSize(TypedValue.COMPLEX_UNIT_DIP, nTextDip);
		viewText.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
		viewText.setSingleLine();
		
		return viewText;
	}
}
