package com.eugenefn.openapi.sample.view.view;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.eugenefn.openapi.sample.view.data.JangoInfo;
import com.eugenefn.openapi.sample.view.util.ColorUtil;
import com.eugenefn.openapi.sample.view.util.LayoutUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

import java.util.ArrayList;

public class JangoListView
    extends RecyclerView
{
    private int ITEM_FONT_SIZE = 14;
    private int ITEM_TEXT_COLOR = ColorUtil.NOR_TEXT_COLOR;

    private int PADDING_H = 10;
    private int ITEM_HEIGHT = 30;
    private int COL2_WIDTH = 100;
    private int COL3_WIDTH = 100;

    // 소수점 자리수 정의
    // 국내 - 0, 선옵 - 2, 해외주식 - 4
    private int m_nDecimalMode = 0;

    private ArrayList<JangoInfo> m_arrList = new ArrayList<>();
    private DataListAdapter m_adapter;

    private OnJangoListListener m_listener;
    public interface OnJangoListListener
    {
        public abstract void onJangoScrollEnd();
    }

    public JangoListView(Context context, int nDecimalMode, OnJangoListListener listener)
    {
        super(context);

        m_listener = listener;
        m_nDecimalMode = nDecimalMode;

        PADDING_H = (int)SampleUtil.dipToPixels(context, 10);

        ITEM_HEIGHT = (int)SampleUtil.dipToPixels(context, 30);
        COL2_WIDTH = (int)SampleUtil.dipToPixels(context, 100);
        COL3_WIDTH = (int)SampleUtil.dipToPixels(context, 150);

        setFocusable(false);
        setLayoutManager(new LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false));
        m_adapter = new DataListAdapter();
        setAdapter(m_adapter);

        DividerItemDecoration divider = new DividerItemDecoration(context, DividerItemDecoration.VERTICAL);
        divider.setDrawable(new ColorDrawable(ColorUtil.LIST_SEP_LINE));
        addItemDecoration(divider);

        addOnScrollListener(new OnScrollListener() {
            @Override
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);

                if(!recyclerView.canScrollVertically(1) && (newState == SCROLL_STATE_IDLE))
                {
                    // 마지막...
                    if(m_listener != null)
                        m_listener.onJangoScrollEnd();
                }
            }
        });
    }

    public void clearList()
    {
        m_arrList.clear();

        m_adapter.notifyDataSetChanged();
    }

    public void addList(JangoInfo info)
    {
        m_arrList.add(info);

        m_adapter.notifyDataSetChanged();
    }

    public ViewGroup makeHeadView(Context context)
    {
        JangoItemView view = new JangoItemView(context);
        view.setItemMode(true);
        return view;
    }

    private class JangoItemView
    extends LinearLayout
    {
        private JangoInfo   m_infoJango;

        private TextView    m_viewItemName;
        private TextView    m_viewUnitPrice;

        private TextView    m_viewAvailQty;
        private TextView    m_viewHaveQty;

        private TextView    m_viewAvgPrice;
        private TextView    m_viewProfit;

        public JangoItemView(Context context)
        {
            super(context);

            setOrientation(LinearLayout.VERTICAL);

            m_viewItemName = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewItemName.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewUnitPrice = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewUnitPrice.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewAvailQty = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewAvailQty.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewHaveQty = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewHaveQty.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewAvgPrice = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewAvgPrice.setPadding(PADDING_H, 0, PADDING_H, 0);
            m_viewProfit = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewProfit.setPadding(PADDING_H, 0, PADDING_H, 0);

            LinearLayout layoutRow1 = new LinearLayout(context);
            layoutRow1.setOrientation(LinearLayout.HORIZONTAL);

            layoutRow1.addView(m_viewItemName, new LinearLayout.LayoutParams(0, ITEM_HEIGHT, 1));
            layoutRow1.addView(m_viewAvailQty, new LinearLayout.LayoutParams(COL2_WIDTH, ITEM_HEIGHT));
            layoutRow1.addView(m_viewAvgPrice, new LinearLayout.LayoutParams(COL3_WIDTH, ITEM_HEIGHT));

            LinearLayout layoutRow2 = new LinearLayout(context);
            layoutRow2.setOrientation(LinearLayout.HORIZONTAL);

            layoutRow2.addView(m_viewUnitPrice, new LinearLayout.LayoutParams(0, ITEM_HEIGHT, 1));
            layoutRow2.addView(m_viewHaveQty, new LinearLayout.LayoutParams(COL2_WIDTH, ITEM_HEIGHT));
            layoutRow2.addView(m_viewProfit, new LinearLayout.LayoutParams(COL3_WIDTH, ITEM_HEIGHT));

            addView(layoutRow1, new LinearLayout.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
            addView(layoutRow2, new LinearLayout.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
        }

        public void setJongo(JangoInfo infoJango)
        {
            m_infoJango = infoJango;

            m_viewItemName.setText(infoJango.m_strItemName);
            SampleUtil.setIntValue(m_viewAvailQty, infoJango.m_strAvailQty);
            SampleUtil.setIntValue(m_viewHaveQty, infoJango.m_strHaveQty);
            if(m_nDecimalMode == 4) {
                SampleUtil.setF4Value(m_viewUnitPrice, infoJango.m_strUnitPrice, 0);
                SampleUtil.setF4Value(m_viewAvgPrice, infoJango.m_strAvgPrice, 0);
            } else if(m_nDecimalMode == 2)
            {
                SampleUtil.setF2Value(m_viewUnitPrice, infoJango.m_strUnitPrice, 0);
                SampleUtil.setF2Value(m_viewAvgPrice, infoJango.m_strAvgPrice, 0);
            } else {
                SampleUtil.setFloatValue(m_viewUnitPrice, infoJango.m_strUnitPrice);
                SampleUtil.setFloatValue(m_viewAvgPrice, infoJango.m_strAvgPrice);
            }
            SampleUtil.setFloatValue(m_viewProfit, infoJango.m_strProfit);
        }

        private void setItemMode(boolean isHeader) {
            if (isHeader) {
                m_viewItemName.setGravity(Gravity.CENTER);
                m_viewItemName.setText("종목");
                m_viewAvailQty.setGravity(Gravity.CENTER);
                m_viewAvailQty.setText("주문가능수량");
                m_viewHaveQty.setGravity(Gravity.CENTER);
                m_viewHaveQty.setText("보유수량");
                m_viewUnitPrice.setGravity(Gravity.CENTER);
                m_viewUnitPrice.setText("주문단가");
                m_viewAvgPrice.setGravity(Gravity.CENTER);
                m_viewAvgPrice.setText("평가금액");
                m_viewProfit.setGravity(Gravity.CENTER);
                m_viewProfit.setText("수익");
                setBackgroundColor(ColorUtil.GRID_HEADER_BACK);
            } else {
                m_viewItemName.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
                m_viewAvailQty.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewHaveQty.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewUnitPrice.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewAvgPrice.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewProfit.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
            }
        }
    }

    private class JangoItemViewHolder extends RecyclerView.ViewHolder
    {
        private JangoItemView m_viewItem;

        public JangoItemViewHolder(@NonNull View itemView) {
            super(itemView);

            m_viewItem = (JangoItemView)itemView;
        }

        public void setJango(JangoInfo infoJango)
        {
            m_viewItem.setJongo(infoJango);
        }
    }

    private class DataListAdapter extends RecyclerView.Adapter<JangoItemViewHolder>
    {
        @NonNull
        @Override
        public JangoItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType)
        {
            JangoItemView viewItem = new JangoItemView(parent.getContext());
            viewItem.setItemMode(false);
            viewItem.setLayoutParams(new RecyclerView.LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
            return new JangoItemViewHolder(viewItem);
        }

        @Override
        public void onBindViewHolder(@NonNull JangoItemViewHolder holder, int position)
        {
            holder.setJango(m_arrList.get(position));
        }

        @Override
        public int getItemCount()
        {
            return m_arrList.size();
        }
    }
}
