package com.eugenefn.openapi.sample.view.view;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.eugenefn.openapi.sample.view.data.SiseInfo;
import com.eugenefn.openapi.sample.view.util.ColorUtil;
import com.eugenefn.openapi.sample.view.util.LayoutUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

import java.util.ArrayList;

// 종목에 대한 체결 실시간 리스트
public class SiseListView
        extends RecyclerView
{
    private final int MAX_ITEMS = 1000;

    private int ITEM_FONT_SIZE = 14;
    private int ITEM_TEXT_COLOR = ColorUtil.NOR_TEXT_COLOR;

    private int PADDING_H = 3;
    private int ITEM_HEIGHT = 25;

    private ArrayList<SiseInfo> m_arrList = new ArrayList<>();
    private DataListAdapter m_adapter;

    private OnSiseListListener m_listener;
    public interface OnSiseListListener
    {
        public abstract void onSiseListScrollEnd();
    }

    // 소수점 자리수 정의
    // 국내 - 0, 선물 - 2, 옵션 - 3, 해외주식 - 4
    private int m_nDecimalMode = 0;

    public SiseListView(Context context, int nDecimalMode, OnSiseListListener listener)
    {
        super(context);

        m_nDecimalMode = nDecimalMode;
        m_listener = listener;

        PADDING_H = (int)SampleUtil.dipToPixels(context, 3);

        ITEM_HEIGHT = (int)SampleUtil.dipToPixels(context, 25);

        setFocusable(false);
        setLayoutManager(new LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false));
        m_adapter = new DataListAdapter();
        setAdapter(m_adapter);

        DividerItemDecoration divider = new DividerItemDecoration(context, DividerItemDecoration.VERTICAL);
        divider.setDrawable(new ColorDrawable(ColorUtil.LIST_SEP_LINE));
        addItemDecoration(divider);

        addOnScrollListener(new OnScrollListener() {
            @Override
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);

                if(!recyclerView.canScrollVertically(1) && (newState == SCROLL_STATE_IDLE))
                {
                    // 마지막...
                    if(m_listener != null)
                        m_listener.onSiseListScrollEnd();
                }
            }
        });

    }

    public void clearList(int nDecimalMode)
    {
        m_arrList.clear();

        m_nDecimalMode = nDecimalMode;

        m_adapter.notifyDataSetChanged();
    }

    public void addList(SiseInfo info, int nAddIndex)
    {
        m_arrList.add(nAddIndex, info);

        // 최대 개수 안넘어가게
        if(m_arrList.size() > MAX_ITEMS)
            m_arrList.remove(m_arrList.size() - 1);

        m_adapter.notifyDataSetChanged();
    }

    public ViewGroup makeHeadView(Context context)
    {
        SisetemView view = new SisetemView(context);
        view.setItemMode(true);
        return view;
    }

    private class SisetemView
            extends LinearLayout
    {
        private TextView m_viewPrice;
        private TextView    m_viewQty;

        public SisetemView(Context context)
        {
            super(context);

            setOrientation(LinearLayout.HORIZONTAL);

            m_viewPrice = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewPrice.setPadding(0, 0, PADDING_H, 0);
            m_viewQty = LayoutUtil.makeTextView(context, "", ITEM_FONT_SIZE, ITEM_TEXT_COLOR);
            m_viewQty.setPadding(0, 0, PADDING_H, 0);

            addView(m_viewPrice, new LayoutParams(0, ITEM_HEIGHT, 4));
            addView(m_viewQty, new LayoutParams(0, ITEM_HEIGHT, 2));
        }

        private void setSise(SiseInfo infoSise)
        {
            if(m_nDecimalMode == 2)
                SampleUtil.setF2Value(m_viewPrice, infoSise.m_strPrice, infoSise.m_nPriceAttr);
            else if(m_nDecimalMode == 3)
                SampleUtil.setF22Value(m_viewPrice, infoSise.m_strPrice, infoSise.m_nPriceAttr);
            else if(m_nDecimalMode == 4)
                SampleUtil.setF4Value(m_viewPrice, infoSise.m_strPrice, infoSise.m_nPriceAttr);
            else
                SampleUtil.setIntValue(m_viewPrice, infoSise.m_strPrice, infoSise.m_nPriceAttr);

            SampleUtil.setIntValue(m_viewQty, infoSise.m_strQty, infoSise.m_nQtyAttr);
        }

        private void setItemMode(boolean isHeader)
        {
            if(isHeader)
            {
                m_viewPrice.setGravity(Gravity.CENTER);
                m_viewPrice.setText("체결가");
                m_viewQty.setGravity(Gravity.CENTER);
                m_viewQty.setText("수량");
                setBackgroundColor(ColorUtil.GRID_HEADER_BACK);
            } else {
                m_viewPrice.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
                m_viewQty.setGravity(Gravity.RIGHT | Gravity.CENTER_VERTICAL);
            }

        }
    }

    private class SiseItemViewHolder extends ViewHolder
    {
        private SisetemView m_viewItem;

        public SiseItemViewHolder(@NonNull View itemView) {
            super(itemView);

            m_viewItem = (SisetemView)itemView;
        }

        public void setSise(SiseInfo infoSise)
        {
            m_viewItem.setSise(infoSise);
        }
    }

    private class DataListAdapter extends Adapter<SiseItemViewHolder>
    {
        @NonNull
        @Override
        public SiseItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType)
        {
            SisetemView viewItem = new SisetemView(parent.getContext());
            viewItem.setItemMode(false);
            viewItem.setLayoutParams(new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
            return new SiseItemViewHolder(viewItem);
        }

        @Override
        public void onBindViewHolder(@NonNull SiseItemViewHolder holder, int position)
        {
            holder.setSise(m_arrList.get(position));
        }

        @Override
        public int getItemCount()
        {
            return m_arrList.size();
        }
    }
}
