package com.eugenefn.openapi.sample.view.view;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.eugenefn.openapi.proc.SmartChampAPI;
import com.eugenefn.openapi.proc.SmartChampDefs;
import com.eugenefn.openapi.sample.view.util.LayoutUtil;
import com.eugenefn.openapi.sample.view.util.SampleUtil;

public class UserInfoView
    extends LinearLayout
{
    public UserInfoView(Context context) {
        super(context);

        setOrientation(LinearLayout.VERTICAL);
    }

    public void setUserInfo()
    {
        removeAllViews();

        SmartChampAPI mng = SmartChampAPI.getInstance();

        int nLoginType = mng.getLoginType();

        addLine(2);
        addInfo("아이디", mng.getLoginUserID());
        addLine(1);
        addInfo("로그인상태", nLoginType == SmartChampDefs.LOGIN_TYPE_CERT ? "거래용 로그인" :
                nLoginType == SmartChampDefs.LOGIN_TYPE_SISE ? "시세 로그인" : nLoginType == SmartChampDefs.LOGIN_TYPE_AUTO ? "자동로그인" : "비로그인");
        addLine(2);
    }
    private void addInfo(String strTitle, String strValue)
    {
        TextView viewName = LayoutUtil.makeTextView(getContext(), strTitle);
        TextView viewValue = LayoutUtil.makeTextView(getContext(), strValue);

        LinearLayout layout = new LinearLayout(getContext());
        layout.setOrientation(LinearLayout.HORIZONTAL);
        layout.addView(viewName, new LinearLayout.LayoutParams(0, LayoutParams.MATCH_PARENT, 0.4f));
        layout.addView(viewValue, new LinearLayout.LayoutParams(0, LayoutParams.MATCH_PARENT, 0.6f));

        addView(layout, new LinearLayout.LayoutParams(LayoutParams.MATCH_PARENT, (int)SampleUtil.dipToPixels(getContext(), 50)));
    }

    private void addLine(int nSize)
    {
        View viewLine = new View(getContext());
        viewLine.setBackgroundColor(Color.LTGRAY);

        addView(viewLine,
                new LinearLayout.LayoutParams(LayoutParams.MATCH_PARENT, (int)SampleUtil.dipToPixels(getContext(),nSize)));
    }
}
