//
//  BaseDataProc.h
//  SmartVIGS
//
//  Created by itgen on 11. 3. 30..
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//


#import <Foundation/Foundation.h>

@class MVDataManager;
@class TranInfo;
@class MVBlockDataProc;
@class MVFormManager;

@interface BaseDataProc : NSObject {

    @public;
        NSString                *szTranID;
        NSString                *szTranCode;
        
    @protected;
        
        MVDataManager             *m_oDataMngr;
        MVFormManager             *m_oFormMngr;
        TranInfo                *m_oTranInfo;
        NSMutableArray            *m_blockDPList;
        NSMutableArray            *m_InblockDPList;
        NSMutableArray            *m_OutblockDPList;
        NSMutableDictionary        *m_blockDPMap;
        int                        m_nTranIndex;
        BOOL                    m_isReject;
}

@property (nonatomic, retain) NSString            *szTranID;
@property (nonatomic, retain) NSString            *szTranCode;


- (id)              initWithDataMngr    : (MVDataManager *)dataMngr;
- (void)            close;
- (void)            setBlockDataProcMap    :    (NSString*)name  dataProc:(MVBlockDataProc*)proc;
- (MVBlockDataProc*)    getBlockDataProcMap    :    (NSString*)sName;
- (MVBlockDataProc*)    getBlockDataProc    :    (int)index;
- (NSMutableArray*)    getBlockDataProcList;
- (NSMutableArray*)    getInBlockDataProcList;
- (NSMutableArray*)    getOutBlockDataProcList;
- (TranInfo*)        getTranInfo;
- (int)                getIndex;
- (void)            setIndex            :    (int)index;
- (void)            setBlockInfo;
- (void)            updateLinkData      :(BOOL)bNextData;
- (NSData *)        getInputData;
- (void)            clearInputData;
- (void)            clearOutputData;
- (void)            setDataReject:(BOOL)isReject;
- (void)            clearRequest;
- (void)            setCopy:(NSString*)sTranID oCopyProc:(BaseDataProc*)oCopyProc;
- (BOOL)            setQueryInfo:(NSString*)strQuery;

- (NSData*)         getCancelRealInput;
- (MVDataManager*)  getDataMngr;
- (BOOL)            preprocessInBlockData;

// Override 기반 함수들 추가 -by Berdo 2013-04-09
- (NSData *)        GetStructureInputData;
- (NSData *)        GetWebSocketJsonInputData;
- (NSData *)        GetCancelFeedInputData;
- (NSData *)        GetCancelWebSocketJsonFeedInputData;

- (void)            ProcessStructureData:(NSObject*)infoDataBase szData:(char*)szData;
- (void)            ProcessStructureSiseData:(NSObject*)infoDataBase szData:(char*)szData;
- (void)            ProcessWebSocketJsonData:(NSObject*)infoDataBase szData:(char*)szData;
- (void)            ProcessWebSocketJsonSiseData:(NSObject*)infoDataBase szData:(char*)szData;

@end
