//
//  INetInitDelegate.h
//  NetAPI
//
//  Created by aaab on 2023/01/11.
//

#ifndef INetInitDelegate_h
#define INetInitDelegate_h

@protocol INetInitDelegate <NSObject>

/**
 * 서버 접속 시작
 */
- (void)onSessionConnecting;;

/**
 * 서버 접속 완료
 * @param isSuccess 성공여부
 * @param strErrorMsg 에레메세지
 */
- (void)onSessionConnected:(BOOL)isSuccess error:(NSString*)strErrorMsg;

/**
 * API 버젼체크
 * param nCheckState 업데이트 필요 유형 ( -1 : 오류, 0 : 필요없음, 1 : 권고, 2 : 강제업데이트 )
 * param sUpdateInfo
 */
- (void)onAPIVersionState:(NSInteger)nCheckState update:(NSString*)sUpdateInfo;

/**
 * 파일 다운로드 작업 상태
 * param nState 다운로드 상태 ( 0 : 진행중, 1 : 상태알림, 2 : 완료 )
 * param nIndex 진행상태
 * param nCount 전체갯수
 * param sMessage 메시지 ( 상태 알림 )
 */
- (void)onUpdateDownloadState:(NSInteger)nState index:(NSInteger)nIndex count:(NSInteger)nCount message:(NSString*)sMessage;


/**
 * 마스터 로드 작업 상태
 * @param nState 로드 상태 ( 0 : 시작, 1 : 완료 )
 */
- (void)onMasterLoadState:(NSInteger)nState;


/**
 * 모든 초기화 작업 완료된 상태
 */
- (void) onInitFinished;

/**
 * 재접속
 */
- (void) onRequiredRefresh;


@end


#endif /* INetInitDelegate_h */
