//
//  ITranDataDelegate.h
//  NetAPI
//
//  Created by aaab on 2023/01/30.
//

#ifndef ITranDataDelegate_h
#define ITranDataDelegate_h

@class SmartChampTran;

@protocol ITranDataDelegate <NSObject>

// 서비스 요청 전에 호출
- (void)onTranBeforeRequest:(NSString*)sTranID nextQuery:(BOOL)isNextQuery;
// 서비스 요청 결과 수신
- (void)onTranDataReceived:(NSString*)tran msgCode:(NSString*)code msgText:(NSString*)text;
// 서비스 오류 수신
- (void)onTranError:(NSString*)tran msgCode:(NSString*)code msgText:(NSString*)text;
// 서비스 타임아웃 (서버 응답 없음)
- (void)onTranTimeout:(NSString*)tran;


@end

#endif /* ITranDataDelegate_h */
