//
//  LoginDataInfo.h
//  NetAPI
//
//  Created by aaab on 2023/01/07.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

// 로그인 모드
typedef NS_ENUM(NSInteger , LOGIN_MODE )
{
    LOGIN_MODE_NONE = -1,   // 지정안됨
    LOGIN_MODE_AUTO = 1,    // 자동로그인
    LOGIN_MODE_SISE = 2,    // 시세 로그인
    LOGIN_MODE_CERT = 3,    // 인증 로그인
};

// 인증 로그인 유형
typedef NS_ENUM(NSInteger , LOGIN_CERT_TYPE)
{
    LOGIN_CERT_TYPE_NONE = -1,
    LOGIN_CERT_TYPE_IDPWDCERT = 0,  // 아이디/비번/인증서비번
    LOGIN_CERT_TYPE_CERTONLY = 1,   // 인증서/인증서비번
};

@interface LoginDataInfo : NSObject
{
    // 로그인 모드
    LOGIN_MODE m_nLoginMode;
    // 인증 유형
    LOGIN_CERT_TYPE m_nCertType;
    // 재접속 여부
    BOOL m_isReconnect;

    NSString *m_strUserId;
    NSString *m_strUserCIF;
    NSString *m_strUserPwd;
    NSString *m_strPwdDate;
    NSString *m_strPwdTime;
    NSString *m_strCertPwd;
    NSString *m_strCertDN;

    NSString *m_strUserName;
    NSString *m_strJumin1;
    NSString *m_strJumin2;
    NSString *m_strOSSiseAuth;
}

@property (nonatomic , strong) NSString *m_strUserId;
@property (nonatomic , strong) NSString *m_strUserCIF;
@property (nonatomic , strong) NSString *m_strUserPwd;
@property (nonatomic , strong) NSString *m_strPwdDate;
@property (nonatomic , strong) NSString *m_strPwdTime;
@property (nonatomic , strong) NSString *m_strCertPwd;
@property (nonatomic , strong) NSString *m_strCertDN;


@property (nonatomic , strong) NSString *m_strUserName;
@property (nonatomic , strong) NSString *m_strJumin1;
@property (nonatomic , strong) NSString *m_strJumin2;
@property (nonatomic , strong) NSString *m_strOSSiseAuth;

- (void)setLoginInfo:(NSString*)strUserId userPwd:(NSString*)strUserPwd  certPwd:(NSString*)strCertPwd;
- (void)setLoginInfo:(NSString*)strCertDN certPwd:(NSString*)strCertPwd;
- (void)setAutoLoginInfo;
- (void)setReconnectLoginInfo;
- (BOOL)isLoginAvailable;
- (BOOL)isAutoLogin;
- (BOOL)isSiseLogin;
- (BOOL)isCertLogin;
- (BOOL)isOnlyCertLogin;

@end

NS_ASSUME_NONNULL_END
