//
//  MVRealDataProc.h
//  MVigsEngine
//
//  Created by W JW on 12. 6. 20..
//  Copyright (c) 2012년 itgen. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "TBXML.h"
#import "BaseDataProc.h"

#define REAL_COUNT_MAX    10

@class RequestRealInfo;
@class RequestRealData;
@class TranInfo;
@class MVBlockDataProc;

@interface MVRealDataProc : BaseDataProc {
    
@public
    RequestRealInfo        *m_oInfoReq;
    NSMutableArray        *m_RegKeyList;        // 현재 등록된 실시간 키 리스트
    int                    m_nKeyLength;
    
@private
    BOOL                m_bRegTimer;
    long                m_lCurrTime;
    
}

- (id)      initRealWithDataMngr    : (MVDataManager *)dataMngr;
- (void)    makeRequestInfo;
- (void)    setTranInfo                    : (TranInfo*)traninfo;
- (void)    setXmlInfo                    : (TBXMLElement*)elem;
- (void)    initData;
- (void)    requestRealData;
- (void)    cancelRealData;
- (void)    onDataReceived                : (RequestRealData*)infoData;
- (void)    sendDataToForm                : (MVBlockDataProc*)BlockDP;
- (void)    registerTimer;
- (void)    deleteTimer;
- (void)    onTimer;

- (NSData *)        GetWebSocketJsonInputData;
- (NSData *)        GetCancelWebSocketJsonFeedInputData;

- (void)            ProcessWebSocketJsonSiseData:(NSObject*)infoDataBase szData:(char*)szData;
- (RequestRealInfo*) getReqInfo;

- (NSArray*)getInputBlockNames;
- (NSArray*)getOutBlockNames;
- (NSArray*)getFieldNames:(NSString*)blockID;
- (BOOL)isOccursBlock:(NSString*)blockID;
- (BOOL)isAccountNoField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (BOOL)isEncryptField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (BOOL)isItemCodeField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (BOOL)isPasswordField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (NSString*)getFieldName:(NSString*)blockID fieldID:(NSString*)fieldID;
@end
