//
//  ComboBox.m
//  EugineAPISample
//
//  Created by aaab on 2023/01/26.
//

#import "ComboBox.h"
#import "ComUtil.h"

@interface ComboBox() < UITableViewDelegate , UITableViewDataSource >
{
    UIButton *comboButton;
    UIView *backgroundView;
    NSArray *arrayKeys;
    UILabel *placeHolderLabel;
    NSArray *arrayTitles;
    UITableView *comboTableView;
    NSInteger nSelectIndex;
    id <IComboBox> comboDelegate;
}
@end

@implementation ComboBox


- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self){
        comboButton = [UIButton buttonWithType:UIButtonTypeCustom];
        [comboButton setFrame:self.bounds];
        [comboButton.titleLabel setLineBreakMode:NSLineBreakByTruncatingTail];
        [comboButton addTarget:self action:@selector(onComboInButton:) forControlEvents:UIControlEventTouchUpInside];
        [ComUtil makeRoundView:comboButton radius:0 width:1 bordercolor:[UIColor blackColor]];
        [ComUtil setColorInButton:comboButton color:[UIColor blackColor]];
        UIFont *fontMedium = [UIFont fontWithName:@"HelveticaNeue-Medium" size:13];
        [comboButton.titleLabel setFont:fontMedium];
        UIImage *normal = [UIImage imageNamed:@"ico_list_next_n.png"];
        UIImage *normalS = [UIImage imageNamed:@"ico_list_prev_n.png"];
        UIImageView *imageSelector = [[UIImageView alloc] initWithImage:normal highlightedImage:normalS];
        CGFloat height = CGRectGetHeight(self.frame);
        [imageSelector setFrame:CGRectMake(CGRectGetWidth(frame) - height / 2 - 5 , (CGRectGetHeight(frame) - (height / 2)) / 2, height / 2, height / 2)];
        [self addSubview:comboButton];
        [self addSubview:imageSelector];
    }
    return self;
}
- (void)setPlaceHolder:(NSString*)placeHolder
{
    if ( placeHolderLabel == nil){
        placeHolderLabel = [[UILabel alloc] initWithFrame:CGRectMake(20, 0, CGRectGetWidth(self.bounds) - 40, CGRectGetHeight(self.frame))];
        [self addSubview:placeHolderLabel];
        [placeHolderLabel setBackgroundColor:[UIColor clearColor]];
        [placeHolderLabel setTextColor:[UIColor lightGrayColor]];
        [placeHolderLabel setUserInteractionEnabled:NO];
        [placeHolderLabel setTextAlignment:NSTextAlignmentCenter];
    }
    if (arrayKeys != nil && [arrayKeys count] > 0){
        [placeHolderLabel setHidden:YES];
    }
    [placeHolderLabel setText:placeHolder];
}

- (NSInteger)getSelectIndex
{
    return nSelectIndex;
}

- (void)setComboDelegate:(id <IComboBox>)delegate
{
    comboDelegate = delegate;
}

- (NSString*)getSelectkey{
    if (arrayKeys == nil || [arrayKeys count] == 0) return @"";
    return arrayKeys[nSelectIndex];
}

- (NSString*)getSelectName{
    if (arrayTitles == nil || [arrayTitles count] == 0) return @"";
    return arrayTitles[nSelectIndex];
}

- (void)setSelectIndex:(NSInteger)index
{
    nSelectIndex = index;
    NSString *sTitle = arrayTitles[nSelectIndex];
    [self setTitle:sTitle];
}

- (void)setKeys:(NSArray*)keys title:(NSArray*)titles
{
    arrayKeys = [NSArray arrayWithArray:keys];
    arrayTitles = [NSArray arrayWithArray:titles];
    
    nSelectIndex = 0;
    if ([arrayTitles count] > 0){
        [placeHolderLabel setHidden:YES];
    }else{
        [placeHolderLabel setHidden:NO];
    }
    if ([arrayTitles count] == 0) return;
    NSString *sTitle = arrayTitles[nSelectIndex];
    [self setTitle:sTitle];
}

- (void)setTitle:(NSString*)title{
    [ComUtil setTitleInButton:comboButton title:title];
}

- (void)onComboInButton:(UIButton*)btn{
    UIWindow *window = [[UIApplication sharedApplication] windows][0];
    backgroundView = [[UIView alloc] initWithFrame:window.bounds];
    [backgroundView setBackgroundColor:[[UIColor blackColor] colorWithAlphaComponent:0.4]];
    [window addSubview:backgroundView];
    
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    [button setFrame:CGRectMake(CGRectGetWidth(backgroundView.frame) -  80, 100 , 60, 60)];
    UIImage *image = [UIImage imageNamed:@"close_icon@2x.png"];
    [button setImage:image forState:UIControlStateNormal];
    [button setImage:image forState:UIControlStateHighlighted];
    [button addTarget:self action:@selector(onCloseButton:) forControlEvents:UIControlEventTouchUpInside];
    [ComUtil makeRoundView:button radius:30 width:1 bordercolor:[UIColor whiteColor]];
    
    
//    UITapGestureRecognizer *tapGesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(gesture:)];
//    [backgroundView addGestureRecognizer:tapGesture];
    
    CGFloat xPadding = 50;
    CGFloat yPadding = 100;
    CGFloat height = CGRectGetHeight(window.frame) - yPadding * 5;
    CGFloat width = CGRectGetWidth(window.frame);
    
    comboTableView = [[UITableView alloc] initWithFrame:CGRectMake(xPadding, (CGRectGetHeight(backgroundView.frame) - height) / 2 , width - xPadding * 2, height) style:UITableViewStylePlain];
    [comboTableView setDelegate:self];
    [comboTableView setDataSource:self];
    [backgroundView addSubview:comboTableView];
    [ComUtil makeRoundView:comboTableView radius:0 width:1 bordercolor:[UIColor blackColor]];
    
    [backgroundView addSubview:button];
}

- (void)onCloseButton:(UIButton*)sender
{
    [backgroundView removeFromSuperview];
    backgroundView = nil;
    
    [comboTableView removeFromSuperview];
    comboTableView = nil;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return arrayTitles == nil? 0 : [arrayTitles count];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    
    static NSString *CellIdentifier = @"comboCell";
    UILabel *codelabel = nil;
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier];
        
        
        codelabel = [[UILabel alloc] initWithFrame:CGRectMake(20, 0, CGRectGetWidth(cell.frame) - 40, CGRectGetHeight(cell.frame))];
        [codelabel setTag:1];
        [cell.contentView addSubview:codelabel];
    }
    
    if (codelabel == nil){
        codelabel = [cell.contentView viewWithTag:1];
    }
   
    NSString *title = [arrayTitles objectAtIndex:indexPath.row];
    UIFont *fontMedium = [UIFont fontWithName:@"HelveticaNeue-Medium" size:16];
    NSDictionary *dicAttr = [ComUtil makeFontAttrDictionary:fontMedium fontColor:[UIColor blackColor] underLine:NO letterSpace:0 paragraph:nil];
    NSMutableAttributedString *attr = [[NSMutableAttributedString alloc] initWithString:title attributes:dicAttr];
    
    if ( [arrayKeys count] >= indexPath.row){
        UIFont *fontLight = [UIFont fontWithName:@"HelveticaNeue-Light" size:16];
        NSDictionary *dicAttr2 = [ComUtil makeFontAttrDictionary:fontLight fontColor:[UIColor blackColor] underLine:NO letterSpace:0 paragraph:nil];
        
        NSString *sKey = arrayKeys[indexPath.row];
        NSString *sKeyTitle = [NSString stringWithFormat:@"(%@)" , sKey];
        
        NSMutableAttributedString *attr2 = [[NSMutableAttributedString alloc] initWithString:sKeyTitle attributes:dicAttr2];
        [attr appendAttributedString:attr2];
    }
    [codelabel setAttributedText:attr];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    nSelectIndex = indexPath.row;
    NSString *selectKey = [arrayKeys objectAtIndex:indexPath.row];
    [self setSelectIndex:nSelectIndex];
    [placeHolderLabel setHidden:YES];
    if (comboDelegate != nil){
        [comboDelegate selectComboBox:self selectKey:selectKey];
    }
    
    [backgroundView removeFromSuperview];
    backgroundView = nil;
    
    [comboTableView removeFromSuperview];
    comboTableView = nil;
}

- (void)gesture:(UITapGestureRecognizer*)tap
{
    CGPoint point = [tap locationInView:backgroundView];
    
//    if ( CGRectContainsPoint(comboTableView.frame, point)){
//        return;
//    }
    
    [backgroundView removeFromSuperview];
    backgroundView = nil;
    
    [comboTableView removeFromSuperview];
    comboTableView = nil;
}

@end
