//
//  HogaControlView.h
//  EugineAPISample
//
//  Created by aaab on 2023/01/31.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM (NSInteger , HOGA_TYPE){
    HOGA_TYPE_STOCK = 0 ,
    HOGA_TYPE_FUTURE = 1,
};


@protocol IHogaControlDelegate <NSObject>

- (void)selectPrice:(NSString*)price;

@end

@interface HogaControlView : UIScrollView


- (id)initWithFrame:(CGRect)rect rowHeight:(CGFloat)height type:(HOGA_TYPE)type;
- (void)setHogaControlDelegate:(id <IHogaControlDelegate>)delegate;
- (void)setBuyItem:(NSArray*)arrayBuy;
- (void)setSellItem:(NSArray*)arraySell;
- (void)invalidate;
@end

NS_ASSUME_NONNULL_END
