//
//  HogaControlView.m
//  EugineAPISample
//
//  Created by aaab on 2023/01/31.
//

#import "HogaControlView.h"
#import "HogaItem.h"
#import "ComUtil.h"

@interface HogaControlView()
{
    HOGA_TYPE m_hogaType;
    UIView  *buyBackView;
    UIView  *sellBackView;
    
    NSArray *arrayBuyItem;
    NSMutableArray *arrayBuyView;
    NSMutableArray *arrayBuyBalanceView;
    NSArray *arrayBuyRateItem;
    NSMutableArray *arrayBuyRateView;
    
    
    NSArray *arraySellItem;
    NSMutableArray *arraySellView;
    NSMutableArray *arraySellBalanceView;
    NSArray *arraySellRateItem;
    NSMutableArray *arraySellRateView;
    CGFloat fRowHeight;
    
    id <IHogaControlDelegate> m_delegate;
}

@end

@implementation HogaControlView


- (id)initWithFrame:(CGRect)rect rowHeight:(CGFloat)height type:(HOGA_TYPE)type
{
    self = [super initWithFrame:rect];
    if (self){
        fRowHeight = height;
        m_hogaType = type;
        
        arrayBuyItem = nil;
        arrayBuyView = [NSMutableArray array];
        arrayBuyBalanceView = [NSMutableArray array];
        arrayBuyRateView = [NSMutableArray array];
        arrayBuyRateItem = nil;
        
        arraySellItem = nil;
        arraySellView = [NSMutableArray array];
        arraySellBalanceView = [NSMutableArray array];
        arraySellRateView = [NSMutableArray array];
        arraySellRateItem = nil;
        
        [self makeHogaView];
        
        UITapGestureRecognizer *tapGesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(onTapGesture:)];
        [self addGestureRecognizer:tapGesture];
        [self setBounces:NO];
    }
    
    return self;
}


- (void)onTapGesture:(UITapGestureRecognizer*)gesture
{
    CGPoint gesturePoint = [gesture locationInView:self];
    
    for ( UILabel *labelView in arrayBuyView){
        if (CGRectContainsPoint(labelView.frame, gesturePoint)){
            if ( m_delegate != nil){
                NSString *price = [labelView.text stringByReplacingOccurrencesOfString:@"," withString:@""];
//                price = [labelView.text stringByReplacingOccurrencesOfString:@"." withString:@""];
                [m_delegate selectPrice:price];
            }
        }
    }
    
    for ( UILabel *labelView in arraySellView){
        if (CGRectContainsPoint(labelView.frame, gesturePoint)){
            if ( m_delegate != nil){
                NSString *price = [labelView.text stringByReplacingOccurrencesOfString:@"," withString:@""];
//                price = [labelView.text stringByReplacingOccurrencesOfString:@"." withString:@""];
                [m_delegate selectPrice:price];
            }
        }
    }
}

- (void)makeHogaView
{
    NSInteger nRowCount = m_hogaType == HOGA_TYPE_STOCK ? 10 : 5;
    
    CGFloat fColumnWidth = CGRectGetWidth(self.frame) / 3;
    CGFloat fHalfHeight = CGRectGetHeight(self.frame) / 2;
    
    
    UIFont *fontMedium = [UIFont fontWithName:@"HelveticaNeue-Medium" size:16];
    UIFont *fontBold = [UIFont fontWithName:@"HelveticaNeue-Bold" size:16];
    UIFont *fontLight = [UIFont fontWithName:@"HelveticaNeue-Light" size:14];
    
    CGFloat ySellPos = 0;
    CGFloat yBuyPos = fRowHeight * nRowCount;
//    CGFloat xPos = fHalfHeight - fRowHeight;
    
    CGFloat priceWidth = fColumnWidth * 0.6 - 10;
    CGFloat rateWidth = fColumnWidth * 0.4 - 2;
    for (NSInteger i = 0; i < nRowCount; i++) {
        UILabel *sellBalance = [[UILabel alloc] initWithFrame:CGRectMake(0, ySellPos, fColumnWidth - 10, fRowHeight)];
        [sellBalance setTextAlignment:NSTextAlignmentRight];
        [sellBalance setFont:fontMedium];
        [sellBalance setTag:i];
        [sellBalance setBackgroundColor:[UIColor clearColor]];
        [self addSubview:sellBalance];
        [arraySellBalanceView insertObject:sellBalance atIndex:0];
        
        UILabel *sellPrice = [[UILabel alloc] initWithFrame:CGRectMake(fColumnWidth, ySellPos, priceWidth, fRowHeight)];
        [sellPrice setTextAlignment:NSTextAlignmentRight];
        [sellPrice setFont:fontBold];
        [sellPrice setTag:i];
        [sellPrice setBackgroundColor:[UIColor clearColor]];
        [self addSubview:sellPrice];
        [arraySellView insertObject:sellPrice atIndex:0];
        
        UILabel *ratesellView = [[UILabel alloc] initWithFrame:CGRectMake(CGRectGetMaxX(sellPrice.frame), ySellPos, rateWidth, fRowHeight)];
        [ratesellView setTextAlignment:NSTextAlignmentRight];
        [ratesellView setFont:fontLight];
        [ratesellView setTag:i];
        [ratesellView setBackgroundColor:[UIColor clearColor]];
        [self addSubview:ratesellView];
        [arraySellRateView insertObject:ratesellView atIndex:0];
        
        UILabel *buyPrice = [[UILabel alloc] initWithFrame:CGRectMake(fColumnWidth, yBuyPos, priceWidth, fRowHeight)];
        [buyPrice setTextAlignment:NSTextAlignmentRight];
        [buyPrice setFont:fontBold];
        [buyPrice setTag:i];
        [buyPrice setBackgroundColor:[UIColor clearColor]];
        [self addSubview:buyPrice];
        [arrayBuyView addObject:buyPrice];
        
        UILabel *rateView = [[UILabel alloc] initWithFrame:CGRectMake(CGRectGetMaxX(buyPrice.frame), yBuyPos, rateWidth, fRowHeight)];
        [rateView setTextAlignment:NSTextAlignmentRight];
        [rateView setFont:fontLight];
        [rateView setTag:i];
        [rateView setBackgroundColor:[UIColor clearColor]];
        [self addSubview:rateView];
        [arrayBuyRateView addObject:rateView];
        
        UILabel *buyBalance = [[UILabel alloc] initWithFrame:CGRectMake(fColumnWidth * 2, yBuyPos, fColumnWidth - 10, fRowHeight)];
        [buyBalance setTextAlignment:NSTextAlignmentRight];
        [buyBalance setFont:fontMedium];
        [buyBalance setTag:i];
        [buyBalance setBackgroundColor:[UIColor clearColor]];
        [self addSubview:buyBalance];
        [arrayBuyBalanceView addObject:buyBalance];
        
        ySellPos += fRowHeight;
        yBuyPos += fRowHeight;
    }
    
    UIView *lastSellView = [arraySellView lastObject];
    UIView *firstSellView = [arraySellView firstObject];
    
    sellBackView = [[UIView alloc] initWithFrame:CGRectMake(fColumnWidth, CGRectGetMinY(lastSellView.frame), fColumnWidth, CGRectGetMaxY(firstSellView.frame))];
    [sellBackView setBackgroundColor:[UIColor colorWithRed:248/255.0f green:250/255.0f blue:255/255.0f alpha:1.0f]];
    [self insertSubview:sellBackView atIndex:0];
    
    UIView *lastBuyView = [arrayBuyView lastObject];
    UIView *firstBuyView = [arrayBuyView firstObject];
    buyBackView = [[UIView alloc] initWithFrame:CGRectMake( fColumnWidth, CGRectGetMinY(firstBuyView.frame), fColumnWidth, CGRectGetMaxY(lastBuyView.frame))];
    [buyBackView setBackgroundColor:[UIColor colorWithRed:254/255.0f green:247/255.0f blue:247/255.0f alpha:1.0f]];
    [self insertSubview:buyBackView atIndex:0];
    
    if (CGRectGetHeight(self.frame) < yBuyPos){
        [self setContentSize:CGSizeMake(0, yBuyPos)];
    }
}

- (void)setBuyItem:(NSArray*)arrayBuy
{
    arrayBuyItem = [NSArray arrayWithArray:arrayBuy];
}

- (void)setSellItem:(NSArray*)arraySell
{
    arraySellItem = [NSArray arrayWithArray:arraySell];
}

- (void)invalidate{
    if ( [arrayBuyItem count] <= [arrayBuyView count] ){
        for ( NSInteger i = 0 ; i < [arrayBuyItem count] ; i++ ){
            HogaItem *itemHoga = arrayBuyItem[i];
            
            UILabel *label = [arrayBuyView objectAtIndex:i];
            [label setText:itemHoga.price];
            [label setTextColor:itemHoga.priceColor];
            
            UILabel *ratelabel = arrayBuyRateView[i];
            [ratelabel setText:itemHoga.rate];
            [ratelabel setTextColor:itemHoga.priceColor];
            
            UILabel *balanceLabel = arrayBuyBalanceView[i];
            [balanceLabel setText:itemHoga.hogaBalance];
            [balanceLabel setTextColor:itemHoga.hogaBalanceColor];
            
//            if (itemHoga.isCurPrice){
//                [ComUtil makeRoundView:label radius:0 width:1 bordercolor:[UIColor redColor]];
//            }else{
//                [ComUtil makeRoundView:label radius:0 width:1 bordercolor:[UIColor clearColor]];
//            }
        }
    }
    
    if ( [arraySellItem count] <= [arraySellView count] ){
        for ( NSInteger i = 0 ; i < [arraySellItem count] ; i++ ){
            HogaItem *itemHoga = arraySellItem[i];
            
            UILabel *label = [arraySellView objectAtIndex:i];
            [label setText:itemHoga.price];
            [label setTextColor:itemHoga.priceColor];
            
            UILabel *ratelabel = arraySellRateView[i];
            [ratelabel setText:itemHoga.rate];
            [ratelabel setTextColor:itemHoga.priceColor];
            
            UILabel *balanceLabel = arraySellBalanceView[i];
            [balanceLabel setText:itemHoga.hogaBalance];
            [balanceLabel setTextColor:itemHoga.hogaBalanceColor];
            
//            if (itemHoga.isCurPrice){
//                [ComUtil makeRoundView:label radius:0 width:1 bordercolor:[UIColor redColor]];
//            }else{
//                [ComUtil makeRoundView:label radius:0 width:1 bordercolor:[UIColor clearColor]];
//            }
        }
    }
}


- (void)setBuyRateItem:(NSArray*)array
{
    arrayBuyRateItem = [NSArray arrayWithArray:array];
}

- (void)setSellRateItem:(NSArray*)array
{
    arraySellRateItem = [NSArray arrayWithArray:array];
}

- (void)setHogaControlDelegate:(id <IHogaControlDelegate>)delegate
{
    m_delegate = delegate;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
