//
//  MyTextField.m
//  EugineAPISample
//
//  Created by aaab on 2023/02/09.
//

#import "MyTextField.h"
#import "ComUtil.h"
#import "ComboBox.h"
#import "SmartChampAPI.h"
#import "Util.h"
#import "iToast.h"

@interface MyTextField()
{
    NSInteger nIndex;
    NSString *sKey;
    NSString *blockID;
    BOOL    isAccount;
    UIButton *accountBtn;
    ComboBox *comboBtn;
}
@end

@implementation MyTextField

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

- (void)makeAccountButton{
    if (accountBtn == nil)
    {
        accountBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [accountBtn setFrame:CGRectMake(CGRectGetWidth(self.frame) - CGRectGetHeight(self.frame) - 20, 0, CGRectGetHeight(self.frame) + 20, CGRectGetHeight(self.frame))];
        [accountBtn.titleLabel setFont:[Util fontType:LIGHT size:10]];
        [ComUtil setTitleInButton:accountBtn title:@"계좌"];
        [ComUtil setColorInButton:accountBtn color:[UIColor whiteColor]];
        [accountBtn setBackgroundColor:[UIColor blackColor]];
        [ComUtil makeRoundView:accountBtn radius:2 width:1 bordercolor:[UIColor blackColor]];
        [accountBtn addTarget:self action:@selector(onAccountBtn:) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:accountBtn];
        
        
        NSInteger nAccountSize = [[SmartChampAPI instance] getAccountSize];
        
        NSMutableArray *arrayAccountNo = [NSMutableArray array];
        NSMutableArray *arrayAccountName = [NSMutableArray array];
        for (NSInteger i = 0; i < nAccountSize; i++) {
            NSString *sAccountNO = [[SmartChampAPI instance] getAccountNo:i];
            NSString *sAccountName = [[SmartChampAPI instance] getAccountName:i];
            
            [arrayAccountNo addObject:sAccountNO];
            [arrayAccountName addObject:[NSString stringWithFormat:@"%@(%@)" , sAccountNO , sAccountName]];
        }
        
        comboBtn = [[ComboBox alloc] initWithFrame:CGRectZero];
        [comboBtn setComboDelegate:self];
        [comboBtn setKeys:arrayAccountNo title:arrayAccountName];
        [self addSubview:comboBtn];
        
        [[iToast instance] showText:@"계좌 버튼은 키패드를 내리고 눌러주세요." duration:iToastDurationLong gravity:iToastGravityBottom];
    }
}

- (void)selectComboBox:(ComboBox*)box selectKey:(NSString*)key
{
    self.text = [box getSelectkey];
}

- (void)onAccountBtn:(UIButton*)sender
{
    [comboBtn onComboInButton:nil];
}

- (void)setFrame:(CGRect)frame
{
    [super setFrame:frame];
    
    if (bottomView == nil)
    {
        bottomView = [[UIView alloc] initWithFrame:CGRectMake(0, CGRectGetHeight(frame) - 1, CGRectGetWidth(frame), 1)];
        [bottomView setBackgroundColor:[UIColor blackColor]];
    }else{
    }
    [self addSubview:bottomView];
}

- (void)setAccount:(BOOL)account
{
    isAccount = account;
    
    if (isAccount){
        [self makeAccountButton];
    }
}

- (BOOL)isAccoutNO
{
    return isAccount;
}

- (void)setIndex:(NSInteger)index
{
    nIndex = index;
}
- (int)getIndex
{
    return nIndex;
}
- (void)setBlockID:(NSString*)block
{
    blockID = block;
}
- (NSString*)getBlockID
{
    return blockID;
}


- (void)setField:(NSString *)key
{
    sKey = key;
}

- (NSString*)getField
{
    return sKey;
}
@end
