//
//  Util.m
//  EugineAPISample
//
//  Created by aaab on 2023/01/03.
//

#import "Util.h"
#import "SmartChampDefs.h"
#import "ComUtil.h"
#import "DataAttr.h"

@implementation Util

+ (void) makeRoundView:(UIView *)window radius:(CGFloat)radius width:(CGFloat)width bordercolor:(UIColor *)bordercolor
{
    if (window == nil) return ;
    
    [window.layer setCornerRadius:radius];
    [window.layer setBorderWidth:width];
    [window.layer setMasksToBounds:YES];
    [window.layer setBorderColor:bordercolor.CGColor];
}

+ (NSString *) getCurrencyFromString:(NSString *)value formatter:(nullable NSNumberFormatter *)formatter
{
    if ([value floatValue] == 0) return @"";
    if (formatter == nil) formatter = [[NSNumberFormatter alloc] init];
    
    [formatter setFormatterBehavior:NSNumberFormatterBehaviorDefault];
    [formatter setNumberStyle:NSNumberFormatterDecimalStyle];
    
    return [formatter stringFromNumber:[NSNumber numberWithFloat:[value floatValue]]];
}

+ (UIColor*) getValueColor:(NSInteger)nAttr
{
    switch(nAttr) {
        case DATA_ATTR_RED:
        case DATA_ATTR_RED_R:
            return [UIColor redColor];
        case DATA_ATTR_BLUE:
        case DATA_ATTR_BLUE_R:
            return [UIColor blueColor];
        case DATA_ATTR_GREEN:
            return [UIColor blackColor];
    }
//    NSLog(@"color attr [%d] " , nAttr);
    return [UIColor blackColor];
}
    
+ (UIImage*)getValueSign:(NSString*)strSign
{
    if ([ComUtil isTextEmpty:strSign]) return nil;
    

    char chSign = [strSign characterAtIndex:0];

    switch(chSign)
    {
        case '1':    return [UIImage imageNamed:@"ic_fluctuat_maxdup_16_n.png"];    // 상한
        case '2':
        case '+':    return [UIImage imageNamed:@"ic_fluctuat_up_16_n.png"];    // 상한    // 상승
        case '3':
        case ' ':    return nil;    // 보합
        case '4':    return [UIImage imageNamed:@"ic_fluctuat_maxdown_16_n"];    // 하한
        case '5':
        case '-':    return [UIImage imageNamed:@"ic_fluctuat_down_16_n.png"]	;    // 하락
    }

    return nil;
}

+ (UIFont*)fontType:(FONT_TYPE)type size:(CGFloat)size
{
    switch (type)
    {
        case LIGHT:
            return [UIFont fontWithName:@"HelveticaNeue-Light" size:size];
        case MEDIUM:
            return [UIFont fontWithName:@"HelveticaNeue-Medium" size:size];
        case BOLD:
            return [UIFont fontWithName:@"HelveticaNeue-Bold" size:size];
    }
    
    return [UIFont fontWithName:@"HelveticaNeue-Medium" size:size];
}

+ (UIColor*)getRedColor
{
    return [UIColor colorWithRed:229/255.f green:104/255.0f blue:99/255.0f alpha:1.0f];
}

+ (UIColor*)getBlueColor
{
    return [UIColor colorWithRed:59/255.f green:124/255.0f blue:225/255.0f alpha:1.0f];
}

+ (UIColor*)getCollectColor
{
    return [UIColor colorWithRed:74/255.f green:164/255.0f blue:90/255.0f alpha:1.0f];
}

+ (UIColor*)getCancelColor
{
    return [UIColor colorWithRed:229/255.f green:177/255.0f blue:84/255.0f alpha:1.0f];
}

+ (BOOL)isNumber:(NSString *)number
{
    NSNumberFormatter *formatter = [[NSNumberFormatter alloc] init];
    [formatter setNumberStyle:NSNumberFormatterDecimalStyle];

    NSNumber *numberN = [formatter numberFromString:number];

    if (numberN) {
        return YES;
    } else {
        return NO;
    }
    
    return NO;
}

@end
