//
//  CertListViewController.m
//  EugineAPISample
//
//  Created by aaab on 2023/01/03.
//

#import "CertListViewController.h"
#import "SmartChampAPI.h"

@interface CertListViewController () < UITableViewDelegate , UITableViewDataSource >
{
    NSMutableArray *arrayCertList;
}
@end

@implementation CertListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self.view setBackgroundColor:[UIColor whiteColor]];
    // Do any additional setup after loading the view.
    
    CGFloat selfWidth = CGRectGetWidth(self.view.frame);
    CGFloat selfHeight = CGRectGetHeight(self.view.frame);
    selfHeight -= 44;
    UITableView *tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 44, selfWidth, selfHeight)];
    [tableView setDelegate:self];
    [tableView setDataSource:self];
    [self.view addSubview:tableView];
    
    arrayCertList = [NSMutableArray array];
    
    arrayCertList = [NSMutableArray arrayWithArray:[[SmartChampAPI instance] getUserCertList]];
//    for (NSInteger i = 0; i < [arrayOrgCertList count] ; i++) {
//        NSString *sCertLine = arrayOrgCertList[i];
//        NSArray *arrayCert = [sCertLine componentsSeparatedByString:@":"];
//        NSString *sCertDN = arrayCert[1];
//        [arrayCertList addObject:sCertRt];
//    }
//    
    
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return [arrayCertList count];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"Cell";
    
    UILabel* textLabel = nil;
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier];

        textLabel = [[UILabel alloc] initWithFrame:CGRectMake(30.0, 10.0, 400, 30)];
        [textLabel setTag:1];
        [textLabel setBackgroundColor:[UIColor clearColor]];
        [cell.contentView addSubview:textLabel];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    
    if ( textLabel == nil ){
        textLabel = [cell.contentView viewWithTag:1];
    }
    
    NSString* strRet = [arrayCertList objectAtIndex:indexPath.row];
    
    NSArray *arrayRet = [strRet componentsSeparatedByString:@":"];
    
    NSString *strUserID = [arrayRet objectAtIndex:0]; // 사용자 명
    NSString *strDN = [arrayRet objectAtIndex:1]; // 사용자 DN
    NSString *strUsage = [arrayRet objectAtIndex:2]; // 용도/구분
    NSString *strIssuerName = [arrayRet objectAtIndex:3]; // 발급자명
    NSString *strIssuer = [arrayRet objectAtIndex:4]; // 발급자DN
    NSString *strExpired = [arrayRet objectAtIndex:5]; // 만료여부
    NSString *strExpreDate = [arrayRet objectAtIndex:6]; // 만료일
    NSString *strSerialNum = [arrayRet objectAtIndex:7]; // 인증서 일련번호

    [textLabel setText:strDN];

    return cell;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSString* strRet = [arrayCertList objectAtIndex:indexPath.row];
    NSArray *arrayRet = [strRet componentsSeparatedByString:@":"];
    
    NSString *strUserID = [arrayRet objectAtIndex:0]; // 사용자 명
    NSString *strDN = [arrayRet objectAtIndex:1]; // 사용자 DN
    NSString *strUsage = [arrayRet objectAtIndex:2]; // 용도/구분
    NSString *strIssuerName = [arrayRet objectAtIndex:3]; // 발급자명
    NSString *strIssuer = [arrayRet objectAtIndex:4]; // 발급자DN
    NSString *strExpired = [arrayRet objectAtIndex:5]; // 만료여부
    NSString *strExpreDate = [arrayRet objectAtIndex:6]; // 만료일
    NSString *strSerialNum = [arrayRet objectAtIndex:7]; // 인증서 일련번호
    
    [[NSNotificationCenter defaultCenter] postNotificationName:@"selectcertlist" object:nil userInfo:[NSDictionary dictionaryWithObject:strDN forKey:@"certdn"]];
    
    [self dismissViewControllerAnimated:YES completion:^{
            
    }];
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
