//
//  CopyCertViewController.m
//  EugineAPISample
//
//  Created by aaab on 2023/01/02.
//

#import "CopyCertViewController.h"
#import "Util.h"
#import "SmartChampAPI.h"
#import "ComUtil.h"
#import "UITextField+Addition.h"

@interface CopyCertViewController ()

@end

@implementation CopyCertViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    NSString *sSimple = [[SmartChampAPI instance] requestCertImportNumber];
    NSArray *arraySimple = [sSimple componentsSeparatedByString:@"`"];
    NSString *sNumber1 = nil;
    NSString *sNumber2 = nil;
    NSString *sNumber3 = nil;
    NSArray *arrayNumber = nil;
    if  ([[arraySimple objectAtIndex:0] isEqualToString:@"Success"]){
        NSString *simpleNumber = [arraySimple objectAtIndex:1];

        sNumber1 = [simpleNumber substringToIndex:4];
        sNumber2 = [simpleNumber substringWithRange:NSMakeRange(4, 4)];
        sNumber3 = [simpleNumber substringWithRange:NSMakeRange(8, 4)];

        arrayNumber = [NSArray arrayWithObjects:sNumber1, sNumber2 , sNumber3 , nil];
    }else{
        UIAlertController* alert = [UIAlertController alertControllerWithTitle:@"알림"
                                   message:[arraySimple objectAtIndex:1]
                                   preferredStyle:UIAlertControllerStyleAlert];

        UIAlertAction* defaultAction = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault
                                       handler:^(UIAlertAction * action) {
            [self dismissViewControllerAnimated:YES completion:^{
            }];
        }];

        [alert addAction:defaultAction];
        [self presentViewController:alert animated:YES completion:nil];



    }
    [self.view setBackgroundColor:[UIColor whiteColor]];
    CGFloat xPos = 20;
    CGFloat selfframe = CGRectGetWidth(self.view.frame);
    CGFloat oneWidth = (selfframe - (xPos * 2)) / 3;
    for ( NSInteger i = 0 ; i < 3 ; i++)
    {
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(xPos, 300, oneWidth, 40)];
        [textField setKeyboardType:UIKeyboardTypeNumberPad];
        [textField addNumericAccessory:NO];
        [textField setTag:i];
        [textField setEnabled:NO];
        [textField setText:[arrayNumber objectAtIndex:i]];
        [textField setContentVerticalAlignment:UIControlContentVerticalAlignmentCenter];
        [textField setTextAlignment:NSTextAlignmentCenter];
        [self.view addSubview:textField];
        [Util makeRoundView:textField radius:5 width:2 bordercolor:[UIColor systemGrayColor]];
        xPos += oneWidth;
    }

    UIButton *btnCopy = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    [ComUtil setColorInButton:btnCopy color:[UIColor blackColor]];
    [ComUtil setTitleInButton:btnCopy title:@"인증서 가져오기"];
    [btnCopy setFrame:CGRectMake(20, 400, selfframe - 40, 60)];
    [btnCopy addTarget:self action:@selector(certImport:) forControlEvents:UIControlEventTouchUpInside];
    [Util makeRoundView:btnCopy radius:5 width:2 bordercolor:[UIColor systemGrayColor]];
    [self.view addSubview:btnCopy];
    
    [self makeCloseButton];
}


- (void)makeCloseButton
{
    
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    [button setFrame:CGRectMake(CGRectGetWidth(self.view.frame) - 50 , 15, 35, 35)];
    [button addTarget:self action:@selector(onCloseButton:) forControlEvents:UIControlEventTouchUpInside];
    UIImage *image = [UIImage imageNamed:@"ic_floating_close_48.png"];
    [button setImage:image forState:UIControlStateNormal];
    [button setImage:image forState:UIControlStateHighlighted];
    [self.view addSubview:button];
}

- (void)onCloseButton:(UIButton*)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (void)certImport:(UIButton*)sender
{
    NSString *sResult = [[SmartChampAPI instance] importCert];
    NSArray *arrayResult = [sResult componentsSeparatedByString:@"`"];
    
    if ([[arrayResult objectAtIndex:0] isEqualToString:@"Success"]){
//        UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"알림" message:[arrayResult objectAtIndex:1] preferredStyle:UIAlertControllerStyleAlert];
//        [self presentViewController:alert animated:YES completion:^{
//
//        }];
    }else{
    }
    UIAlertController* alert = [UIAlertController alertControllerWithTitle:@"알림"
                               message:[arrayResult objectAtIndex:1]
                               preferredStyle:UIAlertControllerStyleAlert];

    UIAlertAction* defaultAction = [UIAlertAction actionWithTitle:@"확인" style:UIAlertActionStyleDefault
                                   handler:^(UIAlertAction * action) {
        [self dismissViewControllerAnimated:YES completion:^{
        }];
    }];

    [alert addAction:defaultAction];
    [self presentViewController:alert animated:YES completion:nil];
}

-(void)onTouchCloseButton:(UIButton*)sender
{
    [self dismissViewControllerAnimated:YES completion:^{
            
    }];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
