//
//  CustomTableViewCell.h
//  EugineAPISample
//
//  Created by aaab on 2023/02/03.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

#define NotiTableViewCellScroll @"NotiTableViewCellScroll"

@protocol ICustomTableDelegate <NSObject>

- (void)didselectItem:(long)cellTag row:(NSInteger)rowIndex;

@end

typedef NS_ENUM(NSInteger , COLUMN_MASK)
{
    COLUMN_MASK_AUTO = 0,
    COLUMN_MASK_TEXT = 1,
    COLUMN_MASK_NUM = 2,
};

@class CondSearchInfo;
@class CondItemInfo;
@interface CustomTableViewCell : UITableViewCell


- (void)setHeaderType:(BOOL)type;
- (void)setColumnWidth:(NSArray*)width title:(NSArray*)title mask:(NSArray*)masks;
- (void)setTitleAttr:(NSDictionary*)dicAttr;
- (void)setRowIndex:(NSInteger)index;
- (void)setDelegate:(id <ICustomTableDelegate>)delegate;
- (void)setItemInfo:(CondItemInfo*)infoCond;
- (void)setSearchItemInfo:(CondSearchInfo*)infoCond;
- (void)setColumnWidth:(NSArray*)width;
- (void)setColumnTitle:(NSArray*)title;
@end

NS_ASSUME_NONNULL_END
