//
//  FIDInfo.m
//  EugineAPISample
//
//  Created by aaab on 2023/02/05.
//

#import "FIDInfo.h"

static NSMutableDictionary *mapFIDInfo = nil;
static NSMutableArray *arrFIDInfo = nil;

@interface FIDInfo()


@end

@implementation FIDInfo

@synthesize m_strId , m_strName ,m_isReal;

- (id)initWithID:(NSString*)ID name:(NSString*)name real:(BOOL)real
{
    self = [super init];
    if (self){
        if (mapFIDInfo == nil)
            mapFIDInfo = [NSMutableDictionary dictionary];
        
        if (arrFIDInfo == nil)
            arrFIDInfo = [NSMutableArray array];
        
        self.m_strId = ID;
        self.m_strName = name;
        self.m_isReal = real;
    }
    
    return self;
}

- (NSString*)getSelectName
{
    return [NSString stringWithFormat:@"[%@] %@" , m_strId , m_strName];
}

+ (NSArray*)makeFIDInfo
{
    if (arrFIDInfo != nil && [arrFIDInfo count] > 0) return arrFIDInfo;
    
    if (arrFIDInfo == nil) arrFIDInfo = [NSMutableArray array];
    
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9001" name:@"현재가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9002" name:@"전일대비" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9003" name:@"등락률" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9004" name:@"매도호가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9005" name:@"매수호가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9006" name:@"매도잔량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9007" name:@"매수잔량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9008" name:@"현재거래량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9009" name:@"거래대금" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9010" name:@"시가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9011" name:@"고가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9012" name:@"저가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9013" name:@"외인보유비중" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9014" name:@"외인수량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9015" name:@"시가총액" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9016" name:@"연중최고가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9017" name:@"연중최저가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9018" name:@"전일거래량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9019" name:@"시가등락률" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9020" name:@"거래량대비율" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9021" name:@"체결량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9022" name:@"액면가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9023" name:@"L일봉H" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9024" name:@"시가%" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9025" name:@"고가%" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9026" name:@"저가%" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9027" name:@"시가대비%" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9028" name:@"저가대비%" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9029" name:@"저가대비%" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9030" name:@"예상체결가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9031" name:@"예상체결량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9032" name:@"예상등락률" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9033" name:@"전일종가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9034" name:@"전일시가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9035" name:@"전일고가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9036" name:@"전일저가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9037" name:@"체결강도" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9038" name:@"상한가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9039" name:@"하한가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9040" name:@"매도총잔량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9041" name:@"매수총잔량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9042" name:@"총순매매잔량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9043" name:@"신용비율" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9044" name:@"공매도비율" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9045" name:@"신용" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9046" name:@"시간외등락률" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9047" name:@"시간외현재가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9048" name:@"시간외매도호가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9049" name:@"시간외매수호가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9050" name:@"시간외매도잔량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9051" name:@"시간외매수잔량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9052" name:@"52주 최고가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9053" name:@"52주 최저가" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9054" name:@"52주 최고가 대비율" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9055" name:@"52주 최저가 대비율" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9056" name:@"연중 최고가 대비율" real:NO]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9057" name:@"연중 최저가 대비율" real:NO]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9058" name:@"시가총액(재무)" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9059" name:@"업종구분" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9060" name:@"ROE" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9061" name:@"당기순이익(최근)" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9062" name:@"영업이익(최근)" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9063" name:@"EPS" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9064" name:@"PER" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9065" name:@"PBR" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9066" name:@"EV/EBITDA" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9068" name:@"자본금" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9069" name:@"증거금률" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9070" name:@"결산기" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9073" name:@"전일외국인순매수량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9074" name:@"전일기관순매수량" real:YES]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9075" name:@"5일평균" real:NO]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9076" name:@"10일평균" real:NO]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9077" name:@"20일평균" real:NO]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9078" name:@"5일평균이격도" real:NO]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9079" name:@"10일평균이격도" real:NO]];
    [arrFIDInfo addObject:[[FIDInfo alloc] initWithID:@"9080" name:@"20일평균이격도" real:NO]];

     for(FIDInfo *info in arrFIDInfo){
        [mapFIDInfo setObject:info forKey:info.m_strId];
    }
    
    return arrFIDInfo;
}


@end
