//
//  FIDSelectButton.h
//  EugineAPISample
//
//  Created by aaab on 2023/02/05.
//

#import <UIKit/UIKit.h>

@protocol OnFIDSelectionChangedDelegate

- (void)onFIDSelectionChanged:(NSArray*)arrList;

@end

    



NS_ASSUME_NONNULL_BEGIN

@interface FIDSelectButton : UIButton


- (void)setDelegate:(id<OnFIDSelectionChangedDelegate>)delegate;
- (void)updateButtonText;
- (void)rebuildSelectedList;
- (void)resetSelectedTemp;
- (void)setDefaultList;
- (void)setSelection:(NSArray*)arrSelection;
- (NSArray*)getSelectedItems;
- (NSString*)getFIDCount;
- (NSString*)getFIDList;
- (NSArray*)getTitle;
- (NSArray*)getSelectArray;
- (void)setTemp:(NSArray*)array;
@end

NS_ASSUME_NONNULL_END
