//
//  FIDSelectButton.m
//  EugineAPISample
//
//  Created by aaab on 2023/02/05.
//

#import "FIDSelectButton.h"
#import "FIDInfo.h"
#import "ComUtil.h"

@interface FIDSelectButton()
{
    NSMutableArray *m_arrItems;
    NSMutableArray *m_arrTemp;
    NSMutableArray *m_arrSelected;
    NSMutableArray *m_arrTempName;
    id<OnFIDSelectionChangedDelegate> m_delegate;
}
@end

@implementation FIDSelectButton

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self){
        [self initData];
    }
    return self;
}

- (void)setDelegate:(id<OnFIDSelectionChangedDelegate>)delegate
{
    m_delegate = delegate;
}

-(void)initData
{
    m_arrTempName = [NSMutableArray array];
    m_arrItems = [NSMutableArray arrayWithArray:[FIDInfo makeFIDInfo]];
    m_arrSelected = [NSMutableArray array];
    [ComUtil setColorInButton:self color:[UIColor blackColor]];
    m_arrTemp = [NSMutableArray array];
    [ComUtil makeRoundView:self radius:0 width:1 bordercolor:[UIColor grayColor]];
    for (NSInteger i = 0 ; i < [m_arrItems count] ; i++){
        [m_arrTemp addObject:@"0"];
    }
}

- (void)setTemp:(NSArray*)array
{
    m_arrTemp = [NSMutableArray arrayWithArray:array];
}

- (void) updateButtonText
{
    NSInteger nCount = m_arrSelected == nil ? 0 : [m_arrSelected count];

    [ComUtil setTitleInButton:self title:[NSString stringWithFormat:@"%ld개 필드" , (long)nCount]];
}

- (void)rebuildSelectedList
{
    [m_arrSelected removeAllObjects];

    for(int i = 0; i < [m_arrTemp count]; i++)
    {
        FIDInfo *infoFID = m_arrItems[i];
        if ( [m_arrTemp[i] boolValue] )
        {
            [m_arrSelected addObject:infoFID.m_strId];
        }
    }
}

- (void)resetSelectedTemp
{
    for(int i = 0; i < [m_arrTemp count]; i++)
    {
        m_arrTemp[i] = @"0";
    }
    
    for(NSString *strId in m_arrSelected)
    {
        for(int i = 0; i < [m_arrItems count]; i++)
        {
            FIDInfo *infoFID = m_arrItems[i];
            if([infoFID.m_strId isEqualToString:strId])
            {
                m_arrTemp[i] = @"1";
                break;
            }
        }
    }
}

- (void)setDefaultList
{
    NSArray *arrDef = [NSArray arrayWithObjects:@"9001", @"9002" , @"9003" , nil];
    [self setSelection:arrDef];
    
    for(int i = 0; i < [m_arrItems count]; i++)
    {
        FIDInfo *info = m_arrItems[i];
        [m_arrTempName addObject:info.m_strName];
    }
}

-  (void)setSelection:(NSArray*)arrSelection
{
    [m_arrSelected removeAllObjects];
    [m_arrSelected addObjectsFromArray:arrSelection];

    [self resetSelectedTemp];
    [self updateButtonText];
}

- (NSArray*)getSelectedItems
{
    [self rebuildSelectedList];

    return [NSArray arrayWithArray:m_arrSelected];
}

- (NSArray*)getTitle
{
    [self rebuildSelectedList];
    return [NSArray arrayWithArray:m_arrTempName];
}

- (NSArray*)getSelectArray;
{
    [self rebuildSelectedList];
    return [NSArray arrayWithArray:m_arrTemp];
}

- (NSString*)getFIDCount
{
    return [NSString stringWithFormat:@"%02ld", (long)[m_arrSelected count]];
}

- (NSString*)getFIDList
{
    NSMutableString *builder = [NSMutableString string];
    for(NSString *strFid in m_arrSelected){
        [builder appendString:strFid];
    }
    return [NSString stringWithString:builder];
}

- (void)sendAction:(UIAction *)action
{
    [super sendAction:action];
}

- (void)sendActionsForControlEvents:(UIControlEvents)controlEvents
{
    [super sendActionsForControlEvents:controlEvents];
    
//    [UIView animateWithDuration:0.5
//                          delay:1.0
//         usingSpringWithDamping:1.0
//          initialSpringVelocity:0.2
//                        options:UIViewAnimationOptionCurveEaseOut animations:^{
//            self.transform = CGAffineTransformMakeScale(0.6, 0.6);
//    } completion:nil];
}

@end
