//
//  FutureListViewController.m
//  EugineAPISample
//
//  Created by aaab on 2023/02/04.
//

#import "FutureListViewController.h"

#import "SmartChampAPI.h"
#import "IStructItemCode.h"
#import "SmartChampDefs.h"
#import "ComboBox.h"

#define DEFINE_CODE @"code"
#define DEFINE_NAME @"name"

#define CALL_TAG    1
#define PUT_TAG     2

@interface FutureListViewController () < UITableViewDelegate , UITableViewDataSource , IComboBox >
{
    NSMutableArray *arrayFutureCode;
    NSMutableArray *arrayCallOptionCode;
    NSMutableArray *arrayPutOptionCode;
    
    ComboBox       *futureComboBox;
    UITableView     *callTableView;
    UITableView     *putTableView;
    
}
@end

@implementation FutureListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self.view setBackgroundColor:[UIColor whiteColor]];
    arrayCallOptionCode = [NSMutableArray array];
    arrayPutOptionCode = [NSMutableArray array];
        
    
    arrayFutureCode = [NSMutableArray arrayWithArray:[[SmartChampAPI instance] getFuturesCodeList]];
    
    NSArray *temp = [[SmartChampAPI instance] getArrayCode:K_DIC_OPTION];
    for (NSString *sCode in temp) {
        NSString *sItemName = [[SmartChampAPI instance] getItemCodeInfo:sCode type:@"name"];
        NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:sItemName, DEFINE_NAME , sCode , DEFINE_CODE , nil];
        // 콜
        if ([[sCode substringToIndex:1] isEqualToString:@"2"]){
            [arrayCallOptionCode addObject:dic];
        }else if ([[sCode substringToIndex:1] isEqualToString:@"3"]){ // 풋
            [arrayPutOptionCode addObject:dic];
        }
    }
    
    
    CGFloat xPaddiing = 20;
    CGFloat yPos = 40;
    CGFloat comboHeight = 40;
    CGFloat selfWidth = CGRectGetWidth(self.view.frame);
    CGFloat selfHeight = CGRectGetHeight(self.view.frame);
    
    NSMutableArray *arrayKeys = [NSMutableArray array];
    NSMutableArray *arrayTitle = [NSMutableArray array];
    
    for ( id <IStructItemCode> item in arrayFutureCode ){
        [arrayKeys addObject:[item getCode]];
        [arrayTitle addObject:[item getName]];
    }
    
    futureComboBox = [[ComboBox alloc] initWithFrame:CGRectMake(xPaddiing, yPos, selfWidth - xPaddiing * 2,  comboHeight)];
    [futureComboBox setComboDelegate:self];
    [futureComboBox setKeys:arrayKeys title:arrayTitle];
    [self.view addSubview:futureComboBox];
    
    yPos = CGRectGetMaxY(futureComboBox.frame) + xPaddiing;
    callTableView = [[UITableView alloc] initWithFrame:CGRectMake(0, yPos, CGRectGetWidth(futureComboBox.frame) / 2, selfHeight - yPos - xPaddiing) style:UITableViewStylePlain];
    [callTableView setDelegate:self];
    [callTableView setDataSource:self];
    [callTableView setTag:CALL_TAG];
    [callTableView setRowHeight:45];
    [self.view addSubview:callTableView];
    
    NSInteger nMiddle = [arrayCallOptionCode count] / 2;
    [self performSelector:@selector(callTableScroll:) withObject:[NSNumber numberWithInteger:nMiddle] afterDelay:0.1];
    
    putTableView = [[UITableView alloc] initWithFrame:CGRectMake(CGRectGetMaxX(callTableView.frame), yPos, CGRectGetWidth(futureComboBox.frame) / 2, selfHeight - yPos - xPaddiing) style:UITableViewStylePlain];
    [putTableView setDelegate:self];
    [putTableView setRowHeight:45];
    [putTableView setDataSource:self];
    [putTableView setTag:PUT_TAG];
    [self.view addSubview:putTableView];
    
    nMiddle = [arrayPutOptionCode count] / 2;
    [self performSelector:@selector(putTableScroll:) withObject:[NSNumber numberWithInteger:nMiddle] afterDelay:0.1];
    // Do any additional setup after loading the view.
    
    [self makeCloseButton];
}


- (void)makeCloseButton
{
    
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    [button setFrame:CGRectMake(CGRectGetWidth(self.view.frame) - 50 , 15, 35, 35)];
    [button addTarget:self action:@selector(onCloseButton:) forControlEvents:UIControlEventTouchUpInside];
    UIImage *image = [UIImage imageNamed:@"ic_floating_close_48.png"];
    [button setImage:image forState:UIControlStateNormal];
    [button setImage:image forState:UIControlStateHighlighted];
    [self.view addSubview:button];
}

- (void)onCloseButton:(UIButton*)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (void)callTableScroll:(NSNumber*)row
{
    [callTableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:[row integerValue] inSection:0]
                         atScrollPosition:UITableViewScrollPositionMiddle
                                 animated:NO];
}
- (void)putTableScroll:(NSNumber*)row
{
    [putTableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:[row integerValue] inSection:0]
                        atScrollPosition:UITableViewScrollPositionMiddle
                                animated:NO];
}
#pragma mark - IComboBox Delegate Method
- (void)selectComboBox:(ComboBox*)box selectKey:(NSString*)key
{
    NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:[box getSelectkey], @"code" , [box getSelectName] , @"name" , nil];
    
    [[NSNotificationCenter defaultCenter] postNotificationName:@"notiSearchFutureItem" object:dic];
    
    [self dismissViewControllerAnimated:YES completion:^{
        
    }];
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;
{
    if ([tableView tag] == CALL_TAG){
        return [arrayCallOptionCode count];
    }else if ([tableView tag] == PUT_TAG){
        return [arrayPutOptionCode count];
    }
    return 0;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if ([tableView tag] == CALL_TAG){
        static NSString *CellIdentifier = @"Cell";
        
        UILabel *codelabel = nil;
        UILabel *namelabel = nil;
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        if (cell == nil) {
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier];

            codelabel = [[UILabel alloc] initWithFrame:CGRectMake(20, 0, CGRectGetWidth(tableView.frame), tableView.rowHeight / 2)];
            [codelabel setTag:1];
            [cell.contentView addSubview:codelabel];
            [codelabel setFont:[UIFont fontWithName:@"HelveticaNeue-Bold" size:18]];
            
            namelabel = [[UILabel alloc] initWithFrame:CGRectMake(20, tableView.rowHeight / 2, CGRectGetWidth(tableView.frame), tableView.rowHeight / 2)];
            [namelabel setTag:2];
            [namelabel setTextColor:[UIColor grayColor]];
            [cell.contentView addSubview:namelabel];
            [namelabel setFont:[UIFont fontWithName:@"HelveticaNeue-Medium" size:16]];
        }
        
        if (codelabel == nil){
            codelabel = [cell.contentView viewWithTag:1];
        }
        
        if (namelabel == nil){
            namelabel = [cell.contentView viewWithTag:2];
        }
        
        NSDictionary *dicitem = [arrayCallOptionCode objectAtIndex:indexPath.row];
        
        [codelabel setText:dicitem[DEFINE_CODE]];
        [namelabel setText:dicitem[DEFINE_NAME]];
        
        return cell;
    }else if ([tableView tag] == PUT_TAG){
        static NSString *CellIdentifier = @"Cell";
        
        UILabel *codelabel = nil;
        UILabel *namelabel = nil;
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        if (cell == nil) {
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier];

            codelabel = [[UILabel alloc] initWithFrame:CGRectMake(20, 0, CGRectGetWidth(tableView.frame), tableView.rowHeight / 2)];
            [codelabel setTag:1];
            [cell.contentView addSubview:codelabel];
            [codelabel setFont:[UIFont fontWithName:@"HelveticaNeue-Bold" size:18]];
            
            namelabel = [[UILabel alloc] initWithFrame:CGRectMake(20, tableView.rowHeight / 2, CGRectGetWidth(tableView.frame), tableView.rowHeight / 2)];
            [namelabel setTag:2];
            [namelabel setTextColor:[UIColor grayColor]];
            [cell.contentView addSubview:namelabel];
            [namelabel setFont:[UIFont fontWithName:@"HelveticaNeue-Medium" size:16]];
        }
        
        if (codelabel == nil){
            codelabel = [cell.contentView viewWithTag:1];
        }
        
        if (namelabel == nil){
            namelabel = [cell.contentView viewWithTag:2];
        }
        
        NSDictionary *dicitem = [arrayPutOptionCode objectAtIndex:indexPath.row];
        
        [codelabel setText:dicitem[DEFINE_CODE]];
        [namelabel setText:dicitem[DEFINE_NAME]];
        
        return cell;
    }
    
    return nil;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSDictionary *dic = nil;
    if ([tableView tag] == CALL_TAG){
        dic = arrayCallOptionCode[indexPath.row];
    }else if ([tableView tag] == PUT_TAG){
        dic = arrayPutOptionCode[indexPath.row];
    }
    
    if (dic != nil){
        [[NSNotificationCenter defaultCenter] postNotificationName:@"notiSearchFutureItem" object:dic];
        
        [self dismissViewControllerAnimated:YES completion:^{
            
        }];
    }
}

@end
