//
//  FuturePriceViewController.m
//  EugineAPISample
//
//  Created by aaab on 2023/02/04.
//

#import "FuturePriceViewController.h"
#import "ComUtil.h"
#import "HogaControlView.h"
#import "IStructItemCode.h"
#import "SmartChampTran.h"
#import "ITranDataDelegate.h"
#import "IRealDataDelegate.h"
#import "SmartChampAPI.h"
#import "SmartChampReal.h"
#import "HogaItem.h"
#import "Util.h"
#import "iToast.h"
#import "ComboBox.h"
//#import "NFilterNum.h"
//#import "EccEncryptor.h"
#import "BottomTableView.h"
#import "FutureListViewController.h"
#import "UITextField+Addition.h"

#define FUTURE_ITEM_CODE @"FUTURE_ITEM_CODE"

@interface FuturePriceViewController () <ITranDataDelegate , IRealDataDelegate , IComboBox , UITextFieldDelegate , IBottomTableDelegate , IHogaControlDelegate>
{
    UIScrollView *backScollView;
    
    UIView *topItemView;
    UITextField *textitemLabel;
    UILabel *itemLabel;
    NSString *sItemCode;
    
    UIView *curpriceView;
    UILabel *itemCurrentPrice;
    UIImageView *signImageView;
    UILabel *changePriceLabel;
    UILabel *rateLabel;
    UILabel *volumnLabel;
    UIScrollView *scrollView;
    
    UIButton *buyButton;
    UIButton *sellButton;
    UIButton *cancelButton;
    
    UIButton *allPartButton;
    
    UIView  *buyOrderView;
    UIView  *sellOrderView;
    UIView  *cancelOrderVew;
    CGFloat fLstCPrice;
    NSString      *sCurrentPrice;
    HogaControlView *hogaView;
    
    // 데이터 처리
    SmartChampTran *m_tranFuturesPrice;                // 지수선물 현재가 조회
    SmartChampTran *m_tranOptionsPrice;                // 지수옵션 현재가 조회

    SmartChampReal *m_realFuturesPrice;            // 지수선물 체결 실시간
    SmartChampReal *m_realFuturesHoga;                // 지수선물 호가 실시간
    SmartChampReal *m_realOptionsPrice;            // 지수옵션 체결 실시간
    SmartChampReal *m_realOptionsHoga;             // 지수옵션 호가 실시간

    SmartChampTran *m_tranFutOptBuy;                // 매수 주문
    SmartChampTran *m_tranFutOptSell;                // 매도 주문
    SmartChampTran *m_tranFutOptModify;            // 정정 주문
    SmartChampTran *m_tranFutOptCancel;            // 취소 주문

    SmartChampTran *m_tranJango;                 // 잔고조회
    SmartChampTran *m_tranChegyul;               // 체결/미체결내역
    
    
    ComboBox    *accountComboBox;
    UITextField *accountPWD;
    NSString    *sEncryptAccPwd;
//    NFilterNum *keyboardController;
    
    NSNumberFormatter *formatter;
}
@end

@implementation FuturePriceViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    fLstCPrice = 1;
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(notiSearchFutureItem:) name:@"notiSearchFutureItem" object:nil];
    
    formatter = [[NSNumberFormatter alloc] init];
    [formatter setMaximumFractionDigits:2];
    [formatter setMinimumFractionDigits:2];
    [formatter setRoundingMode: NSNumberFormatterRoundHalfUp];
    
    [self initTran];
    [self makePriceView];
    [self makeAccountView];
    [self makeBuyOrderView];
    [self makeSellOrderView];
    [self makeCancelOrderView];
    
    [self makeButtons];
    [self makeCloseButton];
    NSString *futurecode = [ComUtil getString:FUTURE_ITEM_CODE basic:@""];
    if (futurecode != nil && [futurecode length] > 0){
        sItemCode = futurecode;
        [textitemLabel setText:sItemCode];
        NSString *sName = [[SmartChampAPI instance] getItemCodeInfo:sItemCode type:@"name"];
        [itemLabel setText:sName];
        
//        for (NSInteger i = 0; i < 100; i++) {
            [self requestCurrPrice];
//        }
    }
    
}

- (void)makeCloseButton
{
    
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    [button setFrame:CGRectMake(CGRectGetWidth(self.view.frame) - 50 , 15, 35, 35)];
    [button addTarget:self action:@selector(onCloseButton:) forControlEvents:UIControlEventTouchUpInside];
    UIImage *image = [UIImage imageNamed:@"ic_floating_close_48.png"];
    [button setImage:image forState:UIControlStateNormal];
    [button setImage:image forState:UIControlStateHighlighted];
    
    [self.view addSubview:button];
}

- (void)onCloseButton:(UIButton*)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}


- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:@"notiSearchFutureItem" object:nil];
}


- (void)makeButtons
{
    CGFloat selfWidth = CGRectGetWidth(self.view.frame);
    CGFloat fHeight = 30;
    CGFloat fPadding = 20;
    
    UIButton *jango = [UIButton buttonWithType:UIButtonTypeCustom];
    [jango setFrame:CGRectMake(selfWidth - 60 - 70 - fPadding, CGRectGetMaxY(cancelButton.frame) + 5, 60, fHeight)];
    [jango setBackgroundColor:[UIColor systemBlueColor]];
    [ComUtil setTitleInButton:jango title:@"잔고"];
    [ComUtil setColorInButton:jango color:[UIColor whiteColor]];
    [jango addTarget:self action:@selector(onJangoButton:) forControlEvents:UIControlEventTouchUpInside];
    [backScollView addSubview:jango];
    
    UIButton *jango1 = [UIButton buttonWithType:UIButtonTypeCustom];
    [jango1 setFrame:CGRectMake(selfWidth - 60 - fPadding, CGRectGetMaxY(cancelButton.frame) + 5, 60, fHeight)];
    [jango1 setBackgroundColor:[UIColor systemBlueColor]];
    [ComUtil setTitleInButton:jango1 title:@"미체결"];
    [ComUtil setColorInButton:jango1 color:[UIColor whiteColor]];
    [jango1 addTarget:self action:@selector(onChegyulButton:) forControlEvents:UIControlEventTouchUpInside];
    [backScollView addSubview:jango1];
}


- (void)initTran
{
    // 시세 TR 초기화
    m_tranFuturesPrice = [[SmartChampTran alloc] initWithTrCode:@"ffcur" delegate:self];
    [m_tranFuturesPrice setTranID:@"지수선물현재가"];

    m_tranOptionsPrice = [[SmartChampTran alloc] initWithTrCode:@"ogibon" delegate:self];
    [m_tranOptionsPrice setTranID:@"지수옵션현재가"];

    // 주문 TR 초기화
    m_tranFutOptBuy = [[SmartChampTran alloc] initWithTrCode:@"OFU1101U" delegate:self];
    [m_tranFutOptBuy setTranID:@"선옵매수주문"];

    m_tranFutOptSell = [[SmartChampTran alloc] initWithTrCode:@"OFU1101U" delegate:self];
    [m_tranFutOptSell setTranID:@"선옵매도주문"];

    m_tranFutOptModify = [[SmartChampTran alloc] initWithTrCode:@"OFU1102U" delegate:self];
    [m_tranFutOptModify setTranID:@"선옵정정주문"];

    m_tranFutOptCancel = [[SmartChampTran alloc] initWithTrCode:@"OFU1102U" delegate:self];
    [m_tranFutOptCancel setTranID:@"선옵취소주문"];

    m_tranJango = [[SmartChampTran alloc] initWithTrCode:@"OFU4793Q" delegate:self];
    [m_tranJango setTranID:@"선옵잔고조회"];

    m_tranChegyul = [[SmartChampTran alloc] initWithTrCode:@"OFU4772Q" delegate:self];
    [m_tranChegyul setTranID:@"선옵체결내역"];

    // 실시간 초기화
    m_realFuturesPrice = [[SmartChampReal alloc] initWithTrCode:@"F00" delegate:self];
    [m_realFuturesPrice setRealID:@"선물체결실시간"];

    m_realFuturesHoga = [[SmartChampReal alloc] initWithTrCode:@"F01" delegate:self];
    [m_realFuturesHoga setRealID:@"선물호가실시간"];

    m_realOptionsPrice = [[SmartChampReal alloc] initWithTrCode:@"O00" delegate:self];
    [m_realOptionsPrice setRealID:@"옵션체결실시간"];

    m_realOptionsHoga = [[SmartChampReal alloc] initWithTrCode:@"O01" delegate:self];
    [m_realOptionsHoga setRealID:@"옵션호가실시간"];
}

- (void)makePriceView
{
    [self.view setBackgroundColor:[UIColor whiteColor]];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(notiSearchFutureItem:) name:@"notiFutureStockItem" object:nil];
    // Do any additional setup after loading the view.
    topItemView = [[UIView alloc] initWithFrame:CGRectMake(0, 34, CGRectGetWidth(self.view.frame), 40)];
    
    [self.view addSubview:topItemView];
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [backBtn setFrame:CGRectMake(0, 0, 40, 40)];
    [backBtn addTarget:self action:@selector(onBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIImage *imageNormal = [UIImage imageNamed:@"btn_top_back_n.png"];
    UIImage *imageHigh = [UIImage imageNamed:@"btn_top_back_o.png"];
    UIImage *imageDisable = [UIImage imageNamed:@"btn_top_back_d.png"];
    [backBtn setImage:imageNormal forState:UIControlStateNormal];
    [backBtn setImage:imageHigh forState:UIControlStateHighlighted];
    [backBtn setImage:imageDisable forState:UIControlStateDisabled];
    
    [topItemView addSubview:backBtn];
    
    textitemLabel = [[UITextField alloc] initWithFrame:CGRectMake(CGRectGetMaxX(backBtn.frame) + 20, CGRectGetMinY(backBtn.frame), 80, CGRectGetHeight(backBtn.frame))];
    [textitemLabel setFont:[UIFont fontWithName:@"HelveticaNeue-Bold" size:12]];
    [textitemLabel setTextAlignment:NSTextAlignmentCenter];
    [textitemLabel setDelegate:self];
    [textitemLabel addNumericAccessory:NO];
    [topItemView addSubview:textitemLabel];
    
    UIView *lineView = [[UIView alloc] initWithFrame:CGRectMake(0, CGRectGetHeight(textitemLabel.frame) - 1, CGRectGetWidth(textitemLabel.frame), 1)];
    [lineView setBackgroundColor:[UIColor blackColor]];
    [textitemLabel addSubview:lineView];
    
    itemLabel = [[UILabel alloc] initWithFrame:CGRectMake(CGRectGetMaxX(textitemLabel.frame), CGRectGetMinY(backBtn.frame), CGRectGetWidth(self.view.frame) - CGRectGetMaxX(textitemLabel.frame) - CGRectGetHeight(backBtn.frame)- CGRectGetHeight(backBtn.frame), CGRectGetHeight(backBtn.frame))];
    [itemLabel setFont:[UIFont fontWithName:@"HelveticaNeue-Bold" size:12]];
    [itemLabel setLineBreakMode:NSLineBreakByCharWrapping];
    [topItemView addSubview:itemLabel];
    
    UIButton *searchBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [searchBtn setFrame:CGRectMake(CGRectGetMaxX(itemLabel.frame), CGRectGetMinY(itemLabel.frame), CGRectGetHeight(backBtn.frame), CGRectGetHeight(backBtn.frame))];
    
    UIImage *imageNormal2 = [UIImage imageNamed:@"icon_search.png"];
    [searchBtn setImage:imageNormal2 forState:UIControlStateNormal];
    [searchBtn setImage:imageNormal2 forState:UIControlStateHighlighted];
    [searchBtn setImage:imageNormal2 forState:UIControlStateDisabled];
    [searchBtn setImageEdgeInsets:UIEdgeInsetsMake(10, 10, 10, 10)];
    [searchBtn addTarget:self action:@selector(onSearchBtn:) forControlEvents:UIControlEventTouchUpInside];
    
    [topItemView addSubview:searchBtn];
    
    
    
    curpriceView = [[UIView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(topItemView.frame), CGRectGetWidth(topItemView.frame), 80)];
    [curpriceView setBackgroundColor:[[UIColor grayColor] colorWithAlphaComponent:0.2]];
    itemCurrentPrice = [[UILabel alloc] initWithFrame:CGRectMake(20, 0, CGRectGetWidth(self.view.frame) / 3 - 20 , CGRectGetHeight(curpriceView.frame))];
    [itemCurrentPrice setFont:[UIFont fontWithName:@"HelveticaNeue-Bold" size:28]];
    [itemCurrentPrice setTextAlignment:NSTextAlignmentRight];
    [curpriceView addSubview:itemCurrentPrice];
    CGSize size = CGSizeMake(20, 20);
    CGFloat yPos = (CGRectGetHeight(curpriceView.frame) - size.height) / 2;
    signImageView = [[UIImageView alloc] initWithFrame:CGRectMake(CGRectGetMaxX(itemCurrentPrice.frame) + 20, yPos, size.width, size.height)];
    [curpriceView addSubview:signImageView];
    
    changePriceLabel = [[UILabel alloc] initWithFrame:CGRectMake(CGRectGetMaxX(signImageView.frame), 0, CGRectGetWidth(curpriceView.frame) * 0.3 - 10 , CGRectGetHeight(curpriceView.frame) / 2)];
    [changePriceLabel setFont:[UIFont fontWithName:@"HelveticaNeue-Light" size:18]];
    [changePriceLabel setTextAlignment:NSTextAlignmentRight];
    [curpriceView addSubview:changePriceLabel];
    
    
    rateLabel = [[UILabel alloc] initWithFrame:CGRectMake(    CGRectGetMaxX(changePriceLabel.frame), 0, CGRectGetWidth(changePriceLabel.frame) - 10, CGRectGetHeight(changePriceLabel.frame))];
    [rateLabel setFont:[UIFont fontWithName:@"HelveticaNeue-Light" size:18]];
    [rateLabel setTextAlignment:NSTextAlignmentRight];
    
    [curpriceView addSubview:rateLabel];
    volumnLabel = [[UILabel alloc] initWithFrame:CGRectMake(CGRectGetMinX(changePriceLabel.frame), CGRectGetMaxY(rateLabel.frame), CGRectGetWidth(curpriceView.frame) - CGRectGetMinX(changePriceLabel.frame) - 10 , CGRectGetHeight(changePriceLabel.frame))];
    
    [volumnLabel setTextAlignment:NSTextAlignmentRight];
    [curpriceView addSubview:volumnLabel];
    [self.view addSubview:curpriceView];
    
    hogaView = [[HogaControlView alloc] initWithFrame:CGRectMake(0, 0, CGRectGetWidth(self.view.frame), CGRectGetHeight(self.view.frame) * 0.5 ) rowHeight:30 type:HOGA_TYPE_STOCK];
    [hogaView setHogaControlDelegate:self];
    backScollView = [[UIScrollView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(curpriceView.frame), CGRectGetWidth(self.view.frame), CGRectGetHeight(self.view.frame) - CGRectGetMaxY(topItemView.frame))];
    [backScollView setBounces:NO];
    [self.view addSubview:backScollView];
    [backScollView addSubview:hogaView];
}

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField
{
//    if (textField == accountPWD){
//        [self makeEncEdit];
//        return NO;
//    }
    
    return YES;
}

- (void)textFieldDidEndEditing:(UITextField *)textField
{
    if (textField == textitemLabel){
        NSString *sName = [[SmartChampAPI instance] getItemCodeInfo:textField.text type:@"name"];
        sItemCode = textField.text;
        [itemLabel setText:sName];
        
        [self requestCurrPrice];
    }
}


- (void)makeEncEdit
{
//    keyboardController = [[NFilterNum alloc] initWithNibName:@"NFilterNum" bundle:nil];// 일반넘패드
//    [keyboardController setServerPublickey:[[SmartChampAPI instance] getSecKeyPublicKey]];
//
//
//    [keyboardController setCallbackMethod:self
//                   methodOnConfirm:@selector(onConfirmNFilter:encText:dummyText:tagName:)
//                      methodOnPrev:@selector(onPrevNFilter:encText:dummyText:tagName:)
//                      methodOnNext:@selector(onNextNFilter:encText:dummyText:tagName:)
//                     methodOnPress:@selector(onPressNFilter:encText:dummyText:tagName:)
//                 methodOnReArrange:@selector(onReArrangeNFilter)
//     ];
//    [keyboardController setCallbackMethod:self methodOnConfirm:@selector(onConfirmNFilter:encText:dummyText:tagName:) methodOnCancel:@selector(onCancelNFilter:encText:dummyText:tagName:)];
//
//    [keyboardController setFullMode:YES];
//    [keyboardController setTopBarText:@"유진투자증권"];
//
//    [keyboardController setLengthWithTagName:nil length:8];// NFilter Library
//    [keyboardController setTitleText:@"계좌 비밀번호 입력"];
//    [keyboardController setFullMode:YES];
//    [keyboardController setNoSound:YES];
//    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7) {
//        [keyboardController setVerticalFrame:0];
//    } else {
//        [keyboardController setVerticalFrame:60];
//    }
//
//    [keyboardController showKeypad:[UIApplication sharedApplication].statusBarOrientation parentViewController:self];

}

- (void)makeAccountView
{
    CGFloat fPadding = 20;
    CGFloat fHeight = 40;
    CGFloat fWidth = CGRectGetWidth(self.view.frame) / 5 * 3;
    
    if (accountComboBox == nil){
        accountComboBox = [[ComboBox alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(hogaView.frame) + fPadding, fWidth, fHeight)];
        [accountComboBox setComboDelegate:self];
        [accountComboBox setPlaceHolder:@"계좌번호"];
    }
    
    NSInteger nAccountSize = [[SmartChampAPI instance] getAccountSize];
    
    NSMutableArray *arrayAccountNo = [NSMutableArray array];
    NSMutableArray *arrayAccountName = [NSMutableArray array];
    for (NSInteger i = 0; i < nAccountSize; i++) {
        NSString *sAccountNO = [[SmartChampAPI instance] getAccountNo:i];
        NSString *sAccountName = [[SmartChampAPI instance] getAccountName:i];
        
        [arrayAccountNo addObject:sAccountNO];
        [arrayAccountName addObject:[NSString stringWithFormat:@"%@(%@)" , sAccountNO , sAccountName]];
    }
    [accountComboBox setKeys:arrayAccountNo title:arrayAccountName];
    [backScollView addSubview:accountComboBox];
    
    accountPWD = [[UITextField alloc] initWithFrame:CGRectMake(CGRectGetMaxX(accountComboBox.frame) + 10, CGRectGetMinY(accountComboBox.frame), CGRectGetWidth(self.view.frame) - CGRectGetMaxX(accountComboBox.frame) - 30, CGRectGetHeight(accountComboBox.frame))];
    [accountPWD setTextAlignment:NSTextAlignmentCenter];
    [accountPWD setDelegate:self];
    [accountPWD setSecureTextEntry:YES];
    [accountPWD setKeyboardType:UIKeyboardTypeNumberPad];
    [accountPWD addNumericAccessory:NO];
    [ComUtil makeRoundView:accountPWD radius:4 width:1 bordercolor:[UIColor lightGrayColor]];
    [backScollView addSubview:accountPWD];
    
    buyButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [ComUtil setColorInButton:buyButton color:[UIColor whiteColor]];
    [buyButton setBackgroundColor:[Util getRedColor]];
    [ComUtil setTitleInButton:buyButton title:@"매수"];
    [buyButton setTag:0];
    [buyButton addTarget:self action:@selector(onTabOrderButton:) forControlEvents:UIControlEventTouchUpInside];
    [buyButton setTitleColor:[UIColor lightGrayColor] forState:UIControlStateNormal];
    CGFloat width = CGRectGetWidth(self.view.frame) / 3;
    [buyButton setFrame:CGRectMake(0, CGRectGetMaxY(accountComboBox.frame) + 10, width, 40)];
    [backScollView addSubview:buyButton];
    [buyButton setSelected:YES];
    
    sellButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [sellButton setTag:1];
    [sellButton addTarget:self action:@selector(onTabOrderButton:) forControlEvents:UIControlEventTouchUpInside];
    [ComUtil setColorInButton:sellButton color:[UIColor whiteColor]];
    [sellButton setBackgroundColor:[Util getBlueColor]];
    [ComUtil setTitleInButton:sellButton title:@"매도"];
    [sellButton setTitleColor:[UIColor lightGrayColor] forState:UIControlStateNormal];
    [sellButton setFrame:CGRectMake(CGRectGetMaxX(buyButton.frame), CGRectGetMinY(buyButton.frame), width, CGRectGetHeight(buyButton.frame))];
    [backScollView addSubview:sellButton];
    
    cancelButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [cancelButton setTag:2];
    [cancelButton addTarget:self action:@selector(onTabOrderButton:) forControlEvents:UIControlEventTouchUpInside];
    [ComUtil setColorInButton:cancelButton color:[UIColor whiteColor]];
    [cancelButton setBackgroundColor:[Util getCollectColor]];
    [ComUtil setTitleInButton:cancelButton title:@"정정/취소"];
    [cancelButton setTitleColor:[UIColor lightGrayColor] forState:UIControlStateNormal];
    [cancelButton setFrame:CGRectMake(CGRectGetMaxX(sellButton.frame), CGRectGetMinY(buyButton.frame), width, CGRectGetHeight(buyButton.frame))];
    [backScollView addSubview:cancelButton];
}

- (void)onTabOrderButton:(UIButton*)sender
{
    if (sender.tag == 0){
        [buyButton setSelected:YES];
        [sellButton setSelected:NO];
        [cancelButton setSelected:NO];
        [buyOrderView setHidden:NO];
        [sellOrderView setHidden:YES];
        [cancelOrderVew setHidden:YES];
    }else if (sender.tag == 1){
        [buyButton setSelected:NO];
        [sellButton setSelected:YES];
        [cancelButton setSelected:NO];
        [buyOrderView setHidden:YES];
        [sellOrderView setHidden:NO];
        [cancelOrderVew setHidden:YES];
    }else if (sender.tag == 2){
        [buyButton setSelected:NO];
        [sellButton setSelected:NO];
        [cancelButton setSelected:YES];
        [buyOrderView setHidden:YES];
        [sellOrderView setHidden:YES];
        [cancelOrderVew setHidden:NO];
    }
}

- (void)makeBuyOrderView
{
    CGFloat fPadding = 20;
    CGFloat fHeight = 40;
    CGFloat selfWidth = CGRectGetWidth(self.view.frame);
    CGFloat fWidth = CGRectGetWidth(self.view.frame) - fPadding * 2;

    buyOrderView = [[UIView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(buyButton.frame), selfWidth, 650)];
    [backScollView addSubview:buyOrderView];
    
    UILabel *labelText = [[UILabel alloc] initWithFrame:CGRectMake(fPadding, 0, 100, fHeight)];
    [labelText setText:@"현금"];
    [buyOrderView addSubview:labelText];
    
    ComboBox *box = [[ComboBox alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(labelText.frame), fWidth, fHeight)];
    // 주문매매구분코드 (010:지정가, 020:시장가, 030:조건부지정가, 040:최유리지정가, 050:최우선지정가)
    [box setKeys:[NSArray arrayWithObjects:@"010", @"020" , @"030" , @"040" , @"050" , nil] title:[NSArray arrayWithObjects:@"지정가", @"시장가" , @"조건부지정가" , @"최유리지정가" , @"최우선지정가" , nil]];
    [box setTag:4];
    [buyOrderView addSubview:box];
    
    ComboBox *box2 = [[ComboBox alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(box.frame) + 10, fWidth, fHeight)];
    // 주문조건구분코드 (0:없음, 1:IOC, 2:FOK)
    [box2 setKeys:[NSArray arrayWithObjects:@"0", @"1" , @"2", nil] title:[NSArray arrayWithObjects:@"없음", @"IOC" , @"FOK", nil]];
    [box2 setTag:5];
    [buyOrderView addSubview:box2];

    // 수량
    UITextField *qtyTextField = [[UITextField alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(box2.frame) + 10, fWidth, fHeight)];
    [ComUtil makeRoundView:qtyTextField radius:4 width:1 bordercolor:[UIColor lightGrayColor]];
    [qtyTextField setTextAlignment:NSTextAlignmentCenter];
    [qtyTextField setKeyboardType:UIKeyboardTypeNumberPad];
    [qtyTextField setPlaceholder:@"수량"];
    [qtyTextField setTag:1];
    [qtyTextField addNumericAccessory:NO];
    [buyOrderView addSubview:qtyTextField];
    
    UITextField *priceTextField = [[UITextField alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(qtyTextField.frame) + 10, fWidth, fHeight)];
    [priceTextField setTextAlignment:NSTextAlignmentCenter];
    [ComUtil makeRoundView:priceTextField radius:4 width:1 bordercolor:[UIColor lightGrayColor]];
    [priceTextField setKeyboardType:UIKeyboardTypeNumberPad];
    [priceTextField setTag:2];
    [priceTextField setPlaceholder:@"가격"];
    [priceTextField addNumericAccessory:YES];
    [buyOrderView addSubview:priceTextField];
    // 가격
    
    UIButton *buyOrderButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [buyOrderButton setBackgroundColor:[UIColor redColor]];
    [ComUtil setTitleInButton:buyOrderButton title:@"매수"];
    [ComUtil setColorInButton:buyOrderButton color:[UIColor whiteColor]];
    [buyOrderButton addTarget:self action:@selector(onTouchBuyButton:) forControlEvents:UIControlEventTouchUpInside];
    [buyOrderButton setFrame:CGRectMake(fPadding , CGRectGetMaxY(priceTextField.frame) + 20, fWidth * 0.5, fHeight * 1.5)];
    [buyOrderView addSubview:buyOrderButton];
    [ComUtil makeRoundView:buyOrderButton radius:4 width:1 bordercolor:[UIColor systemBlueColor]];
    
    UILabel *orderNoNumber = [[UILabel alloc] initWithFrame:CGRectMake(CGRectGetMaxX(buyOrderButton.frame), CGRectGetMinY(buyOrderButton.frame), CGRectGetWidth(self.view.frame) - CGRectGetMaxX(buyOrderButton.frame) - fPadding, CGRectGetHeight(buyOrderButton.frame))];
    [orderNoNumber setAlpha:0.7];
    [orderNoNumber setBackgroundColor:[UIColor systemRedColor]];
    [orderNoNumber setTextColor:[UIColor blackColor]];
    [orderNoNumber setTag:3];
    [buyOrderView addSubview:orderNoNumber];
    
    [backScollView addSubview:buyOrderView];
    [backScollView setContentSize:CGSizeMake(0, CGRectGetMaxY(buyOrderView.frame))];
}

- (void)makeSellOrderView
{
    CGFloat fPadding = 20;
    CGFloat fHeight = 40;
    CGFloat selfWidth = CGRectGetWidth(self.view.frame);
    CGFloat fWidth = CGRectGetWidth(self.view.frame) - fPadding * 2;

    sellOrderView = [[UIView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(buyButton.frame), selfWidth, 650)];
    [backScollView addSubview:sellOrderView];
    
    UILabel *labelText = [[UILabel alloc] initWithFrame:CGRectMake(fPadding, 0, 100, fHeight)];
    [labelText setText:@"현금"];
    [sellOrderView addSubview:labelText];
    
    ComboBox *box = [[ComboBox alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(labelText.frame), fWidth, fHeight)];
    // 주문매매구분코드 (010:지정가, 020:시장가, 030:조건부지정가, 040:최유리지정가, 050:최우선지정가)
    [box setKeys:[NSArray arrayWithObjects:@"010", @"020" , @"030" , @"040" , @"050" , nil] title:[NSArray arrayWithObjects:@"지정가", @"시장가" , @"조건부지정가" , @"최유리지정가" , @"최우선지정가" , nil]];
    [box setTag:4];
    [sellOrderView addSubview:box];
    
    ComboBox *box2 = [[ComboBox alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(box.frame) + 10, fWidth, fHeight)];
    // 주문조건구분코드 (0:없음, 1:IOC, 2:FOK)
    [box2 setKeys:[NSArray arrayWithObjects:@"0", @"1" , @"2", nil] title:[NSArray arrayWithObjects:@"없음", @"IOC" , @"FOK", nil]];
    [box2 setTag:5];
    [sellOrderView addSubview:box2];
    
    // 수량
    UITextField *qtyTextField = [[UITextField alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(box2.frame) + 10, fWidth, fHeight)];
    [ComUtil makeRoundView:qtyTextField radius:4 width:1 bordercolor:[UIColor lightGrayColor]];
    [qtyTextField setTextAlignment:NSTextAlignmentCenter];
    [qtyTextField setKeyboardType:UIKeyboardTypeNumberPad];
    [qtyTextField setPlaceholder:@"수량"];
    [qtyTextField setTag:1];
    [qtyTextField addNumericAccessory:NO];
    [sellOrderView addSubview:qtyTextField];
    
    UITextField *priceTextField = [[UITextField alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(qtyTextField.frame) + 10, fWidth, fHeight)];
    [ComUtil makeRoundView:priceTextField radius:4 width:1 bordercolor:[UIColor lightGrayColor]];
    [priceTextField setTextAlignment:NSTextAlignmentCenter];
    [priceTextField setKeyboardType:UIKeyboardTypeNumberPad];
    [priceTextField setTag:2];
    [priceTextField addNumericAccessory:YES];
    [priceTextField setPlaceholder:@"가격"];
    [sellOrderView addSubview:priceTextField];
    // 가격
    
    UIButton *sellOrderButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [sellOrderButton setBackgroundColor:[UIColor blueColor]];
    [ComUtil setTitleInButton:sellOrderButton title:@"매도"];
    [ComUtil setColorInButton:sellOrderButton color:[UIColor whiteColor]];
    [sellOrderButton addTarget:self action:@selector(onTouchSellButton:) forControlEvents:UIControlEventTouchUpInside];
    [sellOrderButton setFrame:CGRectMake(fPadding , CGRectGetMaxY(priceTextField.frame) + 20 , fWidth * 0.5, fHeight * 1.5)];
    [sellOrderView addSubview:sellOrderButton];
    
    UILabel *orderNoNumber = [[UILabel alloc] initWithFrame:CGRectMake(CGRectGetMaxX(sellOrderButton.frame), CGRectGetMinY(sellOrderButton.frame), CGRectGetWidth(self.view.frame) - CGRectGetMaxX(sellOrderButton.frame) - fPadding, CGRectGetHeight(sellOrderButton.frame))];
    [orderNoNumber setAlpha:0.7];
    [orderNoNumber setBackgroundColor:[UIColor systemBlueColor]];
    [orderNoNumber setTextColor:[UIColor blackColor]];
    [orderNoNumber setTag:3];
    [sellOrderView addSubview:orderNoNumber];
    [sellOrderView setHidden:YES];
    
    [backScollView addSubview:sellOrderView];
    [backScollView setContentSize:CGSizeMake(0, CGRectGetMaxY(sellOrderView.frame))];
}

- (void)makeCancelOrderView
{
    CGFloat fPadding = 20;
    CGFloat fHeight = 40;
    CGFloat selfWidth = CGRectGetWidth(self.view.frame);
    CGFloat fWidth = CGRectGetWidth(self.view.frame) - fPadding * 2;

    cancelOrderVew = [[UIView alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(buyButton.frame), selfWidth, 650)];
    [backScollView addSubview:cancelOrderVew];
    
    UILabel *labelText = [[UILabel alloc] initWithFrame:CGRectMake(fPadding, 0, 100, fHeight)];
    [labelText setText:@"현금"];
    [cancelOrderVew addSubview:labelText];
    
    ComboBox *box = [[ComboBox alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(labelText.frame), fWidth, fHeight)];
    // 주문매매구분코드 (010:지정가, 020:시장가, 030:조건부지정가, 040:최유리지정가, 050:최우선지정가)
    [box setKeys:[NSArray arrayWithObjects:@"010", @"020" , @"030" , @"040" , @"050" , nil] title:[NSArray arrayWithObjects:@"지정가", @"시장가" , @"조건부지정가" , @"최유리지정가" , @"최우선지정가" , nil]];
    [box setTag:4];
    [cancelOrderVew addSubview:box];
    
    ComboBox *box2 = [[ComboBox alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(box.frame) + 10, fWidth, fHeight)];
    // 주문조건구분코드 (0:없음, 1:IOC, 2:FOK)
    [box2 setKeys:[NSArray arrayWithObjects:@"0", @"1" , @"2", nil] title:[NSArray arrayWithObjects:@"없음", @"IOC" , @"FOK", nil]];
    [box2 setTag:5];
    [cancelOrderVew addSubview:box2];
    
    allPartButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [allPartButton setFrame:CGRectMake(fPadding, CGRectGetMaxY(box2.frame) + 10, fWidth, fHeight)];
    [allPartButton addTarget:self action:@selector(onAllorPartButton:) forControlEvents:UIControlEventTouchUpInside];
    [ComUtil setTitleInButton:allPartButton title:@"일부"];
    [allPartButton.titleLabel setFont:[Util fontType:BOLD size:24]];
    [ComUtil setColorInButton:allPartButton color:[UIColor blackColor]];
    [ComUtil makeRoundView:allPartButton radius:1 width:1 bordercolor:[UIColor blackColor]];
    [allPartButton setTitle:@"전량" forState:UIControlStateSelected];
    [cancelOrderVew addSubview:allPartButton];
    
    
    // 수량
    UITextField *qtyTextField = [[UITextField alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(allPartButton.frame) + 10, fWidth, fHeight)];
    [ComUtil makeRoundView:qtyTextField radius:4 width:1 bordercolor:[UIColor lightGrayColor]];
    [qtyTextField setTextAlignment:NSTextAlignmentCenter];
    [qtyTextField setKeyboardType:UIKeyboardTypeNumberPad];
    [qtyTextField setPlaceholder:@"수량"];
    [qtyTextField setTag:1];
    [qtyTextField addNumericAccessory:NO];
    [cancelOrderVew addSubview:qtyTextField];
    
    UITextField *priceTextField = [[UITextField alloc] initWithFrame:CGRectMake(fPadding, CGRectGetMaxY(qtyTextField.frame) + 10, fWidth, fHeight)];
    [priceTextField setTextAlignment:NSTextAlignmentCenter];
    [ComUtil makeRoundView:priceTextField radius:4 width:1 bordercolor:[UIColor lightGrayColor]];
    [priceTextField setKeyboardType:UIKeyboardTypeNumberPad];
    [priceTextField setTag:2];
    [priceTextField addNumericAccessory:YES];
    [priceTextField setPlaceholder:@"가격"];
    [cancelOrderVew addSubview:priceTextField];
    
    UITextField *orderNoNumber = [[UITextField alloc] initWithFrame:CGRectMake(fPadding , CGRectGetMaxY(priceTextField.frame) + 10, fWidth , fHeight)];
    [orderNoNumber setTextAlignment:NSTextAlignmentCenter];
    [orderNoNumber setKeyboardType:UIKeyboardTypeNumberPad];
    [orderNoNumber addNumericAccessory:NO];
    [orderNoNumber setPlaceholder:@"주문번호"];
    [orderNoNumber setFont:[Util fontType:LIGHT size:13]];
    [orderNoNumber setTextColor:[UIColor blackColor]];
    [ComUtil makeRoundView:orderNoNumber radius:4 width:1 bordercolor:[UIColor lightGrayColor]];
    [orderNoNumber setTag:3];
    [cancelOrderVew addSubview:orderNoNumber];
    [cancelOrderVew setHidden:YES];
    // 가격
    
    UIButton *collectButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [collectButton setBackgroundColor:[UIColor systemGreenColor]];
    [ComUtil setTitleInButton:collectButton title:@"정정"];
    [ComUtil setColorInButton:collectButton color:[UIColor whiteColor]];
    [collectButton addTarget:self action:@selector(onCollectOrderButton:) forControlEvents:UIControlEventTouchUpInside];
    [collectButton setFrame:CGRectMake(fPadding , CGRectGetMaxY(orderNoNumber.frame) + 20, fWidth * 0.5, fHeight * 1.5)];
    [cancelOrderVew addSubview:collectButton];
    
    UIButton *cancelButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [cancelButton setBackgroundColor:[UIColor systemOrangeColor]];
    [ComUtil setTitleInButton:cancelButton title:@"취소"];
    [ComUtil setColorInButton:cancelButton color:[UIColor whiteColor]];
    [cancelButton addTarget:self action:@selector(onCancelOrderButton:) forControlEvents:UIControlEventTouchUpInside];
    [cancelButton setFrame:CGRectMake(CGRectGetMaxX(collectButton.frame) , CGRectGetMaxY(orderNoNumber.frame) + 20, fWidth * 0.5, fHeight * 1.5)];
    [cancelOrderVew addSubview:cancelButton];
    
    [cancelOrderVew addSubview:orderNoNumber];
    [cancelOrderVew setHidden:YES];
    
    [backScollView addSubview:cancelOrderVew];
    [backScollView setContentSize:CGSizeMake(0, CGRectGetMaxY(cancelOrderVew.frame))];
}

- (void)onAllorPartButton:(UIButton*)sender
{
    sender.selected = !sender.selected;
    UITextField *textField = [cancelOrderVew viewWithTag:1];
    if (sender.selected){
        [self setMicheclQty:@""];
        [textField setEnabled:NO];
    }else{
        [textField setEnabled:YES];
    }
}


- (void)onJangoButton:(UIButton*)sender
{
    [self requestJango];
}

- (void)onCollectOrderButton:(UIButton*)sender
{
    [self requestOrderModify];
}

- (void)onCancelOrderButton:(UIButton*)sender
{
    [self requestOrderCancel];
}

- (void)onChegyulButton:(UIButton*)sender
{
    [self requestChegyul];
}

- (void)onTouchSellButton:(UIButton*)sender
{
    [self requestOrderSell];
}

- (void)onTouchBuyButton:(UIButton*)sender
{
    [self requestOrderBuy];
}

- (void)setCollectOrderNo:(NSString*)orderNo
{
    UITextField *label = [cancelOrderVew viewWithTag:3];
    return [label setText:orderNo];
}

- (void)setPrice:(NSString*)price
{
    if (buyButton.selected){
        UITextField *label = [buyOrderView viewWithTag:2];
        return [label setText:price];
    }else if (sellButton.selected){
        UITextField *label = [sellOrderView viewWithTag:2];
        return [label setText:price];
    }else if (cancelButton.selected){
        UITextField *label = [cancelOrderVew viewWithTag:2];
        return [label setText:price];
    }
}


- (void)setMicheclQty:(NSString*)qty
{
    UITextField *textField = [cancelOrderVew viewWithTag:1];
    return [textField setText:qty];
}

- (void)setMichePrice:(NSString*)price
{
    UITextField *textField = [cancelOrderVew viewWithTag:2];
    return [textField setText:price];
}

- (void)setJangoQty:(NSString*)qty
{
    if (buyButton.selected){
        UITextField *textField = [buyOrderView viewWithTag:1];
        return [textField setText:qty];
    }else if (sellButton.selected){
        UITextField *textField = [sellOrderView viewWithTag:1];
        return [textField setText:qty];
    }
    
}

- (void)setOrderNo:(NSString*)orderNo
{
    if (buyButton.selected){
        UILabel *label = [buyOrderView viewWithTag:3];
        return [label setText:orderNo];
    }else if (sellButton.selected){
        UILabel *label = [sellOrderView viewWithTag:3];
        return [label setText:orderNo];
    }else if (cancelButton.selected){
        UITextField *label = [cancelOrderVew viewWithTag:3];
        return [label setText:orderNo];
    }
}

- (NSString*)getOrderType
{
    if (buyButton.selected){
        ComboBox *box = [buyOrderView viewWithTag:4];
        return [box getSelectkey];
    }else if (sellButton.selected){
        ComboBox *box = [sellOrderView viewWithTag:4];
        return [box getSelectkey];
    }else if (cancelButton.selected){
        ComboBox *box = [cancelOrderVew viewWithTag:4];
        return [box getSelectkey];
    }
    return @"";
}

- (NSString*)getOrderContition
{
    if (buyButton.selected){
        ComboBox *box = [buyOrderView viewWithTag:5];
        return [box getSelectkey];
    }else if (sellButton.selected){
        ComboBox *box = [sellOrderView viewWithTag:5];
        return [box getSelectkey];
    }else if (cancelButton.selected){
        ComboBox *box = [cancelOrderVew viewWithTag:5];
        return [box getSelectkey];
    }
    return @"";
}

- (NSString*)getQty
{
    if (buyButton.selected){
        UITextField *field = [buyOrderView viewWithTag:1];
        return field.text;
    }else if (sellButton.selected){
        UITextField *field = [sellOrderView viewWithTag:1];
        return field.text;
    }else if (cancelButton.selected){
        UITextField *field = [cancelOrderVew viewWithTag:1];
        return field.text;
    }
    return @"";
}

- (NSString*)getOrderNo
{
    UITextField *orderLabel = [cancelOrderVew viewWithTag:3];
    return orderLabel.text;
}

- (NSString*)getPrice
{
    if (buyButton.selected){
        UITextField *field = [buyOrderView viewWithTag:2];
        return field.text;
    }else if (sellButton.selected){
        UITextField *field = [sellOrderView viewWithTag:2];
        return field.text;
    }else if (cancelButton.selected){
        UITextField *field = [cancelOrderVew viewWithTag:2];
        return field.text;
    }
    return @"";
}


- (void)notiSearchFutureItem:(NSNotification*)noti
{
    NSDictionary *dicObjec = [noti object];
    
    sItemCode = dicObjec[@"code"];
    [textitemLabel setText:sItemCode];
    [itemLabel setText:dicObjec[@"name"]];
    
    [ComUtil setString:sItemCode key:FUTURE_ITEM_CODE];
    
    if (sItemCode != nil){
        [self requestCurrPrice];
    }
}

- (void)onBack:(UIButton*)btn
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (void)onSearchBtn:(UIButton*)btn
{
    FutureListViewController *stockList = [[FutureListViewController alloc] initWithNibName:nil bundle:nil];

    [self presentViewController:stockList animated:YES completion:^{

    }];
}


- (UIColor*)getColor:(CGFloat)targetPrice source:(CGFloat)sourcPrice
{
//    001:225045035
//    002:043123221
    if (targetPrice > sourcPrice){
        return [UIColor colorWithRed:225.0/255.0 green:045.0/255.0 blue:035.0/255.0 alpha:1.0f];
    }else if (targetPrice < sourcPrice){
        return [UIColor colorWithRed:43.0/255.0 green:123.0/255.0 blue:221.0/255.0 alpha:1.0f];
    }else{
        return [UIColor blackColor];
    }
}

- (NSString*)calcRate:(CGFloat)price{
    if (price == 0.0f) return @"";
    if (fLstCPrice == 0.0f) return @"0.00";
    
    CGFloat rate = ((price - fLstCPrice) / fLstCPrice) * 100;
    
    return [NSString stringWithFormat:@"%0.2f%%" , rate];
}

- (BOOL)isFutureCode
{
    NSString *strItemType = [[SmartChampAPI instance] getItemCodeInfo:sItemCode type:@"type"];

    // 현재 지정된 종목으로, 현재가/호가 조회 요청
    // 지수선물
    return [strItemType isEqualToString:@"J"] ? YES : NO;
}


- (void) requestCurrPrice
{
    // 조회 요청 전에, 실시간 요청을 먼저 클리어 한다
    if(m_realFuturesPrice != nil) [m_realFuturesPrice cancelRealData];
    if(m_realFuturesHoga != nil) [m_realFuturesHoga cancelRealData];
    if(m_realOptionsPrice != nil) [m_realOptionsPrice cancelRealData];
    if(m_realOptionsHoga != nil) [m_realOptionsHoga cancelRealData];
    NSString *sFullCode = [[SmartChampAPI instance] getItemFullCode:sItemCode];
    
    if([ComUtil isTextEmpty:sFullCode]) return;

    NSString *strItemType = [[SmartChampAPI instance] getItemCodeInfo:sItemCode type:@"type"];

    // 현재 지정된 종목으로, 현재가/호가 조회 요청
    // 지수선물
    if([strItemType isEqualToString:@"J"]) {
        if (m_tranFuturesPrice != nil) {
            [m_tranFuturesPrice clearInputData];
            [m_tranFuturesPrice clearOutputData];
            [m_tranFuturesPrice setDataValue:@"InRec1" fieldID:@"sCode" index:0 value:sFullCode];
            NSInteger nRQid = [m_tranFuturesPrice requestData];
            NSLog(@"send nRQid [%d]" ,  nRQid);
        }
    } else if([strItemType isEqualToString:@"L"]) {
        if (m_tranOptionsPrice != nil) {
            [m_tranOptionsPrice clearInputData];
            [m_tranOptionsPrice clearOutputData];
            [m_tranOptionsPrice setDataValue:@"InRec1" fieldID:@"sCode" index:0 value:sFullCode];
            [m_tranOptionsPrice requestData];;
        }
    }
}

- (void)processFutureCurPrice
{
    NSString *name = [m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:@"sHName" index:0];    // 종목이름

    NSString *price = [m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:@"lCPrice" index:0];  // 현재가
    int attrPrice = [m_tranFuturesPrice getDataAttr:@"OutRec1" fieldID:@"lCPrice" index:0];
    NSString *change = [m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:@"lDiff" index:0];    // 전일 대비
    char attrChange = [m_tranFuturesPrice getDataAttr:@"OutRec1" fieldID:@"lCPrice" index:0];
    NSString *signT = [m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:@"cPCheck" index:0];  // 대비 부호
    fLstCPrice = [[m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:@"lLstCPrice" index:0] floatValue];
    NSString *volumn = [m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:@"lVolume" index:0];  // 체결량
    NSLog(@"attrPrice [%d] attrChange [%d]" , attrPrice , attrChange);
    if ([name length] > 0)
        [itemLabel setText:name];
    [itemCurrentPrice setText:[Util getCurrencyFromString:price formatter:nil]];
    [itemCurrentPrice setTextColor:[Util getValueColor:attrPrice]];
    [changePriceLabel setText:[Util getCurrencyFromString:change formatter:nil]];
    [changePriceLabel setTextColor:[Util getValueColor:attrChange]];
    [signImageView setImage:[Util getValueSign:signT]];
    [volumnLabel setText:[Util getCurrencyFromString:volumn formatter:nil]];
    
    [rateLabel setText:[self calcRate:[price floatValue]]];
    [rateLabel setTextColor:[Util getValueColor:attrChange]];
    
    sCurrentPrice = price;
    NSLog(@"선물 호가 수신 : %@  현재가 [%@]" , sItemCode , sCurrentPrice );
    
//    fLstCPrice = [[m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:@"lLstCPrice" index:0] floatValue];
    NSMutableArray *arrayBuyItem = [NSMutableArray array];
    NSMutableArray *arraySellItem = [NSMutableArray array];
    // 호가 데이터
    // 5호가 데이터만 추출
    for(int nDataIndex = 0; nDataIndex < 5; nDataIndex++)
    {
        // 매도 호가
        NSString *strMaedoHoga = [m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:[NSString stringWithFormat:@"lOffer%d", nDataIndex + 1] index:0];
        NSString *strMaedoRemains = [m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:[NSString stringWithFormat:@"lOfferRest%d", nDataIndex + 1] index:0];
        // 매수 호가
        NSString *strMaesuHoga = [m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:[NSString stringWithFormat:@"lBid%d", nDataIndex + 1] index:0];
        NSString *strMaesuRemains = [m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:[NSString stringWithFormat:@"lBidRest%d", nDataIndex + 1] index:0];
        
        HogaItem *sellItem = [[HogaItem alloc] init];
        sellItem.price = [Util getCurrencyFromString:strMaedoHoga formatter:nil];
        sellItem.rate = [self calcRate:[strMaedoHoga floatValue]];
        sellItem.priceColor = [self getColor:[strMaedoHoga floatValue] source:fLstCPrice];
        sellItem.hogaBalance = [Util getCurrencyFromString:strMaedoRemains formatter:nil];
        sellItem.hogaBalanceColor = [UIColor systemGrayColor];
        
        HogaItem *buyItem = [[HogaItem alloc] init];
        buyItem.price = [Util getCurrencyFromString:strMaesuHoga formatter:nil];
        buyItem.priceColor = [self getColor:[strMaesuHoga floatValue] source:fLstCPrice];
        buyItem.rate = [self calcRate:[strMaesuHoga floatValue]];
        buyItem.hogaBalance = [Util getCurrencyFromString:strMaesuRemains formatter:nil];
        buyItem.hogaBalanceColor = [UIColor systemGrayColor];
        
        [arrayBuyItem addObject:buyItem];
        [arraySellItem addObject:sellItem];
    }
    [hogaView setBuyItem:arrayBuyItem];
    [hogaView setSellItem:arraySellItem];
    [hogaView invalidate];
}

- (void)processOptionCurPrice
{
    NSString *name = [m_tranOptionsPrice getDataValue:@"OutRec1" fieldID:@"sName" index:0];    // 종목이름
    NSString *price = [m_tranOptionsPrice getDataValue:@"OutRec1" fieldID:@"lCPrice" index:0];  // 현재가
    int attrPrice = [m_tranOptionsPrice getDataAttr:@"OutRec1" fieldID:@"lCPrice" index:0];
    NSString *change = [m_tranOptionsPrice getDataValue:@"OutRec1" fieldID:@"lDiff" index:0];    // 전일 대비
    char attrChange = [m_tranOptionsPrice getDataAttr:@"OutRec1" fieldID:@"lCPrice" index:0];
    NSString *signT = [m_tranOptionsPrice getDataValue:@"OutRec1" fieldID:@"cPCheck" index:0];  // 대비 부호
    fLstCPrice = ([[m_tranOptionsPrice getDataValue:@"OutRec1" fieldID:@"lLstCPrice" index:0] floatValue] / 100);
    NSString *volumn = [m_tranOptionsPrice getDataValue:@"OutRec1" fieldID:@"lVolume" index:0];  // 체결량
    NSLog(@"attrPrice [%d] attrChange [%d]" , attrPrice , attrChange);
    if ([name length] > 0)
        [itemLabel setText:name];
    
    price = [NSString stringWithFormat:@"%0.2f" , [price floatValue] / 100];
    change= [NSString stringWithFormat:@"%0.2f" , [change floatValue] / 100];
    
    [itemCurrentPrice setText:[Util getCurrencyFromString:price formatter:formatter]];
    [itemCurrentPrice setTextColor:[Util getValueColor:attrPrice]];
    [changePriceLabel setText:[Util getCurrencyFromString:change formatter:formatter]];
    [changePriceLabel setTextColor:[Util getValueColor:attrChange]];
    [signImageView setImage:[Util getValueSign:signT]];
    [volumnLabel setText:[Util getCurrencyFromString:volumn formatter:nil]];
    
    [rateLabel setText:[self calcRate:[price floatValue]]];
    [rateLabel setTextColor:[Util getValueColor:attrChange]];
    
    sCurrentPrice = price;
    NSLog(@"옵션 호가 수신 : %@  현재가 [%@]" , sItemCode , sCurrentPrice );
    
    NSMutableArray *arrayBuyItem = [NSMutableArray array];
    NSMutableArray *arraySellItem = [NSMutableArray array];
    // 호가 데이터
    // 5호가 데이터만 추출
    for(int nDataIndex = 0; nDataIndex < 10; nDataIndex++)
    {
        // 매도 호가
        NSString *strMaedoHoga = [m_tranOptionsPrice getDataValue:@"OutRec1" fieldID:[NSString stringWithFormat:@"lOffer%d", nDataIndex + 1] index:0];
        NSString *strMaedoRemains = [m_tranOptionsPrice getDataValue:@"OutRec1" fieldID:[NSString stringWithFormat:@"lOfferRest%d", nDataIndex + 1] index:0];
        // 매수 호가
        NSString *strMaesuHoga = [m_tranOptionsPrice getDataValue:@"OutRec1" fieldID:[NSString stringWithFormat:@"lBid%d", nDataIndex + 1] index:0];
        NSString *strMaesuRemains = [m_tranOptionsPrice getDataValue:@"OutRec1" fieldID:[NSString stringWithFormat:@"lBidRest%d", nDataIndex + 1] index:0];
        
        HogaItem *sellItem = [[HogaItem alloc] init];
        
        strMaedoHoga= [NSString stringWithFormat:@"%0.2f" , [strMaedoHoga floatValue] / 100];
        strMaesuHoga= [NSString stringWithFormat:@"%0.2f" , [strMaesuHoga floatValue] / 100];
        
        sellItem.price = [Util getCurrencyFromString:strMaedoHoga formatter:formatter];
        sellItem.rate = [self calcRate:[strMaedoHoga floatValue]];
        sellItem.priceColor = [self getColor:[strMaedoHoga floatValue] source:fLstCPrice];
        sellItem.hogaBalance = [Util getCurrencyFromString:strMaedoRemains formatter:nil];
        sellItem.hogaBalanceColor = [UIColor systemGrayColor];
        
        HogaItem *buyItem = [[HogaItem alloc] init];
        buyItem.price = [Util getCurrencyFromString:strMaesuHoga formatter:formatter];
        buyItem.priceColor = [self getColor:[strMaesuHoga floatValue] source:fLstCPrice];
        buyItem.rate = [self calcRate:[strMaesuHoga floatValue]];
        buyItem.hogaBalance = [Util getCurrencyFromString:strMaesuRemains formatter:nil];
        buyItem.hogaBalanceColor = [UIColor systemGrayColor];
        
        [arrayBuyItem addObject:buyItem];
        [arraySellItem addObject:sellItem];
    }
    [hogaView setBuyItem:arrayBuyItem];
    [hogaView setSellItem:arraySellItem];
    [hogaView invalidate];
}

- (void)requestFuturesPriceReal
{
    if(m_tranFuturesPrice == nil || m_realFuturesPrice == nil) return;

    [m_realFuturesPrice releaseReal];

    NSString *strFullCode = [m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:@"sCode" index:0];
    [m_realFuturesPrice setDataValue:@"InBlock1" fieldID:@"sCode" index:0 value:strFullCode];
    [m_realFuturesPrice requestReal];
}

- (void)requestFuturesHogaReal
{
    if(m_tranFuturesPrice == nil || m_realFuturesHoga == nil) return;

    [m_realFuturesHoga releaseReal];

    NSString *strFullCode = [m_tranFuturesPrice getDataValue:@"OutRec1" fieldID:@"sCode" index:0];    // 호가 데이터 요청한 종목코드

    [m_realFuturesHoga setDataValue:@"InBlock1" fieldID:@"sCode" index:0 value:strFullCode];
    [m_realFuturesHoga requestReal];
}

- (void)processPriceReal
{
    // 현재가
    NSString *strPrice = [m_realFuturesPrice getDataValue:@"OutBlock1" fieldID:@"lCPrice" index:0];
    int nPriceAttr = [m_realFuturesPrice getDataAttr:@"OutBlock1" fieldID:@"lCPrice" index:0];
    // 등락
    NSString *strDiff = [m_realFuturesPrice getDataValue:@"OutBlock1" fieldID:@"lDiff" index:0];
    int nDiffAttr = [m_realFuturesPrice getDataAttr:@"OutBlock1" fieldID:@"lDiff" index:0];
    // 등락기호
    NSString *strSign = [m_realFuturesPrice getDataValue:@"OutBlock1" fieldID:@"cPCheck" index:0];
//    int nSignAttr = [m_realFuturesPrice getDataAttr:@"OutBlock1" fieldID:@"cPCheck" index:0];
    // 등락률
    NSString *strDiffRatio = [m_realFuturesPrice getDataValue:@"OutBlock1" fieldID:@"lDiffRate" index:0];
    int nDiffRatioAttr = [m_realFuturesPrice getDataAttr:@"OutBlock1" fieldID:@"lDiffRate" index:0];
    // 체결량
//    NSString *strTradeVol = [m_realFuturesPrice getDataValue:@"OutBlock1" fieldID:@"lCurVolume" index:0];
//    int nTradeVolAttr = [m_realFuturesPrice getDataAttr:@"OutBlock1" fieldID:@"lCurVolume" index:0];

    // 누적거래량
    NSString *strTradeAmount = [m_realFuturesPrice getDataValue:@"OutBlock1" fieldID:@"lVolume" index:0];
    // 누적거래대금
//    NSString *strTradeMoney = [m_realFuturesPrice getDataValue:@"OutBlock1" fieldID:@"lValue" index:0];

    [itemCurrentPrice setText:[Util getCurrencyFromString:strPrice formatter:formatter]];
    [itemCurrentPrice setTextColor:[Util getValueColor:nPriceAttr]];
    [changePriceLabel setText:[Util getCurrencyFromString:strDiff formatter:formatter]];
    [changePriceLabel setTextColor:[Util getValueColor:nDiffAttr]];
    [signImageView setImage:[Util getValueSign:strSign]];
    [volumnLabel setText:[Util getCurrencyFromString:strTradeAmount formatter:nil]];
    [rateLabel setText:strDiffRatio];
    [rateLabel setTextColor:[Util getValueColor:nDiffRatioAttr]];
}
- (void)processHogaReal{
    
    NSString *strItemCode = [m_realFuturesHoga getDataValue:@"OutBlock1" fieldID:@"sCode" index:0];
    NSLog(@"호가 실시간 [ %@ ]" , strItemCode);
    NSMutableArray *arrayBuyItem = [NSMutableArray array];
    NSMutableArray *arraySellItem = [NSMutableArray array];
    // 호가 데이터
    // 5호가 데이터만 추출
    for(int nDataIndex = 0; nDataIndex < 10; nDataIndex++)
    {
        // 매도 호가
        NSString *strMaedoHoga = [m_realFuturesHoga getDataValue:@"OutBlock1" fieldID:[NSString stringWithFormat:@"lOffer%d", nDataIndex + 1] index:0];
        NSString *strMaedoRemains = [m_realFuturesHoga getDataValue:@"OutBlock1" fieldID:[NSString stringWithFormat:@"lOfferRest%d", nDataIndex + 1] index:0];
        // 매수 호가
        NSString *strMaesuHoga = [m_realFuturesHoga getDataValue:@"OutBlock1" fieldID:[NSString stringWithFormat:@"lBid%d", nDataIndex + 1] index:0];
        NSString *strMaesuRemains = [m_realFuturesHoga getDataValue:@"OutBlock1" fieldID:[NSString stringWithFormat:@"lBidRest%d", nDataIndex + 1] index:0];
        
        HogaItem *sellItem = [[HogaItem alloc] init];
        sellItem.price = [Util getCurrencyFromString:strMaedoHoga formatter:formatter];
        sellItem.rate = [self calcRate:[strMaedoHoga floatValue]];
        sellItem.priceColor = [self getColor:[strMaedoHoga floatValue] source:fLstCPrice];
        sellItem.hogaBalance = [Util getCurrencyFromString:strMaedoRemains formatter:nil];
        sellItem.hogaBalanceColor = [UIColor systemGrayColor];
        
        HogaItem *buyItem = [[HogaItem alloc] init];
        buyItem.price = [Util getCurrencyFromString:strMaesuHoga formatter:formatter];
        buyItem.priceColor = [self getColor:[strMaesuHoga floatValue] source:fLstCPrice];
        buyItem.rate = [self calcRate:[strMaesuHoga floatValue]];
        buyItem.hogaBalance = [Util getCurrencyFromString:strMaesuRemains formatter:nil];
        buyItem.hogaBalanceColor = [UIColor systemGrayColor];
        
        [arrayBuyItem addObject:buyItem];
        [arraySellItem addObject:sellItem];
    }
    [hogaView setBuyItem:arrayBuyItem];
    [hogaView setSellItem:arraySellItem];
    [hogaView invalidate];
    
}

- (void)processOptionRealPrice
{
    // 현재가
    NSString *strPrice = [m_realOptionsPrice getDataValue:@"OutBlock1" fieldID:@"lCPrice" index:0];
    int nPriceAttr = [m_realOptionsPrice getDataAttr:@"OutBlock1" fieldID:@"lCPrice" index:0];
    // 등락
    NSString *strDiff = [m_realOptionsPrice getDataValue:@"OutBlock1" fieldID:@"lDiff" index:0];
    int nDiffAttr = [m_realOptionsPrice getDataAttr:@"OutBlock1" fieldID:@"lDiff" index:0];
    // 등락기호
    NSString *strSign = [m_realOptionsPrice getDataValue:@"OutBlock1" fieldID:@"cPCheck" index:0];
//    int nSignAttr = [m_realOptionsPrice getDataAttr:@"OutBlock1" fieldID:@"cPCheck" index:0];
    // 등락률
    NSString *strDiffRatio = [m_realOptionsPrice getDataValue:@"OutBlock1" fieldID:@"lDiffRate" index:0];
    int nDiffRatioAttr = [m_realOptionsPrice getDataAttr:@"OutBlock1" fieldID:@"lDiffRate" index:0];
    // 체결량
//    NSString *strTradeVol = [m_realOptionsPrice getDataValue:@"OutBlock1" fieldID:@"lCurVolume" index:0];
//    int nTradeVolAttr = [m_realOptionsPrice getDataAttr:@"OutBlock1" fieldID:@"lCurVolume" index:0];

    // 누적거래량
    NSString *strTradeAmount = [m_realOptionsPrice getDataValue:@"OutBlock1" fieldID:@"lVolume" index:0];
    // 누적거래대금
//    NSString *strTradeMoney = [m_realOptionsPrice getDataValue:@"OutBlock1" fieldID:@"lValue" index:0];

    [itemCurrentPrice setText:[Util getCurrencyFromString:strPrice formatter:formatter]];
    [itemCurrentPrice setTextColor:[Util getValueColor:nPriceAttr]];
    [changePriceLabel setText:[Util getCurrencyFromString:strDiff formatter:formatter]];
    [changePriceLabel setTextColor:[Util getValueColor:nDiffAttr]];
    [signImageView setImage:[Util getValueSign:strSign]];
    [volumnLabel setText:[Util getCurrencyFromString:strTradeAmount formatter:nil]];
    [rateLabel setText:strDiffRatio];
    [rateLabel setTextColor:[Util getValueColor:nDiffRatioAttr]];
}

- (void)processOptionHogaReal{
    NSString *strItemCode = [m_realOptionsHoga getDataValue:@"OutBlock1" fieldID:@"sCode" index:0];
    NSLog(@"호가 실시간 [ %@ ]" , strItemCode);
    NSMutableArray *arrayBuyItem = [NSMutableArray array];
    NSMutableArray *arraySellItem = [NSMutableArray array];
    // 호가 데이터
    // 5호가 데이터만 추출
    for(int nDataIndex = 0; nDataIndex < 10; nDataIndex++)
    {
        // 매도 호가
        NSString *strMaedoHoga = [m_realOptionsHoga getDataValue:@"OutBlock1" fieldID:[NSString stringWithFormat:@"lOffer%d", nDataIndex + 1] index:0];
        NSString *strMaedoRemains = [m_realOptionsHoga getDataValue:@"OutBlock1" fieldID:[NSString stringWithFormat:@"lOfferRest%d", nDataIndex + 1] index:0];
        // 매수 호가
        NSString *strMaesuHoga = [m_realOptionsHoga getDataValue:@"OutBlock1" fieldID:[NSString stringWithFormat:@"lBid%d", nDataIndex + 1] index:0];
        NSString *strMaesuRemains = [m_realOptionsHoga getDataValue:@"OutBlock1" fieldID:[NSString stringWithFormat:@"lBidRest%d", nDataIndex + 1] index:0];
        
        HogaItem *sellItem = [[HogaItem alloc] init];
        sellItem.price = [Util getCurrencyFromString:strMaedoHoga formatter:formatter];
        sellItem.rate = [self calcRate:[strMaedoHoga floatValue]];
        sellItem.priceColor = [self getColor:[strMaedoHoga floatValue] source:fLstCPrice];
        sellItem.hogaBalance = [Util getCurrencyFromString:strMaedoRemains formatter:nil];
        sellItem.hogaBalanceColor = [UIColor systemGrayColor];
        
        HogaItem *buyItem = [[HogaItem alloc] init];
        buyItem.price = [Util getCurrencyFromString:strMaesuHoga formatter:formatter];
        buyItem.priceColor = [self getColor:[strMaesuHoga floatValue] source:fLstCPrice];
        buyItem.rate = [self calcRate:[strMaesuHoga floatValue]];
        buyItem.hogaBalance = [Util getCurrencyFromString:strMaesuRemains formatter:nil];
        buyItem.hogaBalanceColor = [UIColor systemGrayColor];
        
        [arrayBuyItem addObject:buyItem];
        [arraySellItem addObject:sellItem];
    }
    [hogaView setBuyItem:arrayBuyItem];
    [hogaView setSellItem:arraySellItem];
    [hogaView invalidate];
    
}

- (void)requestOptionsPriceReal
{
    if(m_tranOptionsPrice == nil || m_realOptionsPrice == nil) return;

    [m_realOptionsPrice releaseReal];

    NSString *strFullCode = [m_tranOptionsPrice getDataValue:@"OutRec1" fieldID:@"sCode" index:0];

    [m_realOptionsPrice setDataValue:@"InBlock1" fieldID:@"sCode" index:0 value:strFullCode];
    [m_realOptionsPrice requestReal];
}

- (void)requestOptionsHogaReal
{
    if(m_tranOptionsPrice == nil || m_realOptionsHoga == nil) return;

    [m_realOptionsHoga releaseReal];

    NSString *strFullCode = [m_tranOptionsPrice getDataValue:@"OutRec1" fieldID:@"sCode" index:0];    // 호가 데이터 요청한 종목코드

    [m_realOptionsHoga setDataValue:@"InBlock1" fieldID:@"sCode" index:0 value:strFullCode];
    [m_realOptionsHoga requestReal];
}

// 선옵 매수 주문
- (void) requestOrderBuy
{
    if(m_tranFutOptBuy == nil) return;

    // 계좌
    NSString *strAccountNo = [accountComboBox getSelectkey];
    NSString *strAccountPwd = [accountPWD text];;

    // 종목
    // 종목
    NSString *strItemCode = sItemCode;
//    NSString *strFullCode = [[SmartChampAPI instance] getItemFullCode:strItemCode];

    // 주문수량, 주문가격
    NSString *strOrderCount = [self getQty];
    NSString *strOrderPrice = [self getPrice];

    // 데이터 요청전에 입력데이터, 출력데이터 클리어
    [m_tranFutOptBuy clearInputData];
    [m_tranFutOptBuy clearOutputData];


    // 입력 데이터 설정
    [m_tranFutOptBuy setDataValue:@"InRec1" fieldID:@"ACNO" index:0 value:strAccountNo];        // 계좌번호
    [m_tranFutOptBuy setDataValue:@"InRec1" fieldID:@"AC_PWD" index:0 value:strAccountPwd];    // 계좌비번

    [m_tranFutOptBuy setDataValue:@"InRec1" fieldID:@"ITEM_COD" index:0 value:strItemCode];    // 종목코드
    [m_tranFutOptBuy setDataValue:@"InRec1" fieldID:@"ORD_Q" index:0 value:strOrderCount];   // 주문수량
    [m_tranFutOptBuy setDataValue:@"InRec1" fieldID:@"ORD_UPR" index:0 value:strOrderPrice];  // 주문단가
    // 매수매도거래구분코드 (10:매도, 20:매수)
    [m_tranFutOptBuy setDataValue:@"InRec1" fieldID:@"BUY_SEL_TR_TCD" index:0 value:@"20"];
    // 주문매매구분코드 (010:지정가, 020:시장가, 030:조건부지정가, 040:최유리지정가)
    [m_tranFutOptBuy setDataValue:@"InRec1" fieldID:@"ORD_BNS_TCD" index:0 value:[self getOrderType]];
    // 주문조건구분코드 (0:없음, 1:IOC, 2:FOK)
    [m_tranFutOptBuy setDataValue:@"InRec1" fieldID:@"ORD_COND_TCD" index:0 value:[self getOrderContition]];

    // 서버에 요청
    [m_tranFutOptBuy requestData];
}

// 선옵 매도 주문
- (void)requestOrderSell
{
    if(m_tranFutOptSell == nil) return;

    // 주문계좌
    NSString *strAccountNo = [accountComboBox getSelectkey];
    NSString *strAccountPwd = [accountPWD text];;

    // 종목
    // 종목
    NSString *strItemCode = sItemCode;
//    NSString *strFullCode = [[SmartChampAPI instance] getItemFullCode:strItemCode];

    // 주문수량, 주문가격
    NSString *strOrderCount = [self getQty];
    NSString *strOrderPrice = [self getPrice];

    // 데이터 요청전에 입력/출력 데이터 클리어
    [m_tranFutOptSell clearInputData];
    [m_tranFutOptSell clearOutputData];

    // 입력 데이터 설정
    [m_tranFutOptSell setDataValue:@"InRec1" fieldID:@"ACNO" index:0 value:strAccountNo];        // 계좌번호
    [m_tranFutOptSell setDataValue:@"InRec1" fieldID:@"AC_PWD" index:0 value:strAccountPwd];    // 계좌비번

    [m_tranFutOptSell setDataValue:@"InRec1" fieldID:@"ITEM_COD" index:0 value:strItemCode];    // 종목코드
    [m_tranFutOptSell setDataValue:@"InRec1" fieldID:@"ORD_Q" index:0 value:strOrderCount];   // 주문수량
    [m_tranFutOptSell setDataValue:@"InRec1" fieldID:@"ORD_UPR" index:0 value:strOrderPrice];  // 주문단가
    // 매수매도거래구분코드 (10:매도, 20:매수)
    [m_tranFutOptSell setDataValue:@"InRec1" fieldID:@"BUY_SEL_TR_TCD" index:0 value:@"10"];
    // 주문매매구분코드 (010:지정가, 020:시장가, 030:조건부지정가, 040:최유리지정가)
    [m_tranFutOptSell setDataValue:@"InRec1" fieldID:@"ORD_BNS_TCD" index:0 value:[self getOrderType]];
    // 주문조건구분코드 (0:없음, 1:IOC, 2:FOK)
    [m_tranFutOptSell setDataValue:@"InRec1" fieldID:@"ORD_COND_TCD" index:0 value:[self getOrderContition]];

    // 서버에 요청
    [m_tranFutOptSell requestData];
}

// 선옵 정정 주문
- (void)requestOrderModify
{
    if(m_tranFutOptModify == nil) return;

    // 계좌 정보
    // 주문계좌
    NSString *strAccountNo = [accountComboBox getSelectkey];
    NSString *strAccountPwd = [accountPWD text];;
    // 종목
    NSString *strItemCode = sItemCode;
//    NSString *strFullCode = [[SmartChampAPI instance] getItemFullCode:strItemCode];

    // 주문수량, 주문가격, 원주문번호
    NSString *strOrderCount = [self getQty];
    NSString *strOrderPrice = [self getPrice];
    NSString *strOrgOrderNo = [self getOrderNo];

    // 서비스 요청전 입력/출력 데이터 클리어
    [m_tranFutOptModify clearInputData];
    [m_tranFutOptModify clearOutputData];

    // 입력 데이터 설정
    [m_tranFutOptModify setDataValue:@"InRec1" fieldID:@"ACNO" index:0 value:strAccountNo];        // 계좌번호
    [m_tranFutOptModify setDataValue:@"InRec1" fieldID:@"AC_PWD" index:0 value:strAccountPwd];    // 계좌비번

    [m_tranFutOptModify setDataValue:@"InRec1" fieldID:@"OORD_NO" index:0 value:strOrgOrderNo];  // 원주문번호
    // 정정취소구분 (20: 정정, 30:취소)
    [m_tranFutOptModify setDataValue:@"InRec1" fieldID:@"ORD_MDFY_CNCL_TCD" index:0 value:@"20"];
    // 일부전부구분 (10: 일부, 20:전부)
    
    if (allPartButton.selected)
    {
        [m_tranFutOptModify setDataValue:@"InRec1" fieldID:@"PAT_ALL_TCD" index:0 value:@"20"];
    }else{
        [m_tranFutOptModify setDataValue:@"InRec1" fieldID:@"PAT_ALL_TCD" index:0 value:@"10"];
    }

    [m_tranFutOptModify setDataValue:@"InRec1" fieldID:@"ITEM_COD" index:0 value:strItemCode];    // 종목코드
    [m_tranFutOptModify setDataValue:@"InRec1" fieldID:@"ORD_Q" index:0 value:strOrderCount];   // 주문수량
    [m_tranFutOptModify setDataValue:@"InRec1" fieldID:@"ORD_UPR" index:0 value:strOrderPrice];  // 주문단가
    // 주문매매구분코드 (010:지정가, 020:시장가, 030:조건부지정가, 040:최유리지정가)
    [m_tranFutOptModify setDataValue:@"InRec1" fieldID:@"ORD_BNS_TCD" index:0 value:[self getOrderType]];
    // 주문조건구분코드 (0:없음, 1:IOC, 2:FOK)
    [m_tranFutOptModify setDataValue:@"InRec1" fieldID:@"ORD_COND_TCD" index:0 value:[self getOrderContition]];

    // 서버에 요청
    [m_tranFutOptModify requestData];
}

// 선옵 취소 주문
- (void)requestOrderCancel
{
    if(m_tranFutOptCancel == nil) return;

    // 계좌 정보
    // 주문계좌
    NSString *strAccountNo = [accountComboBox getSelectkey];
    NSString *strAccountPwd = [accountPWD text];;
    // 종목
    NSString *strItemCode = sItemCode;
//    NSString *strFullCode = [[SmartChampAPI instance] getItemFullCode:strItemCode];

    // 주문수량, 주문가격, 원주문번호
    NSString *strOrderCount = [self getQty];
    NSString *strOrderPrice = [self getPrice];
    NSString *strOrgOrderNo = [self getOrderNo];

    // 서비스 요청전 입력/출력 데이터 클리어
    [m_tranFutOptCancel clearInputData];
    [m_tranFutOptCancel clearOutputData];

    // 입력 데이터 설정
    [m_tranFutOptCancel setDataValue:@"InRec1" fieldID:@"ACNO" index:0 value:strAccountNo];        // 계좌번호
    [m_tranFutOptCancel setDataValue:@"InRec1" fieldID:@"AC_PWD" index:0 value:strAccountPwd];    // 계좌비번

    [m_tranFutOptCancel setDataValue:@"InRec1" fieldID:@"OORD_NO" index:0 value:strOrgOrderNo];  // 원주문번호
    // 정정취소구분 (20: 정정, 30:취소)
    [m_tranFutOptCancel setDataValue:@"InRec1" fieldID:@"ORD_MDFY_CNCL_TCD" index:0 value:@"30"];
    // 일부전부구분 (10: 일부, 20:전부)
    // 일부전부구분 (10: 일부, 20:전부)
    if (allPartButton.selected)
    {
        [m_tranFutOptCancel setDataValue:@"InRec1" fieldID:@"PAT_ALL_TCD" index:0 value:@"20"];
    }else{
        [m_tranFutOptCancel setDataValue:@"InRec1" fieldID:@"PAT_ALL_TCD" index:0 value:@"10"];
    }

    [m_tranFutOptCancel setDataValue:@"InRec1" fieldID:@"ITEM_COD" index:0 value:strItemCode];    // 종목코드
    [m_tranFutOptCancel setDataValue:@"InRec1" fieldID:@"ORD_Q" index:0 value:strOrderCount];   // 주문수량
    [m_tranFutOptCancel setDataValue:@"InRec1" fieldID:@"ORD_UPR" index:0 value:strOrderPrice];  // 주문단가
    // 주문매매구분코드 (010:지정가, 020:시장가, 030:조건부지정가, 040:최유리지정가)
    [m_tranFutOptCancel setDataValue:@"InRec1" fieldID:@"ORD_BNS_TCD" index:0 value:[self getOrderType]];
    // 주문조건구분코드 (0:없음, 1:IOC, 2:FOK)
    [m_tranFutOptCancel setDataValue:@"InRec1" fieldID:@"ORD_COND_TCD" index:0 value:[self getOrderContition]];

    // 서버에 요청
    [m_tranFutOptCancel requestData];
}

- (void)requestJango
{
    if(m_tranJango == nil) return;

    NSString *strAccountNo = [accountComboBox getSelectkey];
    NSString *strAccountPwd = [accountPWD text];;

    if( [ComUtil isTextEmpty:strAccountNo] || [ComUtil isTextEmpty:strAccountPwd]) return;

    [m_tranJango clearInputData];
    [m_tranJango clearOutputData];

    [m_tranJango setDataValue:@"InRec1" fieldID:@"ACNO" index:0 value:strAccountNo];        // 계좌번호
    [m_tranJango setDataValue:@"InRec1" fieldID:@"AC_PWD" index:0 value:strAccountPwd];    // 계좌비번

    [m_tranJango setDataValue:@"InRec1" fieldID:@"CMSN_ICLN_YN" index:0 value:@"N"];

    [m_tranJango setDataHeader:@"DETAIL_CONT" data:@"1"]; // 연속조회
    [m_tranJango setDataHeader:@"DETAIL_QRY_CNT" data:@"10"]; // 조회개수

    [m_tranJango requestData];
}

- (void) requestChegyul
{
    if(m_tranChegyul == nil) return;

    NSString *strAccountNo = [accountComboBox getSelectkey];
    NSString *strAccountPwd = [accountPWD text];;

    if( [ComUtil isTextEmpty:strAccountNo] || [ComUtil isTextEmpty:strAccountPwd]) return;

    [m_tranChegyul clearInputData];
    [m_tranChegyul clearOutputData];

    [m_tranChegyul setDataValue:@"InBlock1" fieldID:@"ACNO" index:0 value:strAccountNo];        // 계좌번호
    [m_tranChegyul setDataValue:@"InBlock1" fieldID:@"AC_PWD" index:0 value:strAccountPwd];    // 계좌비번

    [m_tranChegyul setDataValue:@"InBlock1" fieldID:@"SORT_TURN_IO1CD" index:0 value:@"2"];
    [m_tranChegyul setDataValue:@"InBlock1" fieldID:@"CLSN_TP_IO1CD" index:0 value:@"2"];
    [m_tranChegyul setDataValue:@"InBlock1" fieldID:@"BUY_SEL_TR_TCD" index:0 value:@"%"];
    [m_tranChegyul setDataValue:@"InBlock1" fieldID:@"ITEM_TP_IO1CD" index:0 value:@"%"];

    [m_tranChegyul setDataHeader:@"DETAIL_CONT" data:@"1"]; // 연속조회
    [m_tranChegyul setDataHeader:@"DETAIL_QRY_CNT" data:@"10"];  // 조회개수

    [m_tranChegyul requestData];
}

- (void)onTranBeforeRequest:(NSString *)sTranID nextQuery:(BOOL)isNextQuery
{
    // 계좌비번,사용자비번 등은 서버에 요청 후 삭제됨
    // 요청시마다 다시 설정 필요...
    if([sTranID isEqualToString:@"선옵체결내역"])
    {
        // 비번 조회
        [m_tranChegyul setDataValue:@"InRec1" fieldID:@"AC_PWD" index:0 value:sEncryptAccPwd];    // 계좌비번
    } else if([sTranID isEqualToString:@"선옵잔고조회"])
    {
        // 비번 조회
        [m_tranJango setDataValue:@"InRec1" fieldID:@"AC_PWD" index:0 value:sEncryptAccPwd];    // 계좌비번
    }
}

- (void)onTranDataReceived:(NSString *)tran msgCode:(NSString *)code msgText:(NSString *)text
{
    NSLog(@"onTranDataReceived [%@] [%@] [%@]" , tran ,code ,text);
    
    if( [tran isEqualToString:@"지수선물현재가"]){
        [self processFutureCurPrice];
        [self requestFuturesPriceReal];
        [self requestFuturesHogaReal];
    }else if([tran isEqualToString:@"지수옵션현재가"]){
        [self processOptionCurPrice];
        [self requestOptionsPriceReal];
        [self requestOptionsHogaReal];
    }else if([tran isEqualToString:@"선옵매수주문"]){
        NSString *strOrderNo = [m_tranFutOptBuy getDataValue:@"OutRec1" fieldID:@"ORD_NO" index:0];
        [self setOrderNo:strOrderNo];
        [[iToast instance] showText:[m_tranFutOptBuy getDataMsgText] duration:iToastDurationLong gravity:iToastGravityBottom];
    }else if([tran isEqualToString:@"선옵매도주문"]){
        NSString *strOrderNo = [m_tranFutOptSell getDataValue:@"OutRec1" fieldID:@"ORD_NO" index:0];
        [self setOrderNo:strOrderNo];
        [[iToast instance] showText:[m_tranFutOptSell getDataMsgText] duration:iToastDurationLong gravity:iToastGravityBottom];
    }else if([tran isEqualToString:@"선옵정정주문"]){
        NSString *strOrderNo = [m_tranFutOptModify getDataValue:@"OutRec1" fieldID:@"ORD_NO" index:0];
        [self setOrderNo:strOrderNo];
        [[iToast instance] showText:[m_tranFutOptModify getDataMsgText] duration:iToastDurationLong gravity:iToastGravityBottom];
    }else if([tran isEqualToString:@"선옵취소주문"]){
        NSString *strOrderNo = [m_tranFutOptCancel getDataValue:@"OutRec1" fieldID:@"ORD_NO" index:0];
        [self setOrderNo:strOrderNo];
        [[iToast instance] showText:[m_tranFutOptCancel getDataMsgText] duration:iToastDurationLong gravity:iToastGravityBottom];
    }else if([tran isEqualToString:@"선옵잔고조회"]){
        int nDataCount = [m_tranJango getDataCount:@"OutRec2"];
        NSMutableArray *arrayItems = [NSMutableArray array];
        for(int i = 0; i < nDataCount; i++) {
            NSMutableDictionary *dicJango = [NSMutableDictionary dictionary];

            dicJango[@"종목코드"] = [ComUtil trim:[m_tranJango getDataValue:@"OutRec2" fieldID:@"ITEM_COD" index:i]];
            dicJango[@"종목명"] = [ComUtil trim:[m_tranJango getDataValue:@"OutRec2" fieldID:@"ITEM_NM" index:i]];
            dicJango[@"매수매도구분명"] = [ComUtil trim:[m_tranJango getDataValue:@"OutRec2" fieldID:@"BUY_SEL_TP_NM" index:i]];
            
            dicJango[@"청산가능수량"] = [ComUtil trim:[m_tranJango getDataValue:@"OutRec2" fieldID:@"LQDT_ABLE_Q" index:i]];
            dicJango[@"미결제약정수량"] = [ComUtil trim:[m_tranJango getDataValue:@"OutRec2" fieldID:@"FUOP_USCTR_Q" index:i]];
            dicJango[@"미결제약정가격"] = [ComUtil trim:[m_tranJango getDataValue:@"OutRec2" fieldID:@"USCTR_UPR" index:i]];
            dicJango[@"매입금액"] = [ComUtil trim:[m_tranJango getDataValue:@"OutRec2" fieldID:@"PCHS_A" index:i]];
            dicJango[@"평가손익"] = [ComUtil trim:[m_tranJango getDataValue:@"OutRec2" fieldID:@"PL_A" index:i]];
            [arrayItems addObject:dicJango];
        }
        
        BottomTableView *tableView = [[BottomTableView alloc] initWithFrame:self.view.bounds];
        [tableView setBottomDelegate:self];
        [tableView setTag:1];
        [tableView setTableViewItem:arrayItems];
        [self.view addSubview:tableView];
    }
    else if([tran isEqualToString:@"선옵체결내역"])
    {
        int nDataCount = [m_tranChegyul getDataCount:@"OutBlock2"];
        NSMutableArray *arrayItems = [NSMutableArray array];
        for(int i = 0; i < nDataCount; i++) {
            NSMutableDictionary *dicChegyul = [NSMutableDictionary dictionary];

            dicChegyul[@"주문번호"] = [m_tranChegyul getDataValue:@"OutBlock2" fieldID:@"ORD_NO" index:i];
            dicChegyul[@"종목코드"] = [m_tranChegyul getDataValue:@"OutBlock2" fieldID:@"ITEM_COD" index:i];
            dicChegyul[@"종목명"] = [m_tranChegyul getDataValue:@"OutBlock2" fieldID:@"ITEM_NM" index:i];
            dicChegyul[@"매수매도거래구분코드"] = [m_tranChegyul getDataValue:@"OutBlock2" fieldID:@"BUY_SEL_TR_TCD" index:i];
            dicChegyul[@"구분명"] = [m_tranChegyul getDataValue:@"OutBlock2" fieldID:@"TP_NM" index:i];
            dicChegyul[@"주문수량"] = [m_tranChegyul getDataValue:@"OutBlock2" fieldID:@"ORD_Q" index:i];
            dicChegyul[@"체결수량"] = [m_tranChegyul getDataValue:@"OutBlock2" fieldID:@"CLSN_Q" index:i];
            dicChegyul[@"주문잔량"] = [m_tranChegyul getDataValue:@"OutBlock2" fieldID:@"ORD_RQ" index:i];
            dicChegyul[@"주문가격"] = [m_tranChegyul getDataValue:@"OutBlock2" fieldID:@"ORD_UPR" index:i];
            dicChegyul[@"체결가격"] = [m_tranChegyul getDataValue:@"OutBlock2" fieldID:@"CLSN_UPR" index:i];
            dicChegyul[@"주문상태"] = [m_tranChegyul getDataValue:@"OutBlock2" fieldID:@"ORD_SCD" index:i];

            [arrayItems addObject:dicChegyul];
        }
        
        BottomTableView *tableView = [[BottomTableView alloc] initWithFrame:self.view.bounds];
        [tableView setBottomDelegate:self];
        [tableView setTag:2];
        [tableView setTableViewItem:arrayItems];
        [self.view addSubview:tableView];
    }
}


- (void)onTranError:(NSString*)tran msgCode:(NSString*)code msgText:(NSString*)text
{
    UIAlertController* alert = [UIAlertController alertControllerWithTitle:tran
                               message:[NSString stringWithFormat:@"[%@] : %@" , code , text]
                               preferredStyle:UIAlertControllerStyleAlert];

    UIAlertAction* defaultAction = [UIAlertAction actionWithTitle:@"확인" style:UIAlertActionStyleDefault
                                   handler:^(UIAlertAction * action) {
        
    }];

    [alert addAction:defaultAction];
    [self presentViewController:alert animated:YES completion:nil];
}
- (void)onTranTimeout:(NSString*)tran
{
    
}


- (void)selectComboBox:(ComboBox*)box selectKey:(NSString*)key
{
    
}

- (void)didSelectItem:(NSDictionary*)dic object:(BottomTableView*)bottom
{
    // 잔고
    if ([bottom tag] == 1){
        if (dic != nil){
            NSString *sType = dic[@"매수매도구분명"];
            if ( [sType rangeOfString:@"매수"].location != NSNotFound ){
                [self onTabOrderButton:sellButton];
            }else if ( [sType rangeOfString:@"매도"].location != NSNotFound ){
                [self onTabOrderButton:buyButton];
            }
            
            NSString *code = dic[@"종목코드"];
            if (![code isEqualToString:sItemCode]){
                sItemCode = dic[@"종목코드"];
                [itemLabel setText:dic[@"종목명"]];
                [self requestCurrPrice];
            }
            [self setJangoQty:dic[@"청산가능수량"]];
        }
    }else if ([bottom tag] == 2){ // 미체결
        NSString *code = dic[@"종목코드"];
        if (![code isEqualToString:sItemCode]){
            sItemCode = dic[@"종목코드"];
            [self requestCurrPrice];
        }
        [self onTabOrderButton:cancelButton];
        NSString *sOrderNo = dic[@"주문번호"];
        [self setCollectOrderNo:sOrderNo];
        NSString *sMiCheQty = dic[@"주문잔량"];
        [self setMicheclQty:sMiCheQty];
        
        NSString *sMiChePrice = dic[@"주문가격"];
        [self setMichePrice:sMiChePrice];
    }
}

#pragma mark - IRealDataDelegate method
- (void)onRealBeforeRequest:(NSString *)sRealId {
    

}

- (void)onRealDataReceived:(NSString *)sRealId {
    if ([@"선물체결실시간" isEqualToString:sRealId]){
        [self processPriceReal];
    }else if ([@"선물호가실시간" isEqualToString:sRealId]){
        [self processHogaReal];
    }else if ([@"옵션체결실시간" isEqualToString:sRealId]){
        [self processOptionRealPrice];
    }else if ([@"옵션호가실시간" isEqualToString:sRealId]){
        [self processOptionHogaReal];
    }
}
//
//#pragma mark -
//#pragma mark NFilter 키패드 callback 함수
//- (void)onReArrangeNFilter
//{
//    
//}
//
///*--------------------------------------------------------------------------------------
// 엔필터 '이전' 버튼 눌렀을 때 발생하는 콜백함수
// ---------------------------------------------------------------------------------------*/
//- (void)onPrevNFilter:(NSString *)secureText encText:(NSString *)encText dummyText:(NSString *)dummyText tagName:(NSString *)tagName {
//    NSLog(@"이전버튼 눌림");
//    NSLog(@"태그: %@", tagName);
//    NSLog(@"암호문 : %@", secureText);
//    NSLog(@"더미: %@", dummyText);
//    NSLog(@"서버에 보낼 암호문: %@", encText);
//}
//
///*--------------------------------------------------------------------------------------
// 엔필터 '다음' 버튼 눌렀을 때 발생하는 콜백함수
// ---------------------------------------------------------------------------------------*/
//- (void)onNextNFilter:(NSString *)secureText encText:(NSString *)encText dummyText:(NSString *)dummyText tagName:(NSString *)tagName
//{
//    NSLog(@"다음버튼 눌림");
//    NSLog(@"태그: %@", tagName);
//    NSLog(@"암호문 : %@", secureText);
//    NSLog(@"더미: %@", dummyText);
//    NSLog(@"서버에 보낼 암호문: %@", encText);
//}
//
///*--------------------------------------------------------------------------------------
// 엔필터 '키' 버튼 눌렀을 때 발생하는 콜백함수
// ---------------------------------------------------------------------------------------*/
//- (void)onPressNFilter:(NSString *)secureText encText:(NSString *)encText dummyText:(NSString *)dummyText tagName:(NSString *)tagName
//{
//    NSLog(@"엔필터 키눌림");
//    NSLog(@"태그: %@", tagName);
//    NSLog(@"암호문 : %@", secureText);
//    NSLog(@"더미: %@", dummyText);
//    NSLog(@"서버에 보낼 암호문: %@", encText);
//    
//}
//
///*--------------------------------------------------------------------------------------
// 엔필터 '취소' 버튼 눌렀을 때 발생하는 콜백함수
// ---------------------------------------------------------------------------------------*/
//- (void)onCancelNFilter:(NSString *)secureText encText:(NSString *)encText dummyText:(NSString *)dummyText tagName:(NSString *)tagName
//{
//    NSLog(@"엔필터 닫힘 : onCancelNFilter");
//    NSLog(@"태그: %@", tagName);
//    NSLog(@"암호문 : %@", secureText);
//    NSLog(@"더미: %@", dummyText);
//    NSLog(@"서버에 보낼 암호문: %@", encText);
//    //비대면 계좌개설 2022.07 bkkim
////    m_dummylength = (int)[dummyText length];
//    
//    //비대면 계좌개설 2022.07 bkkim
//    [self closeFilterKeyboard];
//}
//
//
///*--------------------------------------------------------------------------------------
// 엔필터 '취소' 버튼 눌렀을 때 발생하는 콜백함수
// ---------------------------------------------------------------------------------------*/
//- (void)onCancel {
//    NSLog(@"엔필터 닫힘");
//    
//    [self closeFilterKeyboard];
//}
//
///*--------------------------------------------------------------------------------------
// 엔필터 'Background Close'동작할때 발생하는 콜백 함수
// ---------------------------------------------------------------------------------------*/
//- (void)onCloseNFilter:(NSString *)secureText encText:(NSString *)encText dummyText:(NSString *)dummyText tagName:(NSString *)tagName
//{
//    NSLog(@"엔필터 닫힘 : onCloseNFilter");
//    NSLog(@"태그: %@", tagName);
//    NSLog(@"암호문 : %@", secureText);
//    NSLog(@"더미: %@", dummyText);
//    NSLog(@"서버에 보낼 암호문: %@", encText);
//}
//- (void)onConfirmNFilter:(NSString *)secureText encText:(NSString *)encText dummyText:(NSString *)dummyText tagName:(NSString *)tagName
//{
//    NSLog(@"엔필터 닫힘");
//    NSLog(@"태그: %@", tagName);
//    NSLog(@"암호문 : %@", secureText);
//    NSLog(@"더미: %@", dummyText);
//    NSLog(@"서버에 보낼 암호문: %@", encText);
//    
//    
//    int ndummylength = (int)[dummyText length];
//    
//    
//    //비대면 계좌개설 2022.07 bkkim
////    m_dummylength = ndummylength;
//    //비대면 계좌개설 2022.07 bkkim
//    if (ndummylength == 0)
//    {
//        
//    }
//    else
//    {
//        //    EccEncryptor      // 이전버전 nFilter의 NFilterNum 소스내에 평문을 암호화하는 과정이 있어서 그대로 구현함. 2017.02.03. - cory
////        NSString* sss = [[EccEncryptor sharedInstance] makeDecNoPadWithSeedkey:secureText];
//        
//        char* output = NULL;   // 복호화된 평문 결과
//        int outlen = 0; // 복호화된 평문 길이
//        [[EccEncryptor sharedInstance] makeDecNoPadWithSeedkey:secureText output:&output outlen:&outlen];
//        
//        NSString* sss = [NSString stringWithUTF8String:output];
//        NSString* encript = [self StringtoEncript:sss];
//        
////        sPlainCert = sss;
//        sEncryptAccPwd = encript;
//        [accountPWD setText:sss];
//        
//        
//        if(output)
//        {
//            for(int i=0; i<outlen; i++)
//            {
//                output[i] = 0;
//            }
//            free(output);
//            output = NULL;
//        }
//    }
//    
//    // allowCloseKeypadConfirmPressed 속성이 NO여서 키패드가 안닫힐때 내려가게하고 싶으면 아래와 같이 closeKeypad를 호출하면 키패드가 내려갑니다.
//    [self closeFilterKeyboard];
//}
//
//- (void) closeFilterKeyboard
//{
//    [keyboardController closeKeypad];
//    keyboardController = nil;
//}
//
//-(NSString*)StringtoEncript:(NSString*)data
//{
//    // 1. 서버공개키를 지정하여 클라이언트공개키와 시드키를 생성한다.
//    EccEncryptor *ec = [EccEncryptor sharedInstance];
//    NSString *refClientPublickey;
//    NSData *refSeedKey;
//    
//    [ec getSeedKeyNClientPublickeyWithServerPublickey:[[SmartChampAPI instance] getSecKeyPublicKey] ClientPublickey:&refClientPublickey SeedKey:&refSeedKey];
//    
//    //     2.1 암호화 작업 (문자형 암호화)
////    NSString *encData = [ec makeEncNoPadding:data];
//    NSString *encData = [ec makeEncNoPadding:[data dataUsingEncoding:NSUTF8StringEncoding] ];    // NFilter Library 변경
//    
//    return encData;
//}

- (void)selectPrice:(NSString*)price
{
    [self setPrice:price];
}


@end
