//
//  LoginViewController.m
//  EugineAPISample
//
//  Created by aaab on 2023/01/03.
//

#import "LoginViewController.h"
#import "Util.h"
#import "CertListViewController.h"
#import "SmartChampAPI.h"
#import "ComUtil.h"
#import "iToast.h"
#import "INetLoginDelegate.h"
#import "CopyCertViewController.h"
#import "ComboBox.h"
//#import "NFilterChar.h"
//#import "EccEncryptor.h"
#import "UITextField+Addition.h"
#import "SmartChampDefs.h"
#import "ExportCertViewController.h"

@interface LoginViewController () <INetLoginDelegate , IComboBox , UITextFieldDelegate>
{
    UITextField *idTextField;
    UITextField *idPassowrdField;
    NSString    *sPlainIDPassword;
    NSString    *sEncryptIDPassword;
    UITextField *certPwdTextField;
//    NSString    *sPlainCert;
    NSString    *sEncryptCert;
    UIButton    *checkBtn;
    
    ComboBox    *corpbox;
    NSString    *certDN;
    NSString    *certPW;
    BOOL        isCertLogin;
    
    UIButton    *checkServerBtn;
//    NFilterChar *keyboardController;
    // ICESMAN
//    EZRA16 , 1357 , !q2w3e4r5t
    
    BOOL        isRealServer;
}
@end

@implementation LoginViewController


- (void)viewDidLoad {
    [super viewDidLoad];
    
    isCertLogin = [[ComUtil getString:@"certlogin" basic:@"0"] boolValue];

    [self.view setBackgroundColor:[UIColor whiteColor]];
    // Do any additional setup after loading the view.
    CGFloat selfWidth = CGRectGetWidth(self.view.frame);
    UILabel *idLebel = [[UILabel alloc] initWithFrame:CGRectMake(0, 200, selfWidth, 50)];
    [idLebel setTag:2];
    [idLebel setTextAlignment:NSTextAlignmentCenter];
    [self.view addSubview:idLebel];
    
    CGFloat padding = 20;
    idTextField = [[UITextField alloc] initWithFrame:CGRectMake(padding, 30, CGRectGetWidth(self.view.frame) - padding * 2, 35)];
    [idTextField setDelegate:self];
    [idTextField setKeyboardAppearance:UIKeyboardAppearanceDefault];
    [idTextField setAutocapitalizationType:UITextAutocapitalizationTypeAllCharacters];
    [idTextField setBorderStyle:UITextBorderStyleRoundedRect];
    [idTextField setTextAlignment:NSTextAlignmentLeft];
    [idTextField setEnabled:YES];
    [idTextField addNumericAccessory:NO];
    [idTextField setPlaceholder:@"  아이디"];
    [self.view addSubview:idTextField];
    
    NSString *savedid = [ComUtil getString:LOGIN_ID_SESSION basic:@""];
    [idTextField setText:savedid];
    
    idPassowrdField = [[UITextField alloc] initWithFrame:CGRectMake(padding, CGRectGetMaxY(idTextField.frame) + padding, CGRectGetWidth(idTextField.frame), CGRectGetHeight(idTextField.frame))];
    [idPassowrdField setTextAlignment:NSTextAlignmentLeft];
    [idPassowrdField setEnabled:YES];
    [idPassowrdField setPlaceholder:@"  비밀번호"];
    [idPassowrdField setBorderStyle:UITextBorderStyleRoundedRect];
    [idPassowrdField setDelegate:self];
    [idPassowrdField setTag:1];
    [idPassowrdField setSecureTextEntry:YES];
    [idPassowrdField addNumericAccessory:NO];
    [self.view addSubview:idPassowrdField];
    

    
    certPwdTextField = [[UITextField alloc] initWithFrame:CGRectMake(padding, CGRectGetMaxY(idPassowrdField.frame) + padding, CGRectGetWidth(idPassowrdField.frame), CGRectGetHeight(idPassowrdField.frame))];
    [certPwdTextField setPlaceholder:@"  공동인증 비밀번호"];
    [certPwdTextField setBorderStyle:UITextBorderStyleRoundedRect];
    [certPwdTextField setDelegate:self];
    [certPwdTextField setTag:2];
    [certPwdTextField setSecureTextEntry:YES];
    [certPwdTextField addNumericAccessory:NO];
    [self.view addSubview:certPwdTextField];
    
    ComboBox *box = [[ComboBox alloc] initWithFrame:CGRectMake(padding, CGRectGetMaxY(certPwdTextField.frame) + padding, CGRectGetWidth(certPwdTextField.frame), CGRectGetHeight(certPwdTextField.frame))];
    [box setComboDelegate:self];
    [box setPlaceHolder:@"공동인증서 선택"];
    [box setKeys:[self getCertDNList] title:[self getCertUserList]];
    [self.view addSubview:box];
    certDN = [box getSelectkey];
//    UIButton *certlistBtn = [[UIButton alloc] initWithFrame:CGRectMake(padding, CGRectGetMaxY(certPwdTextField.frame) + padding, CGRectGetWidth(certPwdTextField.frame), CGRectGetHeight(certPwdTextField.frame))];
//    [self.view addSubview:certlistBtn];
//    [certlistBtn addTarget:self action:@selector(certListPopup:) forControlEvents:UIControlEventTouchUpInside];
//    [ComUtil setTitleInButton:certlistBtn title:@"공동인증서 선택"];
//    [ComUtil setColorInButton:certlistBtn color:[UIColor grayColor]];
//    [Util makeRoundView:certlistBtn radius:5 width:1 bordercolor:[UIColor systemBlueColor]];
    
    checkBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [checkBtn setFrame:CGRectMake(padding, CGRectGetMaxY(box.frame) + 10, CGRectGetWidth(box.frame), CGRectGetHeight(certPwdTextField.frame))];
    UIImage *imageCheckN = [UIImage imageNamed:@"btn_list_check_n.png"];
    UIImage *imageCheckO = [UIImage imageNamed:@"btn_list_check_o.png"];
    CGSize imageSize = CGSizeMake(imageCheckN.size.width / 3, imageCheckN.size.height /3 );
    UIImageView *imageView = [[UIImageView alloc] initWithFrame:CGRectMake(100, (CGRectGetHeight(checkBtn.frame) - imageSize.height) / 2, imageSize.width, imageSize.height)];
    [imageView setImage:imageCheckN];
    [imageView setHighlightedImage:imageCheckO];
    [imageView setTag:1];
    [imageView setHighlighted:isCertLogin];
    [checkBtn addSubview:imageView];
    [ComUtil setTitleInButton:checkBtn title:@"인증서 로그인"];
    [ComUtil setColorInButton:checkBtn color:[UIColor systemRedColor]];
    [checkBtn setTitleColor:[UIColor lightGrayColor] forState:UIControlStateNormal];
    [checkBtn addTarget:self action:@selector(onCheckButton:) forControlEvents:UIControlEventTouchUpInside];
    [checkBtn setSelected:isCertLogin];
    [self.view addSubview:checkBtn];
    
    UIButton *loginBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.view addSubview:loginBtn];
    [loginBtn setFrame:CGRectMake(padding, CGRectGetMaxY(checkBtn.frame) + 20, CGRectGetWidth(certPwdTextField.frame), CGRectGetHeight(certPwdTextField.frame))];
    [ComUtil setTitleInButton:loginBtn title:@"로그인"];
    [ComUtil setColorInButton:loginBtn color:[UIColor systemBlueColor]];
    [Util makeRoundView:loginBtn radius:5 width:1 bordercolor:[UIColor systemBlueColor]];
    [loginBtn addTarget:self action:@selector(onTouchUpInsideLoginBtn:)
       forControlEvents:UIControlEventTouchUpInside];
    
    corpbox = [[ComboBox alloc] initWithFrame:CGRectMake(padding, CGRectGetMaxY(loginBtn.frame) + 10, CGRectGetWidth(loginBtn.frame), CGRectGetHeight(loginBtn.frame))];
    NSArray *arrayKey = [NSArray arrayWithObjects:@"010", @"020" , nil];
    [corpbox setKeys:arrayKey title:[NSArray arrayWithObjects:@"개인고객", @"제휴사" , nil]];
    [self.view addSubview:corpbox];
    
    NSString *sKey = [ComUtil getString:@"CORP_CODE" basic:@"010"];
    [corpbox setSelectIndex:[arrayKey indexOfObject:sKey]];
    
    [[SmartChampAPI instance] setOpenAPICorpCode:sKey];
    
    UIButton *copyCert = [UIButton buttonWithType:UIButtonTypeCustom];
    [copyCert setFrame:CGRectMake(padding, CGRectGetMaxY(corpbox.frame) + 10, CGRectGetWidth(corpbox.frame), CGRectGetHeight(corpbox.frame))];
    [copyCert.titleLabel setFont:[UIFont fontWithName:@"HelveticaNeue-Light" size:16]];
    [ComUtil setTitleInButton:copyCert title:@"공동 인증서 가져오기"];
    [ComUtil setColorInButton:copyCert color:[UIColor blackColor]];
    [Util makeRoundView:copyCert radius:5 width:2 bordercolor:[UIColor systemGrayColor]];
    [copyCert addTarget:self action:@selector(onCopyCertInButton:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:copyCert];
    
    UIButton *btnCopy = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    [btnCopy.titleLabel setFont:[UIFont fontWithName:@"HelveticaNeue-Light" size:16]];
    [ComUtil setTitleInButton:btnCopy title:@"공동 인증서 내보내기"];
    [ComUtil setColorInButton:btnCopy color:[UIColor blackColor]];
    [btnCopy setFrame:CGRectMake(padding, CGRectGetMaxY(copyCert.frame) + 10, CGRectGetWidth(copyCert.frame) , CGRectGetHeight(copyCert.frame))];
    [btnCopy addTarget:self action:@selector(copyExportInButton:) forControlEvents:UIControlEventTouchUpInside];
    [Util makeRoundView:btnCopy radius:5 width:2 bordercolor:[UIColor systemGrayColor]];
    [self.view addSubview:btnCopy];
    
    isRealServer = [[ComUtil getString:@"common.real.server" basic:@"0"] boolValue];
    
    checkServerBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [checkServerBtn setFrame:CGRectMake(padding, CGRectGetMaxY(btnCopy.frame) + 10, CGRectGetWidth(box.frame), CGRectGetHeight(certPwdTextField.frame))];

    UIImageView *imageView2 = [[UIImageView alloc] initWithFrame:CGRectMake(100, (CGRectGetHeight(checkBtn.frame) - imageSize.height) / 2, imageSize.width, imageSize.height)];
    [imageView2 setImage:imageCheckN];
    [imageView2 setHighlightedImage:imageCheckO];
    [imageView2 setTag:1];
    [imageView2 setHighlighted:isRealServer];
    [checkServerBtn addSubview:imageView2];
    [ComUtil setTitleInButton:checkServerBtn title:@"운영 서버"];
    [ComUtil setColorInButton:checkServerBtn color:[UIColor systemRedColor]];
    [checkServerBtn setTitleColor:[UIColor lightGrayColor] forState:UIControlStateNormal];
    [checkServerBtn addTarget:self action:@selector(onCheckServerButton:) forControlEvents:UIControlEventTouchUpInside];
    [checkServerBtn setSelected:isRealServer];
    [self.view addSubview:checkServerBtn];
    
    
    [self enableCertLogoin];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(noti:) name:@"selectcertlist" object:nil];
    [self makeCloseButton];
}

- (void)makeCloseButton
{
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    [button setFrame:CGRectMake(CGRectGetWidth(self.view.frame) - 50 , 15, 35, 35)];
    [button addTarget:self action:@selector(onCloseButton:) forControlEvents:UIControlEventTouchUpInside];
    UIImage *image = [UIImage imageNamed:@"ic_floating_close_48.png"];
    [button setImage:image forState:UIControlStateNormal];
    [button setImage:image forState:UIControlStateHighlighted];
    [self.view addSubview:button];
}

- (void)onCloseButton:(UIButton*)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    if (textField == idTextField){
        NSRange lowercaseCharRange = [string rangeOfCharacterFromSet:[NSCharacterSet lowercaseLetterCharacterSet]];
        
        if (lowercaseCharRange.location != NSNotFound) {
            textField.text = [textField.text stringByReplacingCharactersInRange:range
                                                                     withString:[string uppercaseString]];
            return NO;
        }
    }
    return YES;
}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:@"selectcertlist" object:nil];
}

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField
{
//    if ( textField == idPassowrdField || textField == certPwdTextField){
//        [self showNFillter:textField];
//        return NO;
//    }
    return YES;
}

- (void)showNFillter:(UITextField*)textField
{
//    keyboardController = [[NFilterChar alloc] initWithNibName:@"NFilterChar" bundle:nil];
//    keyboardController.useInitialVector = YES;
//
//    [keyboardController setCallbackMethod:self
//                    methodOnConfirm:@selector(onConfirmNFilter:encText:dummyText:tagName:)
//                       methodOnPrev:@selector(onPrevNFilter:encText:dummyText:tagName:)
//                       methodOnNext:@selector(onNextNFilter:encText:dummyText:tagName:)
//                      methodOnPress:@selector(onPressNFilter:encText:dummyText:tagName:)
//                  methodOnReArrange:@selector(onReArrangeNFilter)
//     ];
//
//    [keyboardController setTopBarText:@"유진투자증권"];
//    [keyboardController setTagName:textField.placeholder];
//    [keyboardController setNoPadding:NO];
//    [keyboardController setNoSound:YES];
//    [keyboardController setSupportBackgroundEvent:YES];
//    [keyboardController setSupportViewRotatation:NO];
//    [keyboardController setMasking:NFilterMaskingDefault];
//    [keyboardController setAttachType:NFilterAttachViewController];
//    [keyboardController setShowHanguleText:YES];
//    [keyboardController setNFilterHeight:250];
//    [keyboardController setSupportBackGroundClose:NO];
//    [keyboardController setDeepSecMode:NO];
//    keyboardController.fontBigChar = [UIFont systemFontOfSize:20];
//    keyboardController.fontSmallChar = [UIFont systemFontOfSize:16];
//
////        [keyboardController setUseSpeakerInVoiceOver:YES];          // 구버전에선 이거
//    [keyboardController setUseVoiceOverViaSpreaker:YES];      // 새버전에선 이거
//    //-
//
//
//    if (textField == idPassowrdField){
//        [keyboardController setTitleText:@"아이디 비밀번호"];
//    }else if (textField == certPwdTextField){
//        [keyboardController setTitleText:@"공동인증 비밀번호"];
//    }
//    [keyboardController setLengthWithTagName:textField.placeholder length:50];    // NFilter Library 변경
//    [keyboardController setFullMode:YES];
////        [keyboardController setSupportBackGroundClose:YES];
////        [keyboardController setToolBar:NO];       // NFilter Library 막음
//
//    [keyboardController setServerPublickey:[[SmartChampAPI instance] getSecKeyPublicKey]];
//
//    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7) {
//        [keyboardController setVerticalFrame:0];
//    } else {
//        [keyboardController setVerticalFrame:20];
//    }
//
//    [keyboardController showKeypad:[UIApplication sharedApplication].statusBarOrientation parentViewController:self];
}

- (NSArray*)getCertDNList{
    NSArray *array = [[SmartChampAPI instance] getUserCertList];
    
    NSMutableArray *arrayCert = [NSMutableArray array];
    for ( NSInteger i = 0 ; i < [array count] ; i++){
        NSString *sCert = array[i];
        
        NSArray *arrayCertInfo = [sCert componentsSeparatedByString:@":"];
//        NSString *sCertName = arrayCertInfo[0]; // 사용자 명
        NSString *sCertDN = arrayCertInfo[1]; // 사용자 DN
//        NSString *sUse =  arrayCertInfo[2]; // 용도 /구분
//        NSString *sIssue = arrayCertInfo[3]; // 발급자명
//        NSString *sIssueDN = arrayCertInfo[4]; // 발급자 DN
//        NSString *sExpire = arrayCertInfo[5]; // 만료여부
//        NSString *sExpireDate = arrayCertInfo[6]; // 만요일
//        NSString *sseries =  arrayCertInfo[7]; // 인증서 일련번호
        [arrayCert addObject:sCertDN];
    }
    
    return arrayCert;
}

- (NSArray*)getCertUserList{
    NSArray *array = [[SmartChampAPI instance] getUserCertList];
    
    NSMutableArray *arrayCert = [NSMutableArray array];
    for ( NSInteger i = 0 ; i < [array count] ; i++){
        NSString *sCert = array[i];
        
        NSArray *arrayCertInfo = [sCert componentsSeparatedByString:@":"];
        NSString *sCertName = arrayCertInfo[0]; // 사용자 명
//        NSString *sCertDN = arrayCertInfo[1]; // 사용자 DN
//        NSString *sUse =  arrayCertInfo[2]; // 용도 /구분
//        NSString *sIssue = arrayCertInfo[3]; // 발급자명
//        NSString *sIssueDN = arrayCertInfo[4]; // 발급자 DN
//        NSString *sExpire = arrayCertInfo[5]; // 만료여부
//        NSString *sExpireDate = arrayCertInfo[6]; // 만요일
//        NSString *sseries =  arrayCertInfo[7]; // 인증서 일련번호
        [arrayCert addObject:sCertName];
    }
    
    return arrayCert;
}

- (void)onTouchUpInsideLoginBtn:(UIButton*)btn  
{
    if( !isCertLogin && [ComUtil isTextEmpty:idTextField.text] ){
        [[iToast instance] showText:@"아이디를 확인하세요." duration:iToastDurationLong gravity:iToastGravityBottom];
        return;
    }
    else if(!isCertLogin && [ComUtil isTextEmpty:idPassowrdField.text])
    {
        [[iToast instance] showText:@"비밀번호를 확인하세요." duration:iToastDurationLong gravity:iToastGravityBottom];
        return;
    }
    else if(isCertLogin && certDN == nil)
    {
        [[iToast instance] showText:@"공동인증서를 선택하세요." duration:iToastDurationLong gravity:iToastGravityBottom];
        return;
    }
    else if(isCertLogin && [ComUtil isTextEmpty:certPwdTextField.text] )
    {
        [[iToast instance] showText:@"공동인증서 비밀번호를 확인하세요." duration:iToastDurationLong gravity:iToastGravityBottom];
        return;
    }
    
    BOOL isSiseLogin = [ComUtil isTextEmpty:certPwdTextField.text];

    [[SmartChampAPI instance] setLoginDelegate:self];
        //로그인 시작
    if (isSiseLogin){
        [[SmartChampAPI instance] loginUser:idTextField.text userPassword:idPassowrdField.text certPassword:@"" corp:[corpbox getSelectkey]];
    }else if(isCertLogin){
        [[SmartChampAPI instance] loginUserWithCertDN:certDN certPassword:certPwdTextField.text corp:[corpbox getSelectkey]];
    }else{
        [[SmartChampAPI instance] loginUser:idTextField.text userPassword:idPassowrdField.text certPassword:certPwdTextField.text corp:[corpbox getSelectkey]];
    }
}

- (void)enableCertLogoin{

    [idTextField setEnabled:!isCertLogin];
    [idPassowrdField setEnabled:!isCertLogin];
}

- (void)onCheckServerButton:(UIButton*)btn
{
    btn.selected = !btn.selected;
    
    isRealServer = btn.selected;
    UIImageView *checkImageView = (UIImageView*)[btn viewWithTag:1];
    [checkImageView setHighlighted:isRealServer];
    
    [ComUtil setString:[NSString stringWithFormat:@"%d" , isRealServer] key:@"common.real.server"];
    
    if (isRealServer){
        [[SmartChampAPI instance] setDevMode:SERVER_MODE_REAL];
    }else{
        [[SmartChampAPI instance] setDevMode:SERVER_MODE_DEV];
    }
    
    UIAlertController* alert = [UIAlertController alertControllerWithTitle:@"알림"
                                                                   message:[NSString stringWithFormat:@"앱을 재시작하시면 : %@ 서버로 접속 됩니다." , isRealServer ? @"운영" : @"테스트"]
                               preferredStyle:UIAlertControllerStyleAlert];

    UIAlertAction* defaultAction = [UIAlertAction actionWithTitle:@"종료" style:UIAlertActionStyleDefault
                                   handler:^(UIAlertAction * action) {
        exit(0);
    }];

    [alert addAction:defaultAction];
    [self presentViewController:alert animated:YES completion:nil];
    
}

- (void)onCheckButton:(UIButton*)btn
{
    btn.selected = !btn.selected;
    
    isCertLogin = btn.selected;
    
    UIImageView *checkImageView = (UIImageView*)[btn viewWithTag:1];
    [checkImageView setHighlighted:isCertLogin];
    
    [self enableCertLogoin];
}

- (void)certListPopup:(UIButton*)btn
{
    CertListViewController *certListView = [[CertListViewController alloc] initWithNibName:nil bundle:nil];
    [self presentViewController:certListView animated:YES completion:^{
            
    }];
}

-(void)onTouchCloseButton:(UIButton*)sender
{
    [self dismissViewControllerAnimated:YES completion:^{
            
    }];
}

- (void)noti:(NSNotification*)noti
{
    NSDictionary *dicInfo = [noti userInfo];
    certDN = dicInfo[@"certdn"];
    UILabel *label = [self.view viewWithTag:2];
    [label setText:certDN];
}

- (void)onCopyCertInButton:(UIButton*)btn{
    CopyCertViewController *copyCertViewController = [[CopyCertViewController alloc] initWithNibName:nil bundle:nil];
    [self presentViewController:copyCertViewController animated:YES completion:nil];
}

- (void)copyExportInButton:(UIButton*)btn{
    ExportCertViewController *exportCertViewController = [[ExportCertViewController alloc] initWithNibName:nil bundle:nil];
    [self presentViewController:exportCertViewController animated:YES completion:nil];
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

- (void)onLoginStarted
{
    NSLog(@"LoginViewController onLoginStarted");
}

/**
 *로그인 TR
 * @param isSuccess 성공여부
 * @param strErrorMsg 에레메세지
 */
- (void)onLoginResult:(BOOL)isSuccess error:(NSString*)strErrorMsg
{
    NSLog(@"onLoginResult [%d]  [%@]" , isSuccess , strErrorMsg);
    if (isSuccess){
        [self dismissViewControllerAnimated:YES completion:nil];
    }else{
        UIAlertController* alert = [UIAlertController alertControllerWithTitle:@"알림"
                                   message:strErrorMsg
                                   preferredStyle:UIAlertControllerStyleAlert];

        UIAlertAction* defaultAction = [UIAlertAction actionWithTitle:@"확인" style:UIAlertActionStyleDefault
                                       handler:^(UIAlertAction * action) {
            
        }];
        [alert addAction:defaultAction];
        [[ComUtil rootViewController] presentViewController:alert animated:YES completion:nil];
    }
}


#pragma - Combo Delegate Method
- (void)selectComboBox:(ComboBox*)box selectKey:(NSString*)key
{
    certDN = key;
}

//
//
//#pragma mark -
//#pragma mark NFilter 키패드 callback 함수
//- (void)onReArrangeNFilter
//{
//    
//}
//
///*--------------------------------------------------------------------------------------
// 엔필터 '이전' 버튼 눌렀을 때 발생하는 콜백함수
// ---------------------------------------------------------------------------------------*/
//- (void)onPrevNFilter:(NSString *)secureText encText:(NSString *)encText dummyText:(NSString *)dummyText tagName:(NSString *)tagName {
//    NSLog(@"이전버튼 눌림");
//    NSLog(@"태그: %@", tagName);
//    NSLog(@"암호문 : %@", secureText);
//    NSLog(@"더미: %@", dummyText);
//    NSLog(@"서버에 보낼 암호문: %@", encText);
//}
//
///*--------------------------------------------------------------------------------------
// 엔필터 '다음' 버튼 눌렀을 때 발생하는 콜백함수
// ---------------------------------------------------------------------------------------*/
//- (void)onNextNFilter:(NSString *)secureText encText:(NSString *)encText dummyText:(NSString *)dummyText tagName:(NSString *)tagName
//{
//    NSLog(@"다음버튼 눌림");
//    NSLog(@"태그: %@", tagName);
//    NSLog(@"암호문 : %@", secureText);
//    NSLog(@"더미: %@", dummyText);
//    NSLog(@"서버에 보낼 암호문: %@", encText);
//}
//
///*--------------------------------------------------------------------------------------
// 엔필터 '키' 버튼 눌렀을 때 발생하는 콜백함수
// ---------------------------------------------------------------------------------------*/
//- (void)onPressNFilter:(NSString *)secureText encText:(NSString *)encText dummyText:(NSString *)dummyText tagName:(NSString *)tagName
//{
//    NSLog(@"엔필터 키눌림");
//    NSLog(@"태그: %@", tagName);
//    NSLog(@"암호문 : %@", secureText);
//    NSLog(@"더미: %@", dummyText);
//    NSLog(@"서버에 보낼 암호문: %@", encText);
//    
//}
//
///*--------------------------------------------------------------------------------------
// 엔필터 '취소' 버튼 눌렀을 때 발생하는 콜백함수
// ---------------------------------------------------------------------------------------*/
//- (void)onCancelNFilter:(NSString *)secureText encText:(NSString *)encText dummyText:(NSString *)dummyText tagName:(NSString *)tagName
//{
//    NSLog(@"엔필터 닫힘 : onCancelNFilter");
//    NSLog(@"태그: %@", tagName);
//    NSLog(@"암호문 : %@", secureText);
//    NSLog(@"더미: %@", dummyText);
//    NSLog(@"서버에 보낼 암호문: %@", encText);
//    //비대면 계좌개설 2022.07 bkkim
////    m_dummylength = (int)[dummyText length];
//    //비대면 계좌개설 2022.07 bkkim
//    [self closeFilterKeyboard];
//}
//
//
///*--------------------------------------------------------------------------------------
// 엔필터 '취소' 버튼 눌렀을 때 발생하는 콜백함수
// ---------------------------------------------------------------------------------------*/
//- (void)onCancel {
//    NSLog(@"엔필터 닫힘");
//    
//    [self closeFilterKeyboard];
//}
//
///*--------------------------------------------------------------------------------------
// 엔필터 'Background Close'동작할때 발생하는 콜백 함수
// ---------------------------------------------------------------------------------------*/
//- (void)onCloseNFilter:(NSString *)secureText encText:(NSString *)encText dummyText:(NSString *)dummyText tagName:(NSString *)tagName
//{
//    NSLog(@"엔필터 닫힘 : onCloseNFilter");
//    NSLog(@"태그: %@", tagName);
//    NSLog(@"암호문 : %@", secureText);
//    NSLog(@"더미: %@", dummyText);
//    NSLog(@"서버에 보낼 암호문: %@", encText);
//}
//- (void)onConfirmNFilter:(NSString *)secureText encText:(NSString *)encText dummyText:(NSString *)dummyText tagName:(NSString *)tagName
//{
//    NSLog(@"엔필터 닫힘");
//    NSLog(@"태그: %@", tagName);
//    NSLog(@"암호문 : %@", secureText);
//    NSLog(@"더미: %@", dummyText);
//    NSLog(@"서버에 보낼 암호문: %@", encText);
//    
//    
//    int ndummylength = (int)[dummyText length];
//    
//    
//    //비대면 계좌개설 2022.07 bkkim
////    m_dummylength = ndummylength;
//    //비대면 계좌개설 2022.07 bkkim
//    if (ndummylength == 0)
//    {
//        
//    }
//    else
//    {
//        //    EccEncryptor      // 이전버전 nFilter의 NFilterNum 소스내에 평문을 암호화하는 과정이 있어서 그대로 구현함. 2017.02.03. - cory
////        NSString* sss = [[EccEncryptor sharedInstance] makeDecNoPadWithSeedkey:secureText];
//        
//        char* output = NULL;   // 복호화된 평문 결과
//        int outlen = 0; // 복호화된 평문 길이
//        [[EccEncryptor sharedInstance] makeDecNoPadWithSeedkey:secureText output:&output outlen:&outlen];
//        
//        NSString* sss = [NSString stringWithUTF8String:output];
//        NSString* encript = [self StringtoEncript:sss];
//        
//        if ([tagName isEqualToString:idPassowrdField.placeholder]){
//            sPlainIDPassword = sss;
//            sEncryptIDPassword = encript;
//            [idPassowrdField setText:sss];
//        }else if ([tagName isEqualToString:certPwdTextField.placeholder]){
//            sPlainCert = sss;
//            sEncryptCert = encript;
//            [certPwdTextField setText:sss];
//        }
//        
//        if(output)
//        {
//            for(int i=0; i<outlen; i++)
//            {
//                output[i] = 0;
//            }
//            free(output);
//            output = NULL;
//        }
//    }
//    
//    // allowCloseKeypadConfirmPressed 속성이 NO여서 키패드가 안닫힐때 내려가게하고 싶으면 아래와 같이 closeKeypad를 호출하면 키패드가 내려갑니다.
//    [self closeFilterKeyboard];
//}
//
//- (void) closeFilterKeyboard
//{
//    [keyboardController closeKeypad];
//    keyboardController = nil;
//}
//
//-(NSString*)StringtoEncript:(NSString*)data
//{
//    // 1. 서버공개키를 지정하여 클라이언트공개키와 시드키를 생성한다.
//    EccEncryptor *ec = [EccEncryptor sharedInstance];
//    NSString *refClientPublickey;
//    NSData *refSeedKey;
//    
//    [ec getSeedKeyNClientPublickeyWithServerPublickey:[[SmartChampAPI instance] getSecKeyPublicKey] ClientPublickey:&refClientPublickey SeedKey:&refSeedKey];
//    
//    //     2.1 암호화 작업 (문자형 암호화)
////    NSString *encData = [ec makeEncNoPadding:data];
//    NSString *encData = [ec makeEncNoPadding:[data dataUsingEncoding:NSUTF8StringEncoding] ];    // NFilter Library 변경
//    
//    return encData;
//}
@end
