//
//  LowerLoginViewController.m
//  EugineAPISample
//
//  Created by aaab on 2023/01/03.
//

#import "LowerLoginViewController.h"
#import "Util.h"
@interface LowerLoginViewController ()
{
    UITextField *idTextField;
    UITextField *passTextField;
}
@end

@implementation LowerLoginViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self.view setBackgroundColor:[UIColor whiteColor]];
    // Do any additional setup after loading the view.
    CGFloat selfWidth = CGRectGetWidth(self.view.frame);
    UILabel *idLebel = [[UILabel alloc] initWithFrame:CGRectMake(0, 60, selfWidth, 50)];
    [idLebel setTextAlignment:NSTextAlignmentCenter];
    [idLebel setText:@"아이디"];
    [self.view addSubview:idLebel];
    
    idTextField = [[UITextField alloc] initWithFrame:CGRectMake(60, CGRectGetMaxY(idLebel.frame), selfWidth - 60 * 2, CGRectGetHeight(idLebel.frame))];
    [self.view addSubview:idTextField];
    [Util makeRoundView:idTextField radius:5 width:1 bordercolor:[UIColor systemBlueColor]];
    
    UILabel *passLebel = [[UILabel alloc] initWithFrame:CGRectMake(0, CGRectGetMaxY(idTextField.frame), selfWidth, CGRectGetHeight(idLebel.frame))];
    [passLebel setTextAlignment:NSTextAlignmentCenter];
    [passLebel setText:@"비밀번호"];
    [self.view addSubview:passLebel];
    
    passTextField = [[UITextField alloc] initWithFrame:CGRectMake(CGRectGetMinX(idTextField.frame), CGRectGetMaxY(passLebel.frame), selfWidth - 60 * 2, CGRectGetHeight(passLebel.frame))];
    [self.view addSubview:passTextField];
    [Util makeRoundView:passTextField radius:5 width:1 bordercolor:[UIColor systemBlueColor]];
    
    UIButton *loginBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [loginBtn setFrame:CGRectMake(40, CGRectGetMaxY(passTextField.frame) + 20, selfWidth - 40 * 2, CGRectGetHeight(passLebel.frame))];
    [loginBtn setTitle:@"로그인" forState:UIControlStateNormal];
    [loginBtn setTitle:@"로그인" forState:UIControlStateSelected];
    [loginBtn setTitle:@"로그인" forState:UIControlStateHighlighted];
    [loginBtn setTitle:@"로그인" forState:UIControlStateDisabled];
    [loginBtn addTarget:self action:@selector(onTouchUpInsideLoginBtn:)
       forControlEvents:UIControlEventTouchUpInside];
    
    [Util makeRoundView:loginBtn radius:5 width:1 bordercolor:[UIColor systemBlueColor]];
    
    UIButton *closeBtn = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    [closeBtn setFrame:CGRectMake(selfWidth - 50, 44, 50, 50)];
    [closeBtn setTitle:@"닫기" forState:UIControlStateNormal];
    [closeBtn setTitle:@"닫기" forState:UIControlStateSelected];
    [closeBtn setTitle:@"닫기" forState:UIControlStateHighlighted];
    [closeBtn setTitle:@"닫기" forState:UIControlStateDisabled];
    [self.view addSubview:closeBtn];
    [closeBtn addTarget:self action:@selector(onTouchCloseButton:) forControlEvents:UIControlEventTouchUpInside];
}

- (void)onTouchUpInsideLoginBtn:(UIButton*)btn
{
    
}


-(void)onTouchCloseButton:(UIButton*)sender
{
    [self dismissViewControllerAnimated:YES completion:^{
            
    }];
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
