//
//  MutilSelectPopupView.m
//  EugineAPISample
//
//  Created by aaab on 2023/02/06.
//

#import "MutilSelectPopupView.h"
#import "ComUtil.h"

@interface MutilSelectPopupView() < UITableViewDelegate , UITableViewDataSource >
{
    NSArray *arrayTitle;
    NSMutableArray *arraySelected;
    
    UITableView *selectTableView;
    
    id<IMultiSelectDelegate> m_delegate;
}
@end

@implementation MutilSelectPopupView

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self){
        [self setFrame:[[UIScreen mainScreen] bounds]];
        [self setBackgroundColor:[[UIColor blackColor] colorWithAlphaComponent:0.4]];
        [self initLayout];
    }
    return self;
}

- (void)initLayout
{
    CGFloat xPos = 40;
    CGFloat yPos = 80;
    CGFloat width = CGRectGetWidth(self.frame) - xPos * 2;
    CGFloat height = CGRectGetHeight(self.frame) - yPos * 3;
    CGRect backViewRect = CGRectMake(xPos, yPos, width, height);
    
    UIView *backView = [[UIView alloc] initWithFrame:backViewRect];
    [backView setBackgroundColor:[UIColor whiteColor]];
    [self addSubview:backView];
    
    selectTableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 0, width, height - 60)];
    [selectTableView setDelegate:self];
    [selectTableView setDataSource:self];
    [backView addSubview:selectTableView];
    
    CGFloat xPadding = 20;
    CGFloat yPadding = 10;
    CGFloat btnWidth = (CGRectGetWidth(backView.frame) - (xPadding * 2) - (xPadding / 2)) / 2;
    UIButton *cancelBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [cancelBtn setFrame:CGRectMake(xPadding, CGRectGetMaxY(selectTableView.frame) + yPadding, btnWidth, 40)];
    [cancelBtn setBackgroundColor:[UIColor lightGrayColor]];
    [ComUtil setColorInButton:cancelBtn color:[UIColor whiteColor]];
    [ComUtil setTitleInButton:cancelBtn title:@"닫기"];
    [cancelBtn addTarget:self action:@selector(onCancelButton:) forControlEvents:UIControlEventTouchUpInside];
    [backView addSubview:cancelBtn];
    
    UIButton *selectBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [selectBtn setFrame:CGRectMake(CGRectGetMaxX(cancelBtn.frame) + 10 , CGRectGetMinY(cancelBtn.frame), CGRectGetWidth(cancelBtn.frame) , CGRectGetHeight(cancelBtn.frame))];
    [ComUtil setColorInButton:selectBtn color:[UIColor whiteColor]];
    [ComUtil setTitleInButton:selectBtn title:@"선택"];
    [selectBtn setBackgroundColor:[UIColor systemBlueColor]];
    [selectBtn addTarget:self action:@selector(onSelectButton:) forControlEvents:UIControlEventTouchUpInside];
    [backView addSubview:selectBtn];
}

- (void)setDelegate:(id<IMultiSelectDelegate>)delegate
{
    m_delegate = delegate;
}

- (void)onCancelButton:(UIButton*)sender
{
    [m_delegate popupCancel];
    
    [self removeFromSuperview];
}

- (void)onSelectButton:(UIButton*)sender
{
    [m_delegate popupSelectItem:arraySelected];
    
    [self removeFromSuperview];
}

- (void)setTitles:(NSArray*)titles select:(NSArray*)select
{
    arrayTitle = [NSArray arrayWithArray:titles];
    arraySelected = [NSMutableArray arrayWithArray:select];
    if (selectTableView != nil){
        [selectTableView reloadData];
    }
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    if (arrayTitle == nil) return 0;
    
    return [arrayTitle count];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"Cell";
    
    UIImageView *selectImage = nil;
    UILabel *namelabel = nil;
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier];
        
        selectImage = [[UIImageView alloc] initWithFrame:CGRectMake(20, 0, 30, 30)];
        [selectImage setTag:1];
        [cell.contentView addSubview:selectImage];
        [selectImage setHighlightedImage:[UIImage imageNamed:@"ico_checkselected_n.png"]];
        [selectImage setImage:[UIImage imageNamed:@"ico_check_n.png"]];
        
        namelabel = [[UILabel alloc] initWithFrame:CGRectMake(CGRectGetMaxX(selectImage.frame) + 20, 0, CGRectGetWidth(cell.frame) - CGRectGetMaxX(selectImage.frame), CGRectGetHeight(cell.frame))];
        [namelabel setTag:2];
        [cell.contentView addSubview:namelabel];
        [namelabel setFont:[UIFont fontWithName:@"HelveticaNeue-Bold" size:16]];
    }
    
    if (selectImage == nil){
        selectImage = [cell.contentView viewWithTag:1];
    }
    
    if (namelabel == nil){
        namelabel = [cell.contentView viewWithTag:2];
    }
    
    NSString *sSelect = arraySelected[indexPath.row];
    if ([sSelect boolValue]){
        [selectImage setHighlighted:YES];
    }else{
        [selectImage setHighlighted:NO];
    }
    
    [namelabel setText:arrayTitle[indexPath.row]];
    
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    arraySelected[indexPath.row] = @"1";
}
- (void)tableView:(UITableView *)tableView didDeselectRowAtIndexPath:(NSIndexPath *)indexPath
{
    arraySelected[indexPath.row] = @"0";
}

@end
