//
//  StockListViewController.m
//  EugineAPISample
//
//  Created by aaab on 2023/01/24.
//

#import "StockListViewController.h"
#import "SmartChampAPI.h"
#import "IStructItemCode.h"
#import "SearchUtil.h"
#import "ComUtil.h"
#import "UITextField+Addition.h"

@interface StockListViewController () < UITableViewDelegate , UITableViewDataSource , UITextFieldDelegate >
{
    SmartChampAPI *champAPI;
    NSArray     *arrayStockItem;
    NSMutableArray *arraySearchedStockItem;
    NSString    *sSearchText;
    UITableView *itemTableView;
}
@end

@implementation StockListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self.view setBackgroundColor:[UIColor whiteColor]];
    UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(20, 20, CGRectGetWidth(self.view.frame) - 40, 40)];
    [textField setDelegate:self];
    [textField setClearButtonMode:UITextFieldViewModeWhileEditing];
    [textField setAutocorrectionType:UITextAutocorrectionTypeNo];
    [textField setAutocapitalizationType:UITextAutocapitalizationTypeNone];
    [textField setReturnKeyType:UIReturnKeySearch];
    [textField addNumericAccessory:NO];
    [ComUtil makeRoundView:textField radius:4 width:1 bordercolor:[UIColor lightGrayColor]];
    [textField addTarget:self action:@selector(onChangedValue:) forControlEvents:UIControlEventEditingChanged];
    [self.view addSubview:textField];
    
    CGRect tableRect = CGRectMake(0, CGRectGetMaxY(textField.frame) + 20, CGRectGetWidth(self.view.frame), CGRectGetHeight(self.view.frame) - CGRectGetMaxY(textField.frame) - 20);
    itemTableView = [[UITableView alloc] initWithFrame:tableRect style:UITableViewStylePlain];
    
    [self.view addSubview:itemTableView];
    [itemTableView setDataSource:self];
    [itemTableView setDelegate:self];
    
    champAPI = [[SmartChampAPI alloc] init];
    
    arrayStockItem = [NSArray arrayWithArray:[champAPI getStockCodeList]];
    arraySearchedStockItem = [NSMutableArray arrayWithArray:arrayStockItem];
    
    [self makeCloseButton];
}


- (void)makeCloseButton
{
    
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    [button setFrame:CGRectMake(CGRectGetWidth(self.view.frame) - 50 , 15, 35, 35)];
    [button addTarget:self action:@selector(onCloseButton:) forControlEvents:UIControlEventTouchUpInside];
    UIImage *image = [UIImage imageNamed:@"ic_floating_close_48.png"];
    [button setImage:image forState:UIControlStateNormal];
    [button setImage:image forState:UIControlStateHighlighted];
    [self.view addSubview:button];
}

- (void)onCloseButton:(UIButton*)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}


- (void)dealloc
{
    champAPI = nil;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

- (void)onChangedValue:(UITextField*)sender
{
    [self searchItem:sender.text];
}

- (void)searchItem:(NSString*)searchText
{
    sSearchText = searchText;
    
//    if (nItemSearchType == SEARCH_TYPE_ELW || nItemSearchType == SEARCH_TYPE_ETF || nItemSearchType == SEARCH_TYPE_ETN) {
//        if (searchText != nil && [searchText length] > 0) {
//            [self defalutAllFillter];
//        }
//    }

    NSMutableArray *arraySearchedItem = nil;
    NSArray *arrayFilltered = arrayStockItem;
    
    if (![searchText isEqualToString:@""] && searchText != nil)
        arrayStockItem = [NSArray arrayWithArray:arrayStockItem];
    
    if (searchText == nil || [searchText length] == 0) {
        arraySearchedItem = [NSMutableArray arrayWithArray:arrayFilltered];
        [itemTableView reloadData];
        return;
    }

    [arraySearchedStockItem removeAllObjects];
    arraySearchedStockItem = [NSMutableArray arrayWithArray:[SearchUtil searchTextFromArray:searchText sourceArray:arrayFilltered propertyname:@"name|||code" middleWord:NO]];
    
    [itemTableView reloadData];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    if (arraySearchedStockItem == nil) return 0;
    
    return [arraySearchedStockItem count];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"Cell";
    
    UILabel *codelabel = nil;
    UILabel *namelabel = nil;
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier];
        
        
        codelabel = [[UILabel alloc] initWithFrame:CGRectMake(20, 0, 100, CGRectGetHeight(cell.frame))];
        [codelabel setTag:1];
        [cell.contentView addSubview:codelabel];
        [codelabel setFont:[UIFont fontWithName:@"HelveticaNeue-Medium" size:16]];
        
        namelabel = [[UILabel alloc] initWithFrame:CGRectMake(CGRectGetMaxX(codelabel.frame), 0, CGRectGetWidth(cell.frame) - CGRectGetMaxX(codelabel.frame), CGRectGetHeight(cell.frame))];
        [namelabel setTag:2];
        [cell.contentView addSubview:namelabel];
        [namelabel setFont:[UIFont fontWithName:@"HelveticaNeue-Bold" size:16]];
    }
    
    if (codelabel == nil){
        codelabel = [cell.contentView viewWithTag:1];
    }
    
    if (namelabel == nil){
        namelabel = [cell.contentView viewWithTag:2];
    }
    
    
    id <IStructItemCode> item = (id <IStructItemCode>)[arraySearchedStockItem objectAtIndex:indexPath.row];
    
    [codelabel setText:[item getCode]];
    [namelabel setText:[item getName]];
    
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    id <IStructItemCode> item = (id <IStructItemCode>)[arraySearchedStockItem objectAtIndex:indexPath.row];
    
    [[NSNotificationCenter defaultCenter] postNotificationName:@"notiSearchStockItem" object:item];
    
    [self dismissViewControllerAnimated:YES completion:^{
        
    }];
}

@end
