//
//  TRTestViewController.m
//  EugineAPISample
//
//  Created by aaab on 2023/02/08.
//

#import "TRTestViewController.h"
#import "SmartChampReal.h"
#import "SmartChampTran.h"
#import "UITextField+Addition.h"

@interface TRTestViewController ()
{
    SmartChampReal *tranReal;
    SmartChampTran *tranNormal;
    CGFloat xPadding;
    CGFloat yPadding;
    CGFloat control_height;
}
@end

@implementation TRTestViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    xPadding = 20;
    yPadding = 10;
    control_height = 30;
    CGFloat yPos = 0;
    if ( tranNormal != nil){
        yPos = [self makeInputFieldLayout:20];
    }
    
}
//initWithNibName:nil bundle:nil];
- (instancetype)initWithTRname:(NSString*)trName real:(BOOL)real
{
    self = [super initWithNibName:nil bundle:nil];
    if (self){
        if (real){
            tranReal = [[SmartChampReal alloc] initWithTrCode:trName delegate:self];
        }else{
            tranNormal = [[SmartChampTran alloc] initWithTrCode:trName delegate:self];
        }
    }
    return self;
}

- (CGFloat)makeInputFieldLayout:(CGFloat)yPos;
{
    NSArray *array = [tranNormal getInputBlockNames];
    CGFloat width = (CGRectGetWidth(self.view.frame) - xPadding * 2) / 3;
    
    
    
    for ( NSInteger i = 0 ; i < [array count] ; i++){
        NSString *sBlockName = array[i];
        
        UILabel *inputLabel = [[UILabel alloc] initWithFrame:CGRectMake(xPadding, yPos, width, control_height)];
        [inputLabel setText:sBlockName];
        [inputLabel setFont:[UIFont fontWithName:@"HelveticaNeue-Bold" size:16]];
        [self.view addSubview:inputLabel];
        yPos += (control_height + yPadding);
        NSArray *arrayFieldName = [tranNormal getFieldNames:sBlockName];
        
        for (NSInteger j = 0 ; j < [arrayFieldName count] ; j++) {
            NSString *sFieldName = arrayFieldName[j];
            if (![tranNormal isOccursBlock:sBlockName])
            {
                BOOL isEncrypt = [tranNormal isEncryptField:sBlockName fieldID:sFieldName];
                BOOL isAccount = [tranNormal isAccountNoField:sBlockName fieldID:sFieldName];
                BOOL isItemCoe = [tranNormal isItemCodeField:sBlockName fieldID:sFieldName];
                NSString *fieldName = [tranNormal getFieldName:sBlockName fieldID:sFieldName];
                UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(xPadding, yPos, width, control_height)];
                if (isEncrypt){
                    [textField setSecureTextEntry:isEncrypt];
                }
                [textField addNumericAccessory:YES];
                [textField setPlaceholder:fieldName];
                [self.view addSubview:textField];
                
                UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(CGRectGetMaxX(textField.frame), yPos, CGRectGetWidth(self.view.frame) - CGRectGetMaxX(textField.frame) - xPadding , control_height)];
                [label setTextAlignment:NSTextAlignmentLeft];
                [label setText:fieldName];
                [self.view addSubview:label];
                
            }
            
            yPos += (control_height + yPadding);
        }
        
    }
    
    return yPos;
}

@end
