//
//  ComUtil.h
//  NetAPIFramework
//
//  Created by aaab on 2022/12/20.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

// 아이디 저장여부
#define LOGIN_ID_SAVE           @"login.input.saveid"
// 로그인 아이디
#define LOGIN_ID_SESSION        @"login.session.userid"                    // 암호화 처리된 버전
#define LOGIN_CIF               @"login.session.cif"                        // 고객식별번호
#define LOGIN_PWD_SESSION       @"login.session.userpwd"                        // 고객식별번호
#define LOGIN_CERT_DN           @"login.cert.dn"                            // 공동인증서 DN
#define LOGIN_CERT_PWD_AES      @"login.cert.pwd.aes"                            // 공인인증 비밀번호(AES)
#define LOGIN_PWD_CHANGE_DATE   @"login.pwd.date"                            // 조회전용 자동로그인시 서버에 전송키위해 저장.
#define LOGIN_PWD_CHANGE_TIME   @"login.pwd.time"                            // 조회전용 자동로그인시 서버에 전송키위해 저장.


@interface ComUtil : NSObject

+ (NSString *) GetIPAddress;
+ (NSString *) GetMACAddress;
+ (unsigned long) getTickCountSeconds;
+ (NSString*)getSessionUserId;
+ (void)setSessionUserID:(NSString*)userID;
+ (void)setSessionUserPwdAES:(NSString*)pwd;
+ (NSString*)getSessionUserPwdAES;
+ (void)setCertDN:(NSString*)strDN;
+ (NSString*)getCertDN;
+ (void)setCertPasswordAES:(NSString*)strPwd;
+ (NSString *) getString:(NSString *)key basic:(NSString *)basic;
+ (void) setString:(NSString *)value key:(NSString *)key;

+ (NSString*) getIPFromUrl:(NSString*)strUrl;
+ (NSString*)trim:(NSString*)target;
+ (void) makeRoundView:(UIView *)window radius:(CGFloat)radius width:(CGFloat)width bordercolor:(UIColor *)bordercolor;
+ (UIViewController*)rootViewController;
+ (BOOL)isTextEmpty:(NSString*)text;
+ (NSDictionary*)makeFontAttrDictionary:(nullable UIFont*)font fontColor:(nullable UIColor*)color underLine:(BOOL)underLine letterSpace:(CGFloat)letterSpace paragraph:(nullable NSParagraphStyle*)paragraph;
+ (NSParagraphStyle*)makeParagraphStyle:(nullable NSMutableParagraphStyle*)paragraphStyle lineBreakMode:(NSLineBreakMode)lineBreakMode alignment:(NSTextAlignment)alignment lineSpacing:(CGFloat)lineSpacing;
+ (CGSize)getScreenSize;
+ (void)setTitleInButton:(UIButton*)btn title:(NSString*)title;
+ (void)setColorInButton:(UIButton*)btn color:(UIColor*)color;
+ (NSString*)fillSpace:(NSString*)target length:(NSInteger)length;
+ (BOOL) isAlphaNum:(unichar)ch;
@end

NS_ASSUME_NONNULL_END
