//
//  OpenAPIBase.h
//  NetAPI
//
//  Created by aaab on 2023/01/11.
//

#import <Foundation/Foundation.h>
#import "INetInitDelegate.h"
#import "INetLoginDelegate.h"
#import "IAccountPwdCheckDelegate.h"
#import "LoginDataInfo.h"

NS_ASSUME_NONNULL_BEGIN

@interface OpenAPIBase : NSObject


- (void)setDevMode:(NSString*)mode;
- (void)setInitMode:(BOOL)mode;
- (BOOL)isInitMode;


/**
 *  InitListener 초기화
 *  param listener
 */
- (void)setInitDelegate:( id<INetInitDelegate>)delegate;

/**
 * LoginListener 초기화
 * param listener
 */
- (void)setLoginDelegate:(id<INetLoginDelegate>)delegate;

/**
 * Logoutdelegate 초기화
 * param delegate
 */
- (void) setLogoutDelegate:(id<INetLogoutDelegate>)delegate;

- (void)setOpenAPICorpCode:(NSString*)corp;

- (void)startConnect;

/**
 * 로그인 시작 (ID + ID비번 + 인증서 비번)
 * param strUserId
 * param strUserPW
 * param strCertPW
 */
- (void) startLogin:(NSString*)strUserId userPW:(NSString*)strUserPW certPW:(NSString*)strCertPW;

/**
 * 로그인 시작 (인증서 DN + 인증서 비번)
 * param strCertDN
 * param strCertPw
 */
- (void)startLogin:(NSString*)strCertDN certPW:(NSString*)strCertPw;
/**
 * 로그아웃 시작
 */
- (void) logoutUser;

- (void) checkAccPwd:(NSString*)strAccNo accPWD:(NSString*)strAccPwd delegate:(id<IAccountPwdCheckDelegate>)delegate;


#pragma -
#pragma - JobProcess Method and Delegate
/**
 *
 * Job Process Manager  초기화
 */
- (void) initProcessManager;

/**
 * 로그인 ID
 * return
 */
- (NSString*)getLoginUserID;

- (LOGIN_MODE) getLoginType;

- (void) setSCreenNo:(NSString*)strScreenNo;

- (NSString*) getItemCodeType:(NSString*)strCode;

- (NSString*) getItemFullCode:(NSString*)strCode;

- (NSString*) getItemCodeTypeName:(NSString*)strCode;

- (NSArray*) getArrayCode:(NSString*)key;

-(NSArray*)getItemCodeList:(NSString*)type;
/**
 * 코스피 종목 리스트
 * return
 */
- (NSArray*) getKospiCodeList;

/**
 * 코스닥 종목 리스트
 * return
 */
- (NSArray*)  getKosdaqCodeList;

/**
 * 코스피+코스닥 종목 리스트
 * return
 */
- (NSArray*) getSortedStockCodeList;

/**
 * 선물 종목 리스트
 * return
 */
- (NSArray*) getFuturesCodeList;

/**
 * 옵션 종목 리스트
 * return
 */
- (NSArray*) getOptionsCodeList;

/**
 * 해외주식 종목 리스트
 * return
 */
- (NSArray*) getOverseasStockCodeList;


- (NSArray*)getOverseasStockCodeList:(NSString*)nation exchange:(NSString*)exchange;
/**
 * 종목 의 정보
 * return
 */
- (NSString*) getItemCodeInfo:(NSString*)strCode type:(NSString*)type;
/**
 * 계좌리스트 갯수
 * return
 */
- (NSInteger)getAccountSize;
/**
 * 계좌번호
 * param nIndex
 * return
 */
- (NSString*)getAccountNo:(NSInteger) nIndex;

/**
 * 계좌명
 * param nIndex
 * return
 */
- (NSString*)getAccountName:(NSInteger) nIndex;

- (NSString*) getAccountInfo:(NSString*)strAccNo infoID:(NSString*)strInfoId;
- (NSInteger)getUserCertListCount;

- (NSArray*)getUserCertList;

- (NSData*) encryptData:(NSData*)szData;

- (NSData*) decryptData:(NSData*)szData;


- (NSString*) requestCertImportNumber;

- (NSString*) requestCertImport;

- (NSString*) requestCertExport:(NSString*)strCertDN certNum:(NSString*)strSimpleCertNum;

- (NSString*) requestCertDelete:(NSString*)strCertDN certPW:(NSString*)certPW;

- (BOOL)checkCertPwdDN:(NSString*)dn password:(NSString *)strPwd;

- (NSArray*)getTransactionList;

- (NSDictionary*)getOrderTRList;
- (NSDictionary*)getNormalTRList;
- (NSDictionary*)getRealTRList;
@end

NS_ASSUME_NONNULL_END
