//
//  AlarmItemChegyul.h
//  SmartVIGS
//

#import <Foundation/Foundation.h>
#import "AlarmItemBase.h"

#define 	ALARM_ORDERRECEIPT          0	// 주문접수
#define 	ALARM_CHEGYUL_STOCK         1	// 주문체결
//#define 	ALARM_STOPMIT               2	// 시세포착주문
#define 	ALARM_CHEGYUL_FUTURE        2	// 선옵주문체결
#define     ALARM_CHEGYUL_BOND          3   // 채권체결
#define     ALARM_CHEGYUL_CME           4   // cme체결
#define     ALARM_CHEGYUL_CFD           5   // CFD체결
#define     ALARM_CHEGYUL_WSTOCK        6   // 해외주식주문체결


@interface AlarmItemChegyul : AlarmItemBase
{
}

@property (nonatomic, assign) int m_nChegyulType;
@property (nonatomic, retain) NSString* m_strProcTime;					// 처리시각. UDP 처리시간표시(당사UDP 처리프로세스 처리시각)
@property (nonatomic, retain) NSString* m_strMarkSect;					// 표시구분. 1:Ticker, 2:Popup, 3:Ticker+Popup
@property (nonatomic, retain) NSString* m_strSecKindSectCd;				// 유가종류구분.
// 01:장내주식,		02:채권			03:수익증권,	04:CD
// 05:CP			06:RP			07:개탁			08:해외
// 09:선물,			10:옵션,		11:KOSDAQ,	    12:신주인수권,
// 13:프리보드,     14:개방형 뮤츄얼펀드			15:KOSDAQ50선물,
// 16:KOSDAQ옵션,	17:주식선물,	18:주식옵션,	19:CALL,
// 20:파생증권,		21:해외수익증권,22:은행예금,	23:금리선물
// 24:금리옵션,		25:해외주식, 	26:통화선물,	27:통화옵션
// 28:채권선물,		29:채권옵션,	30:상품선물,	31:상품옵션
/*---------------------------------------------------------------*/
/* 유가증권종류구분                                   2009/01/23 */
/*  - KOSPI200지수 : 선물(09), 옵션(10)                          */
/*  - 스타지수     : 선물(09)                                    */
/*  - 개별주식     : 선물(17), 옵션(18)                          */
/*  - 금리         : 선물(23), 옵션(24)                          */
/*  - 채권         : 선물(28), 옵션(29)                          */
/*  - 통화         : 선물(26), 옵션(27)                          */
/*  - 상품         : 선물(30), 옵션(31)                          */
/*---------------------------------------------------------------*/
/* 시장ID                                                        */
/*  - 주가지수파생 : SPI(KOSPI200, 스타, KOSDAQ50)               */
/*  - 주식파생     : EQU(국민은해외....)                         */
/*  - 채권파생     : BON(3년국채,5년국채,10년국채)               */
/*  - 금리파생     : IRT(CD,MSB)                                 */
/*  - 통화파생     : CUR(미국달러,엔,유로)                       */
/*  - 기타....     : AGR(금), AGR(돈육)                          */
/*---------------------------------------------------------------*/
// 32=FX Margin 33=해외선물 34=해외옵션

@property (nonatomic, retain) NSString* m_strOrdContSect;				// 주문체결구분. 1:주문자료(미통보), 2:체결자료(통보)
@property (nonatomic, retain) NSString* m_strUpdtCnclSect;				// 정정취소구분 - 1:정상, 2:정정, 3:취소, 4: IOC FOK 취소(4: IOC FOK 취소는 자료구분이 확인시만 발생)
@property (nonatomic, retain) NSString* m_strDataSect;					// 자료구분. 0:주문접수,1:체결,2:확인,3:주문전송
@property (nonatomic, retain) NSString* m_strRejtSect;					// 거부구분. 21:정상,24:거부
@property (nonatomic, retain) NSString* m_strMdptbrnCd;					// 관리부점코드. 관리점번호 (장중은 변경불가)
@property (nonatomic, retain) NSString* m_strJobTypeCd;					// 업무유형코드. 예) 021:선물, 022:위탁, 023:KSQ선물, 024:FX마진 025:해외선물
@property (nonatomic, retain) NSString* m_strCustAcntSeq;				// 고객계좌일련번호. 고객이 입력한 계좌번호 (UDP 처리시 계좌번호 사용)
@property (nonatomic, retain) NSString* m_strOrdNo;						// 주문번호. 주문번호(자릿수 변경)
@property (nonatomic, retain) NSString* m_strOrgnOrdNo;					// 원주문번호. 원주문번호(자릿수 변경)
@property (nonatomic, retain) NSString* m_strItemCd;					// 종목코드
@property (nonatomic, retain) NSString* m_strTrdSect;					// 매매구분
                                                                        // 주식 -  1:매도,2:매수  (기존의 W0T028P trade_sect COPY)
                                                                        // 선물 -  1:매도,2:매수,3:전매도,4:환매수 (현재 전환매는 없음)
@property (nonatomic, retain) NSString* m_strQty;						// 수량
@property (nonatomic, retain) NSString* m_strUprc;						// 단가
                                                                        // 선물옵션:100, 해외주식:10000 으로 나누어서 사용(해외주식단가 삭제후 단가필드에 통합)
                                                                        // FX : 소숫점포함
@property (nonatomic, retain) NSString* m_strRejtPlcSect;				// 거부처구분 - 0:정상,1:거래소,2:증권전산,3:당사
                                                                        // FX : 0.정상 1.거래소 2.OMS 3.당사
@property (nonatomic, retain) NSString* m_strRejtCd;					// 거부사유코드
@property (nonatomic, retain) NSString* m_strItemNm;					// 종목명

@property (nonatomic, retain) NSString* m_strCrdtLoanSect;				// 신용대출구분
                                                                        // [주식] - 신용구분값 변경 (필히 확인)
                                                                        // 신용구분 => '00':현금, '01':유통융자, '02':매입자금대출, '03':자기융자
                                                                        // '04':매도자금담보대출, '05':유통대주, '06':일반담보대출, '07':자기대주
                                                                        // '08':대용미수금, '09':긴용대차, '10':단기매입자금대출, '11':청약자금대출
                                                                        // : 상환은 상환구분을 사용해야 함
                                                                        // [선물] - 삭제 (해당사항 없음)
                                                                        // => 기존의 선물은 신용등급을 보냈으나 필요없은것으로 판단하여 삭제
@property (nonatomic, retain) NSString* m_strBuyDate;					// 매수일자
@property (nonatomic, retain) NSString* m_strContSeq;					// 거래소체결일련번호 (자릿수 변경)
@property (nonatomic, retain) NSString* m_strSttdCntSect;				// 결제일수구분. 결제구분값 변경 (필히 확인) ==> 결제일수구분값
                                                                        // 결제일수구분 - 0:즉시결제,1:당일결제 2:익일결제 3:3일결제 4:기타(3일결제 초과)
@property (nonatomic, retain) NSString* m_strOrdFrm;					// 주문형태. 주문형태값 변경 (필히 확인)
                                                                        // [주식] - 01: 보통        02:임의   05:시장가        06:조건부지정가
                                                                        // 09:자기주식                10:Stock-Option자기주식
                                                                        // 11:금전신탁자기주식        12:최유리지정가  13:최우선지정가
                                                                        // 임의시장가   26:임의조건부지정가
                                                                        // 72:오후시간외대량(W0T074P 변경)
                                                                        // 51:장중대량                 52:장중바스켓
                                                                        // 62:오전시간외대량           63:오전바스켓
                                                                        // 67:오전대량금전신탁자사주   69:오전대량자기주식
                                                                        // 72:오후시간외대량           77:금전신탁자기주식시간외대량
                                                                        // 79:시간외대량자기주식(970710)
                                                                        // 80:바스켓매매               99:변동없음
                                                                        // [선물] -  01 지정가, 02 시장가, 03 조건부지정가, 04 최유리지정가
                                                                        // FX마진 가격조건구분: 01.지정가 02.시장가(AT BEST), 03.시장가(RANGE), 04.STOP 05.T.STOP 06.OCO
                                                                        // 해외파생 가격조건구분: 01.지정가 02.시장가 03.STOP 04.STOP-LIMIT
@property (nonatomic, retain) NSString* m_strLoanDate;					// 대출일자
@property (nonatomic, retain) NSString* m_strOrdMktSect;				// 주문장구분. 주문장구분 값 변경 (필히 확인) ==> 시간순으로 구분값 변경
                                                                        // 1:장개시전종가 2:장중 3:시간외종가 4:시간외단일가 5:ECN
@property (nonatomic, retain) NSString* m_strContCond;					// 체결조건 - 00:지정안함, 01:IOC 02:FOK
                                                                        // FX체결조건구분: 00.일반(DAY) 01.GTC 02.GTD 03.FOK
                                                                        // 해외파생체결조건구분: 00.FAS 01.FAK 02.FOK
@property (nonatomic, retain) NSString* m_strTrDate;					// 거래일자	추가(디퍼드의 주문일자와 거래일자가 동일하므로 통합)
@property (nonatomic, retain) NSString* m_strIpAddr;					// IP 주소
@property (nonatomic, retain) NSString* m_strSysAcntNo;					// 시스템계좌번호 (Table 계좌번호)
@property (nonatomic, retain) NSString* m_strOrdSect;					// 주문구분
                                                                        // 01: 현금매도      02: 현금매수      03: 신용매도      04: 신용매수
                                                                        // 05: 저축매도      06: 저축매수      07: 채권매도      08: 채권매수
                                                                        // 09: KOSDAQ매도    10: KOSDAQ매수
                                                                        // 11:KOSDAQ저축매도 12:KOSDAQ저축매수
                                                                        // 13:프리보드매도   14:프리보드매수
                                                                        // 21:ECN매도        22:ECN매수        23:ECN대용매도
@property (nonatomic, retain) NSString* m_strContSect;					// 체결구분(1:체결, 2:정정확인, 3:취소확인, 4:거부)
@property (nonatomic, retain) NSString* m_strCrdtRmbrSect;				// 신용상환구분  ( 00:신규    01:매도상환    02:매수상환    03:현금상환    04:현물상환 )
@property (nonatomic, retain) NSString* m_strCrdtAmt;					// 신용대출금액	FX : 은행매도기준환율
@property (nonatomic, retain) NSString* m_strFutSbstTrdSect;			// 선물대용매매구분. 0:기본 1:선물대용매도 2:인수전매도 FX:반대매매구분 1.반대매매
@property (nonatomic, retain) NSString* m_strOnoffSect;					// 온오프구분. 0:오프라인 1:온라인
@property (nonatomic, retain) NSString* m_strFeeKindSect;				// 수수료종류구분. 00:Offline  01:Online  02:유무선
@property (nonatomic, retain) NSString* m_strSvcMediaSect;				// 서비스매체구분
@property (nonatomic, retain) NSString* m_strOprtrEmpNo;				// 조작자사번. 일반 고객인 경우는 사용자 ID
@property (nonatomic, retain) NSString* m_strPgmId;						// UDP 처리 프로그램ID
@property (nonatomic, retain) NSString* m_strCrdtIntgOrdSect;			// 신용통합주문구분. 0:일반주문 1:신용통합주문
@property (nonatomic, retain) NSString* m_strContTime;					// 체결시각
                                                                        // 접수 : 업무시스템주문처리시각(주문Table Insert 직전시각)
                                                                        // 접수거부 : 업무시스템확인시각 BSSYS_CONF_TIME
                                                                        // 정정확인/취소확인 : 거래소확인시각
                                                                        // 정정/취소확인거부 : 업무시스템확인시각 BSSYS_CONF_TIME
                                                                        // 체결 : 거래소체결시각
@property (nonatomic, retain) NSString* m_strPgmAsprSect;				// 프로그램호가구분
                                                                        // 상장 :	00:정상,  01:차익거래,  02:비차익거래 03:주식옵션
                                                                        //			04:ETF차익거래이면서 비차익이 아닌 경우
                                                                        //			05:ETF설정거래이면서 비차익이 아닌 경우
                                                                        //			06:ETF차익거래이면서 비차익인 경우
                                                                        //			07:ETF설정거래이면서 비차익인 경우, 08:DR차익거래
                                                                        // 코스닥 : 00:정상, 01:차익거래, 02:비차익거래,
                                                                        //			04: ETF차익거래, 05: ETF기타거래, 08:DR 차익거래
@property (nonatomic, retain) NSString* m_strFee;						// 수수료
                                                                        // 체결로 변경되는 수수료합산기준 수수료합(영업지원용, 당체결과 동일한 합삭기준 통합)
@property (nonatomic, retain) NSString* m_strBondCpstDutySect;			// 채권종합과세구분. 1:종합과세 2:분리과세 (랩에서 요청)
@property (nonatomic, retain) NSString* m_strUserDefData;				// 사용자정의데이타. Qway Header의 HUserData 앞 12byte
                                                                        // FX : [X13] 진입수수료 (청산수량에 해당하는 진입수수료)
                                                                        //      [X13] 주문가격
@property (nonatomic, retain) NSString* m_strPldgSellSect;				// 질권매도구분	0:일반주문 1:질권매도
                                                                        // 2:경쟁대량 체결(체결단가 없음) - 장개시전주문(07:30 ~ 08:30) 이나 장중(09:00 ~ 14:30) 사이에 체결가 없고 체결수량만 존재
                                                                        // 3:경쟁대량 체결(체결단가 있음) - 15:00 이후에 체결수량, 체결단가있는 체결
@property (nonatomic, retain) NSString* m_strTRMplr;					// 거래승수. 선물옵션만 사용
                                                                        // 주식 : 경쟁대량 평가가격
                                                                        // (질권매도구분 "2" 인경우 체결단가는 없고 실시간 평균단가용 체결가)
@property (nonatomic, retain) NSString* m_strMarketNo;					// 해외거래소번호
                                                                        // 0000  KRX(한국)		0012  홍콩거래소
                                                                        // 0016  상해거래소		0017  심천거래소

@property (nonatomic, retain) NSString* m_strExchange;					// 해외거래소번호
                                                                        // 001.홍콩, 006.일본, 014.중국(상해), 018.중국(심천), 020.미국
@property (nonatomic, retain) NSString* m_strClrPlAmt;					// 청산손익
@property (nonatomic, retain) NSString* m_strExprDate;					// 만기일자(FX : 주문종료일자)
@property (nonatomic, retain) NSString* m_strStopLimSect;				// STOPLIMIT구분.
                                                                        // FX: 00.일반 01.STOP 02.LIMIT 03.T.STOP 04.S/L 05.S/T.STOP 06.L/T.STOP 07.S/L/T.STOP
@property (nonatomic, retain) NSString* m_strLimPrc;					// LIMIT가격
@property (nonatomic, retain) NSString* m_strStopPrc;					// STOP가격
@property (nonatomic, retain) NSString* m_strTrailStopVal;				// TrailingSTOP값
@property (nonatomic, retain) NSString* m_strSlpgVal;					// SLIPPAGE값
@property (nonatomic, retain) NSString* m_strRebtAmt;					// 리베이트금액
@property (nonatomic, retain) NSString* m_strCrncCd;					// 통화코드. FD : 해외파생 추가항목
@property (nonatomic, retain) NSString* m_strNotaSect;					// 진법구분. FD : 해외파생 추가항목
@property (nonatomic, retain) NSString* m_strFiller;					// FILLER

@property (nonatomic, retain) NSString* m_strSoundId;


- (NSString*) getStatusText;
- (NSString*) getChegyulPrice;
- (NSString*) getChegyulCount;


@end
