//
//  ICommAPIDelegate.h
//  dongbuApiLib
//
//  Created by BerdoMac on 2014. 10. 23..
//

typedef NS_ENUM(NSInteger, ServerConnectionState)
{
    ServerStateConnecting = 0,  // 연결중
    ServerStateDisconnected,    // 연결끊김
    ServerStateConnected,       // 연결됨
    ServerStateNone,            // 기본값
    ServerStateConnectionFailed, // 연결실패
    ServerStateNotice,          // 공지 조회
    ServerStateNoticeError,     // 공지 조회 에러
};

typedef NS_ENUM(int, ServerIpType)
{
    ServerIpTypeReal1 = 1, // 실서버
    ServerIpTypeReal2,
    ServerIpTypeDeveloper, // 개발
    ServerIpTypeTest, // 이행
    ServerIpTypeNone, // 운영모드
};

typedef NS_ENUM(int, UserLoginState)
{
    UserLoginStateNone = 0,     // 로그인 안함
    UserLoginStateDefult,       // 일반로그인
    UserLoginStateAuto,         // 자동로그인
};

typedef NS_ENUM(NSInteger, LoginState)
{
    LoginStateSuccess = 0, //로그인성공
    LoginStateSuccessLibraryLowVersion, // 버전낮음 로그인 성공
    LoginStateFail, // 실패
    LoginStateTimeout, // 타임아웃
    LoginStateFailRiskDisclaimer //위험고지

};

typedef enum
{
    LoginTypeNone,         // 로그인 상태 아님.
    LoginTypeDefult,       // 일반로그인
    LoginTypeAuto,         // 자동로그인
    LoginTypeCert         // 인증서로그인(자동로그인후 인증서로그인)
    
}LoginType;

@class ConnectionManager;
@class LoginManager;
@class SmartChampTran;

@protocol ICommAPIDataMngrDelegate <NSObject>

-(void) recvEvent:(NSString*)sEventName sParam:(NSString*)sParam objParam1:(NSObject*)objParam1 objParam2:(NSObject*)objParam2;

@end

@protocol ConnectionManagerDelegate <NSObject>

@required
- (void)connectionManager:(ConnectionManager*) connectionManager didChangeState:(ServerConnectionState)state;

@end


@protocol LoginManagerDelegate <NSObject>

- (void)loginManager:(LoginManager*)loginManager state:(LoginState)state userInfo:(NSDictionary*)userInfo;
@end
