//
//  MVTranDataProc.h
//  MVigsEngine
//
//  Created by W JW on 12. 6. 20..
//  Copyright (c) 2012년 itgen. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "TBXML.h"
#import "ITranDataLink.h"

#import "BaseDataProc.h"
//#import "TranInfo.h"
//#import "UpdateDataInfo.h"


#define NORMAL_FLAG        0x00
#define ERROR_FLAG        0x01
#define CLEAR_FLAG        0x02

#define TT_TRAN             0   // Struct I/O (Request Answer)
#define TT_FEED             1   // Struct I/O (Real Data)
#define TT_HTTP_JSON        10  // Json 포맷 데이터
#define TT_HTTP_WAS         11  // Was 포맷 데이터


@class MVDataManager;
@class TranInfo;
@class RequestTranData;
@class MessageDataInfo;
@class RequestTranInfo;
@class ReqExchangeItem;
@class UpdateDataInfo;


@interface MVTranDataProc : BaseDataProc <ITranDataLink>
{
 @public
    BOOL            m_bUseAttribute;
//    BOOL            m_bBlockMode;

    BOOL        m_clearForm;
    Byte        m_ucTranType;
    Byte        m_ucWebType;
    
    RequestTranInfo *m_oInfoReq;

    char            m_ucHeaderType;
    NSArray            *m_arrConnbclist;
    NSMutableArray    *m_arrConnRDlist;
    
    NSString        *m_sMsgCode;
    NSString        *m_sMsgText;
    NSString        *m_sAddMsgCode;
    NSString        *m_sAddMsgText;

    BOOL            m_isMoreNextData;
    BOOL            m_isNextRequest;
    int             m_nRQID;        // 현재 처리 되고 있는 RQID (스크립트에서 접근하기 위한 용도로 사용됨.)
    
    NSData*         m_dataContKey;                            // /< Header에서 내려오는 연속키값. -by Berdo
    char            m_ucContFlag;                            // = Byte.parseByte(PacketHeader.PN_INIT);; ///< Header에서 내려오는 연속키 플래그 -by Berdo
    
    int             m_nRequestCount;
    
    
    BOOL            m_bDataReverse;
    char            m_cContFlg;// 2013.08.09.
    char            m_ucContYn;

}

@property (nonatomic, retain)    NSString    *m_sMsgCode;
@property (nonatomic, retain)    NSString    *m_sMsgText;
@property (nonatomic, retain)    NSString    *m_sAddMsgCode;
@property (nonatomic, retain)    NSString    *m_sAddMsgText;
@property (nonatomic, retain)   NSData      *m_dataContKey;                            // /< Header에서 내려오는 연속키값. -by Berdo

- (id)              initTranWithDataMngr    : (MVDataManager *)dataMngr;
- (void)            makeRequestInfo;
- (void)            setHeaderType        : (char)uc;
- (char)            getHeaderType;
- (void)            setTranInfo            : (TranInfo*)traninfo;
- (void)            setXmlInfo            : (TBXMLElement*)elem;
- (void)            initData;
- (int)             requestData;
- (int)             requestDataWithParam:(NSObject *)param;
- (int)             requestNextData;
- (BOOL)            updateInputData;
- (BOOL)            updateInputData        : (MVBlockDataProc*)BlockDP    dataInfo:(UpdateDataInfo*)updateinfo;
- (void)            clearOutputData        : (BOOL)bOptionCheck;
- (void)            sendDataToForm        : (MVBlockDataProc*)BlockDP    flag:(char)nflag;
- (void)            updateOutputData    : (MVBlockDataProc*)BlockDP    dataInfo:(UpdateDataInfo*)updateInfo;
- (void)            makeRDList;
- (void)            requestRealData;
- (void)            cancelRealData;
- (void)            onRequestData        : (RequestTranData*)infoData;
- (void)            onMessageData        : (MessageDataInfo*)infoData;
- (void)            onSystemError        : (MessageDataInfo*)infoData;
- (void)            onReleaseData        : (int)nRqID;
- (void)            onRequestTimeout    : (int)nRqID;
- (void)            checkNextFlag;
- (BOOL)            isMoreNextData;
- (void)            setMoreNextData        : (BOOL)bMoreNext;

- (void)            addRequestRef;
- (void)            removeRequestRef;
- (void)            removeRequestTranLink;
- (void)            setTranDataInfo:(BOOL)isCompress isEncrypt:(BOOL)isEncrypt isSign:(int)nSign;
- (void)            onSystemWarning : (MessageDataInfo*)infoData;
- (void)            constructKeyEncInfo;
- (NSString*)       getErrMsgCode;
- (NSString*)       getErrMsgText;
- (void)            setContFlg:(char)cFlg;
- (void)            processReceivedAfter:(RequestTranData*)infoData;
//- (void)            setNoAckMsgSect:(char)cFlg;
- (NSObject*)       getUserParam;
- (int)             getCurrentRqId;

- (void)            clearConnectedCtl;
// semp was등 http 통신을 위한 함수.
- (NSData*)         getHttpInputData;
- (int)             requestHttpData:(Byte) ucTranType svcType:(Byte) ucWebType;
- (void)            processHttpData:(RequestTranData*)infoData szData:(char*)szData;

- (RequestTranInfo*)getTranInfoReq;
- (void)            addPacketHeaderApext:(char) szApext;

- (void)            setReqExchangeItem:(NSString*)strItemKey ItemValue:(ReqExchangeItem*)ItemValue;
- (void) clearInputData;

- (NSData *)        GetWebSocketJsonInputData;
- (void)            ProcessWebSocketJsonData:(NSObject*)infoDataBase szData:(char*)szData;

- (NSArray*)getInputBlockNames;
- (NSArray*)getOutBlockNames;
- (NSArray*)getFieldNames:(NSString*)blockID;
- (BOOL)isOccursBlock:(NSString*)blockID;
- (BOOL)isAccountNoField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (BOOL)isEncryptField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (BOOL)isItemCodeField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (BOOL)isPasswordField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (NSString*)getFieldName:(NSString*)blockID fieldID:(NSString*)fieldID;
@end
