//
//  SmartChampAPI.h
//  NetAPI
//
//  Created by aaab on 2023/01/05.
//

#import <Foundation/Foundation.h>
#import "ICommAPIDelegate.h"
#import "OpenAPIBase.h"

NS_ASSUME_NONNULL_BEGIN

@class OpenAPIBase;

@interface SmartChampAPI : OpenAPIBase


+ (id)instance;
+ (void)releaseOpenAPI;
- (void)setDevMode:(NSString*)strDev;
- (void)startConnect;
- (LOGIN_MODE)getLoginType;
- (void) setInitDelegate:(id <INetInitDelegate>)delegate;
- (void) setLoginDelegate:(id <INetLoginDelegate>)delegate;
- (void) setLogoutDelegate:(id <INetLogoutDelegate>) delegate;
- (void)loginUser:(NSString*)userid userPassword:(NSString*)userPW certPassword:(NSString*)certPW corp:(NSString*)corp;
- (void)loginUserWithCertDN:(NSString*)certDN certPassword:(NSString*)certPW corp:(NSString*)corp;
- (void)setTranID:(NSString*)tranID;
-(NSString*)  getSecKeyPublicKey;
- (NSInteger)getAccountSize;
- (NSString*)getAccountNo:(NSInteger)nIndex;
- (NSString*)getAccountName:(NSInteger)nIndex;
- (NSString*)getAccountInfo:(NSString*)accNo infoID:(NSString*)infoId;

/**
 * 종목코드 리스트
 * @param strType 종목유형
 *       KOSPI      : 주식 - 코스피
 *       KOSDAQ      : 주식 - 코스닥
 *       STOCK      : 주식 - 코스피+코스닥
 *       CFD         : 주식 - CFD
 *       ELW         : ELW
 *       ETN         : ETN
 *       ETF         : ETF
 *       WARRANTS   : 신주인수권
 *       KONEX      : KONEX
 *       KOTC      : K-OTC
 *       K200FUT      : 지수선물
 *       K200OPT      : 지수옵션
 *       MINIFUT      : 미니선물
 *       MINIOPT      : 미니옵션
 *       WEEKLYOPT   : 위클리옵션
 *       KRX300FUT   : KRX300 선물
 *       KSD150FUT   : 코스닥150 선물
 *       KSD150OPT   : 코스닥150 옵션
 *       STKFUT      : 주식선물
 *       VFUTURE      : 변동성선물
 *       TFUTURE      : 섹터선물
 *       CME         : 야간선물
 *       BOND      : 채권
 *       UPJONG      : 업종
 *       WSTOCK      : 해외주식 - 전체
 *       WSTOCK_US   : 해외주식 - 미국
 *       WSTOCK_NY   : 해외주식 - 미국 - 뉴욕
 *       WSTOCK_NS   : 해외주식 - 미국 - 나스닥
 *       WSTOCK_AM   : 해외주식 - 미국 - 아멕스
 *       WSTOCK_CN   : 해외주식 - 중국
 *       WSTOCK_SH   : 해외주식 - 중국 - 상해
 *       WSTOCK_SZ   : 해외주식 - 중국 - 심천
 *       WSTOCK_HK   : 해외주식 - 홍콩
 *       WUPJONG      : 해외업종
 *
 * @return 종목리스트
 */
- (NSArray*) getItemCodeList:(NSString*)type;
- (NSArray*) getArrayCode:(NSString*)key;
- (NSArray*) getKospiCodeList;
- (NSArray*) getKosdaqCodeList;
- (NSArray*) getStockCodeList;
- (NSArray*) getFuturesCodeList;
- (NSArray*) getOptionsCodeList;
- (NSArray*) getOverseasStockCodeList;
- (NSArray*) getOverseasStockCodeList:(NSString*)nation exchange:(NSString*)exchange;
- (NSString*) getItemCodeType:(NSString*)code;
- (NSString*) getItemFullCode:(NSString*)code;
- (NSString*) getItemMarketTypeText:(NSString*)code;
- (NSString*) getItemCodeInfo:(NSString*)code type:(NSString*)strType;
- (NSArray*)getTransactionList;
- (BOOL)isRealTransaction:(NSString*)trName;
- (NSDictionary*)getOrderTRList;
- (NSDictionary*)getNormalTRList;
- (NSDictionary*)getRealTRList;
// 사용자 공동인증서 갯수
- (NSInteger)getUserCertListCount;
// 사용자 리스트 정보
- (NSArray*)getUserCertList;
// 인증서 가져오기 랜덤 번호 생성
- (NSString*)requestCertImportNumber;
// 인증서 가져오기
- (NSString*)importCert;
// 인증서 내보내기
- (NSString*) exportCert:(NSString*)strCertDN simpleCertNum:(NSString*)strSimpleCertNum;

- (NSString*) deleteCert:(NSString*)strCertDN certPW:(NSString*)certPW;

- (BOOL)checkCertPwdDN:(NSString*)dn password:(NSString *)strPwd;
@end

NS_ASSUME_NONNULL_END
