//
//  SmartChampReal.h
//  NetAPI
//
//  Created by aaab on 2023/01/05.
//

#import <Foundation/Foundation.h>
#import "RealDataProc.h"

NS_ASSUME_NONNULL_BEGIN

@protocol IRealDataDelegate;
@interface SmartChampReal : RealDataProc

- (id)initWithTrCode:(NSString*)trCode  delegate:(nonnull id<IRealDataDelegate>)delegate;

- (void)setQueryFile:(NSString*)strCode;

- (void)setDataHeader:(NSString*)strKey data:(NSString*)strData;

- (void)setScreenNo:(NSString*)strScreenNo;

- (void)clearInputData;

- (void)clearOutputData;

/**
 * 리얼테이타 요청
 */
- (void)requestReal;


/**
 * 리얼데이터 해지
 */

- (void)releaseReal;
/**
 *  Inblock key Date set
 * param sBlockName  : 블럭 이름
 * param sFieldName : 데이타 항목
 * param nRecIndex : 데이터 인덱스
 * param sData : 데이타
 */
- (void)setDataValue:(NSString*)block fieldID:(NSString *)fieldID index:(int)index value:(NSString *)value;

/**
 *  Get Real Attr Data
 * param sBlockName : 블럭 이름
 * param sFieldName : 데이터 항목명
 * param nRecIndex : 데이터 인덱스
 * return
 */
- (unsigned char)getDataAttr:(NSString*)sBlockName fieldID:(NSString*)fieldID index:(int)index;

/**
 *  get Block data
 * param sBlockName : 블럭 이름
 * param sFieldName : 데이터 항목명
 * param nRecIndex : 데이터 인덱스
 * 	return 데이터
 */
- (NSString*)getDataValue:(NSString*)sBlockName fieldID:(NSString*)fieldID index:(int)index;


- (NSArray*)getInputBlockNames;
- (NSArray*)getOutBlockNames;
-(NSArray*)getFieldNames:(NSString *)blockID;
- (BOOL)isAccountNoField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (BOOL)isEncryptField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (BOOL)isItemCodeField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (BOOL)isPasswordField:(NSString *)blockID fieldID:(NSString *)fieldID;
- (NSString*)getFieldName:(NSString*)blockID fieldID:(NSString*)fieldID;
@end

NS_ASSUME_NONNULL_END
