//
//  SmartChampTran.h
//  NetAPI
//
//  Created by aaab on 2023/01/05.
//

#import <Foundation/Foundation.h>
#import "TranDataProc.h"

NS_ASSUME_NONNULL_BEGIN
@protocol ITranDataDelegate;
@interface SmartChampTran : TranDataProc


- (id)initWithTrCode:(NSString*)trCode delegate:(id<ITranDataDelegate>)delegate;

- (void)setDelegate:(id<ITranDataDelegate>)delegate;

- (void)setQueryFile:(NSString*)strCode;

- (void)setDataHeader:(NSString*)strKey data:(NSString*)strData;

- (void)setScreenNo:(NSString*)strScreenNo;

- (void)clearInputData;

- (void)clearOutputData;

- (void)setDataValue:(NSString*)block fieldID:(NSString *)field index:(int)nIndex value:(NSString *)value;

- (NSString*)getDataValue:(NSString*)block fieldID:(NSString*)field index:(int)nIndex;

- (int)getDataAttr:(NSString*)block fieldID:(NSString*)field index:(int)nIndex;

- (int)requestData;

- (int)requestNextData;

- (BOOL)isMoreNextData;

- (int)getDataCount:(NSString*)block;

- (NSString*)getDataMsgText;

- (NSString*)getDataMsgCode;

- (void)setTranID:(NSString*)tranID;

- (NSString*)getTranID;

- (NSArray*)getInputBlockName;
- (NSArray*)getOutBlockName;
- (BOOL)isAccountNoField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (BOOL)isEncryptField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (BOOL)isItemCodeField:(NSString*)blockID fieldID:(NSString*)fieldID;
- (NSString*)getFieldName:(NSString*)blockID fieldID:(NSString*)fieldID;
- (BOOL)isPasswordField:(NSString *)blockID fieldID:(NSString *)fieldID;
@end

NS_ASSUME_NONNULL_END
